/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about properties for a numeric question in an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormNumericQuestionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormNumericQuestionProperties.Builder, EvaluationFormNumericQuestionProperties> {
    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinValue").getter(getter(EvaluationFormNumericQuestionProperties::minValue))
            .setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxValue").getter(getter(EvaluationFormNumericQuestionProperties::maxValue))
            .setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final SdkField<List<EvaluationFormNumericQuestionOption>> OPTIONS_FIELD = SdkField
            .<List<EvaluationFormNumericQuestionOption>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(EvaluationFormNumericQuestionProperties::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormNumericQuestionOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormNumericQuestionOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EvaluationFormNumericQuestionAutomation> AUTOMATION_FIELD = SdkField
            .<EvaluationFormNumericQuestionAutomation> builder(MarshallingType.SDK_POJO).memberName("Automation")
            .getter(getter(EvaluationFormNumericQuestionProperties::automation)).setter(setter(Builder::automation))
            .constructor(EvaluationFormNumericQuestionAutomation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_VALUE_FIELD,
            MAX_VALUE_FIELD, OPTIONS_FIELD, AUTOMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minValue;

    private final Integer maxValue;

    private final List<EvaluationFormNumericQuestionOption> options;

    private final EvaluationFormNumericQuestionAutomation automation;

    private EvaluationFormNumericQuestionProperties(BuilderImpl builder) {
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.options = builder.options;
        this.automation = builder.automation;
    }

    /**
     * <p>
     * The minimum answer value.
     * </p>
     * 
     * @return The minimum answer value.
     */
    public final Integer minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum answer value.
     * </p>
     * 
     * @return The maximum answer value.
     */
    public final Integer maxValue() {
        return maxValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scoring options of the numeric question.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The scoring options of the numeric question.
     */
    public final List<EvaluationFormNumericQuestionOption> options() {
        return options;
    }

    /**
     * <p>
     * The automation properties of the numeric question.
     * </p>
     * 
     * @return The automation properties of the numeric question.
     */
    public final EvaluationFormNumericQuestionAutomation automation() {
        return automation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormNumericQuestionProperties)) {
            return false;
        }
        EvaluationFormNumericQuestionProperties other = (EvaluationFormNumericQuestionProperties) obj;
        return Objects.equals(minValue(), other.minValue()) && Objects.equals(maxValue(), other.maxValue())
                && hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && Objects.equals(automation(), other.automation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormNumericQuestionProperties").add("MinValue", minValue())
                .add("MaxValue", maxValue()).add("Options", hasOptions() ? options() : null).add("Automation", automation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Automation":
            return Optional.ofNullable(clazz.cast(automation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormNumericQuestionProperties, T> g) {
        return obj -> g.apply((EvaluationFormNumericQuestionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormNumericQuestionProperties> {
        /**
         * <p>
         * The minimum answer value.
         * </p>
         * 
         * @param minValue
         *        The minimum answer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Integer minValue);

        /**
         * <p>
         * The maximum answer value.
         * </p>
         * 
         * @param maxValue
         *        The maximum answer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Integer maxValue);

        /**
         * <p>
         * The scoring options of the numeric question.
         * </p>
         * 
         * @param options
         *        The scoring options of the numeric question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<EvaluationFormNumericQuestionOption> options);

        /**
         * <p>
         * The scoring options of the numeric question.
         * </p>
         * 
         * @param options
         *        The scoring options of the numeric question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(EvaluationFormNumericQuestionOption... options);

        /**
         * <p>
         * The scoring options of the numeric question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption.Builder#build()} is
         * called immediately and its result is passed to {@link #options(List<EvaluationFormNumericQuestionOption>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<EvaluationFormNumericQuestionOption>)
         */
        Builder options(Consumer<EvaluationFormNumericQuestionOption.Builder>... options);

        /**
         * <p>
         * The automation properties of the numeric question.
         * </p>
         * 
         * @param automation
         *        The automation properties of the numeric question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(EvaluationFormNumericQuestionAutomation automation);

        /**
         * <p>
         * The automation properties of the numeric question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormNumericQuestionAutomation.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormNumericQuestionAutomation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormNumericQuestionAutomation.Builder#build()} is
         * called immediately and its result is passed to {@link #automation(EvaluationFormNumericQuestionAutomation)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link EvaluationFormNumericQuestionAutomation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(EvaluationFormNumericQuestionAutomation)
         */
        default Builder automation(Consumer<EvaluationFormNumericQuestionAutomation.Builder> automation) {
            return automation(EvaluationFormNumericQuestionAutomation.builder().applyMutation(automation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer minValue;

        private Integer maxValue;

        private List<EvaluationFormNumericQuestionOption> options = DefaultSdkAutoConstructList.getInstance();

        private EvaluationFormNumericQuestionAutomation automation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormNumericQuestionProperties model) {
            minValue(model.minValue);
            maxValue(model.maxValue);
            options(model.options);
            automation(model.automation);
        }

        public final Integer getMinValue() {
            return minValue;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Integer getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final List<EvaluationFormNumericQuestionOption.Builder> getOptions() {
            List<EvaluationFormNumericQuestionOption.Builder> result = EvaluationFormNumericQuestionOptionListCopier
                    .copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormNumericQuestionOption.BuilderImpl> options) {
            this.options = EvaluationFormNumericQuestionOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormNumericQuestionOption> options) {
            this.options = EvaluationFormNumericQuestionOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormNumericQuestionOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormNumericQuestionOption.Builder>... options) {
            options(Stream.of(options).map(c -> EvaluationFormNumericQuestionOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormNumericQuestionAutomation.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        public final void setAutomation(EvaluationFormNumericQuestionAutomation.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        @Override
        public final Builder automation(EvaluationFormNumericQuestionAutomation automation) {
            this.automation = automation;
            return this;
        }

        @Override
        public EvaluationFormNumericQuestionProperties build() {
            return new EvaluationFormNumericQuestionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
