/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIcd10CmInferenceJobResponse extends ComprehendMedicalResponse implements
        ToCopyableBuilder<DescribeIcd10CmInferenceJobResponse.Builder, DescribeIcd10CmInferenceJobResponse> {
    private static final SdkField<ComprehendMedicalAsyncJobProperties> COMPREHEND_MEDICAL_ASYNC_JOB_PROPERTIES_FIELD = SdkField
            .<ComprehendMedicalAsyncJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("ComprehendMedicalAsyncJobProperties")
            .getter(getter(DescribeIcd10CmInferenceJobResponse::comprehendMedicalAsyncJobProperties))
            .setter(setter(Builder::comprehendMedicalAsyncJobProperties))
            .constructor(ComprehendMedicalAsyncJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ComprehendMedicalAsyncJobProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMPREHEND_MEDICAL_ASYNC_JOB_PROPERTIES_FIELD));

    private final ComprehendMedicalAsyncJobProperties comprehendMedicalAsyncJobProperties;

    private DescribeIcd10CmInferenceJobResponse(BuilderImpl builder) {
        super(builder);
        this.comprehendMedicalAsyncJobProperties = builder.comprehendMedicalAsyncJobProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with a detection job.
     * </p>
     * 
     * @return An object that contains the properties associated with a detection job.
     */
    public final ComprehendMedicalAsyncJobProperties comprehendMedicalAsyncJobProperties() {
        return comprehendMedicalAsyncJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(comprehendMedicalAsyncJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIcd10CmInferenceJobResponse)) {
            return false;
        }
        DescribeIcd10CmInferenceJobResponse other = (DescribeIcd10CmInferenceJobResponse) obj;
        return Objects.equals(comprehendMedicalAsyncJobProperties(), other.comprehendMedicalAsyncJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIcd10CmInferenceJobResponse")
                .add("ComprehendMedicalAsyncJobProperties", comprehendMedicalAsyncJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComprehendMedicalAsyncJobProperties":
            return Optional.ofNullable(clazz.cast(comprehendMedicalAsyncJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIcd10CmInferenceJobResponse, T> g) {
        return obj -> g.apply((DescribeIcd10CmInferenceJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendMedicalResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIcd10CmInferenceJobResponse> {
        /**
         * <p>
         * An object that contains the properties associated with a detection job.
         * </p>
         * 
         * @param comprehendMedicalAsyncJobProperties
         *        An object that contains the properties associated with a detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comprehendMedicalAsyncJobProperties(ComprehendMedicalAsyncJobProperties comprehendMedicalAsyncJobProperties);

        /**
         * <p>
         * An object that contains the properties associated with a detection job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ComprehendMedicalAsyncJobProperties.Builder} avoiding the need to create one manually via
         * {@link ComprehendMedicalAsyncJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComprehendMedicalAsyncJobProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #comprehendMedicalAsyncJobProperties(ComprehendMedicalAsyncJobProperties)}.
         * 
         * @param comprehendMedicalAsyncJobProperties
         *        a consumer that will call methods on {@link ComprehendMedicalAsyncJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comprehendMedicalAsyncJobProperties(ComprehendMedicalAsyncJobProperties)
         */
        default Builder comprehendMedicalAsyncJobProperties(
                Consumer<ComprehendMedicalAsyncJobProperties.Builder> comprehendMedicalAsyncJobProperties) {
            return comprehendMedicalAsyncJobProperties(ComprehendMedicalAsyncJobProperties.builder()
                    .applyMutation(comprehendMedicalAsyncJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendMedicalResponse.BuilderImpl implements Builder {
        private ComprehendMedicalAsyncJobProperties comprehendMedicalAsyncJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIcd10CmInferenceJobResponse model) {
            super(model);
            comprehendMedicalAsyncJobProperties(model.comprehendMedicalAsyncJobProperties);
        }

        public final ComprehendMedicalAsyncJobProperties.Builder getComprehendMedicalAsyncJobProperties() {
            return comprehendMedicalAsyncJobProperties != null ? comprehendMedicalAsyncJobProperties.toBuilder() : null;
        }

        public final void setComprehendMedicalAsyncJobProperties(
                ComprehendMedicalAsyncJobProperties.BuilderImpl comprehendMedicalAsyncJobProperties) {
            this.comprehendMedicalAsyncJobProperties = comprehendMedicalAsyncJobProperties != null ? comprehendMedicalAsyncJobProperties
                    .build() : null;
        }

        @Override
        public final Builder comprehendMedicalAsyncJobProperties(
                ComprehendMedicalAsyncJobProperties comprehendMedicalAsyncJobProperties) {
            this.comprehendMedicalAsyncJobProperties = comprehendMedicalAsyncJobProperties;
            return this;
        }

        @Override
        public DescribeIcd10CmInferenceJobResponse build() {
            return new DescribeIcd10CmInferenceJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
