/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging parameters of a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<LogConfigurationType.Builder, LogConfigurationType> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(LogConfigurationType::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()).build();

    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSource").getter(getter(LogConfigurationType::eventSourceAsString))
            .setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()).build();

    private static final SdkField<CloudWatchLogsConfigurationType> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField
            .<CloudWatchLogsConfigurationType> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLogsConfiguration")
            .getter(getter(LogConfigurationType::cloudWatchLogsConfiguration))
            .setter(setter(Builder::cloudWatchLogsConfiguration))
            .constructor(CloudWatchLogsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD,
            EVENT_SOURCE_FIELD, CLOUD_WATCH_LOGS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logLevel;

    private final String eventSource;

    private final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;

    private LogConfigurationType(BuilderImpl builder) {
        this.logLevel = builder.logLevel;
        this.eventSource = builder.eventSource;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * <p>
     * The source of events that your user pool sends for detailed activity logging.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceAsString}.
     * </p>
     * 
     * @return The source of events that your user pool sends for detailed activity logging.
     * @see EventSourceName
     */
    public final EventSourceName eventSource() {
        return EventSourceName.fromValue(eventSource);
    }

    /**
     * <p>
     * The source of events that your user pool sends for detailed activity logging.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSource} will
     * return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventSourceAsString}.
     * </p>
     * 
     * @return The source of events that your user pool sends for detailed activity logging.
     * @see EventSourceName
     */
    public final String eventSourceAsString() {
        return eventSource;
    }

    /**
     * <p>
     * The CloudWatch logging destination of a user pool.
     * </p>
     * 
     * @return The CloudWatch logging destination of a user pool.
     */
    public final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurationType)) {
            return false;
        }
        LogConfigurationType other = (LogConfigurationType) obj;
        return Objects.equals(logLevelAsString(), other.logLevelAsString())
                && Objects.equals(eventSourceAsString(), other.eventSourceAsString())
                && Objects.equals(cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfigurationType").add("LogLevel", logLevelAsString())
                .add("EventSource", eventSourceAsString()).add("CloudWatchLogsConfiguration", cloudWatchLogsConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "EventSource":
            return Optional.ofNullable(clazz.cast(eventSourceAsString()));
        case "CloudWatchLogsConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfigurationType, T> g) {
        return obj -> g.apply((LogConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfigurationType> {
        /**
         * <p>
         * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
         * </p>
         * 
         * @param logLevel
         *        The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
         * </p>
         * 
         * @param logLevel
         *        The <code>errorlevel</code> selection of logs that a user pool sends for detailed activity logging.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * <p>
         * The source of events that your user pool sends for detailed activity logging.
         * </p>
         * 
         * @param eventSource
         *        The source of events that your user pool sends for detailed activity logging.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The source of events that your user pool sends for detailed activity logging.
         * </p>
         * 
         * @param eventSource
         *        The source of events that your user pool sends for detailed activity logging.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSource(EventSourceName eventSource);

        /**
         * <p>
         * The CloudWatch logging destination of a user pool.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        The CloudWatch logging destination of a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType cloudWatchLogsConfiguration);

        /**
         * <p>
         * The CloudWatch logging destination of a user pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsConfigurationType.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsConfigurationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsConfigurationType.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType)}.
         * 
         * @param cloudWatchLogsConfiguration
         *        a consumer that will call methods on {@link CloudWatchLogsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType)
         */
        default Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfigurationType.Builder> cloudWatchLogsConfiguration) {
            return cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType.builder()
                    .applyMutation(cloudWatchLogsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String logLevel;

        private String eventSource;

        private CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfigurationType model) {
            logLevel(model.logLevel);
            eventSource(model.eventSource);
            cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getEventSource() {
            return eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSourceName eventSource) {
            this.eventSource(eventSource == null ? null : eventSource.toString());
            return this;
        }

        public final CloudWatchLogsConfigurationType.Builder getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfigurationType.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        @Override
        public LogConfigurationType build() {
            return new LogConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
