/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>PutApprovalResult</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutApprovalResultResponse extends CodePipelineResponse implements
        ToCopyableBuilder<PutApprovalResultResponse.Builder, PutApprovalResultResponse> {
    private static final SdkField<Instant> APPROVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("approvedAt").getter(getter(PutApprovalResultResponse::approvedAt)).setter(setter(Builder::approvedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVED_AT_FIELD));

    private final Instant approvedAt;

    private PutApprovalResultResponse(BuilderImpl builder) {
        super(builder);
        this.approvedAt = builder.approvedAt;
    }

    /**
     * <p>
     * The timestamp showing when the approval or rejection was submitted.
     * </p>
     * 
     * @return The timestamp showing when the approval or rejection was submitted.
     */
    public final Instant approvedAt() {
        return approvedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApprovalResultResponse)) {
            return false;
        }
        PutApprovalResultResponse other = (PutApprovalResultResponse) obj;
        return Objects.equals(approvedAt(), other.approvedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutApprovalResultResponse").add("ApprovedAt", approvedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvedAt":
            return Optional.ofNullable(clazz.cast(approvedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutApprovalResultResponse, T> g) {
        return obj -> g.apply((PutApprovalResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutApprovalResultResponse> {
        /**
         * <p>
         * The timestamp showing when the approval or rejection was submitted.
         * </p>
         * 
         * @param approvedAt
         *        The timestamp showing when the approval or rejection was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedAt(Instant approvedAt);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private Instant approvedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApprovalResultResponse model) {
            super(model);
            approvedAt(model.approvedAt);
        }

        public final Instant getApprovedAt() {
            return approvedAt;
        }

        public final void setApprovedAt(Instant approvedAt) {
            this.approvedAt = approvedAt;
        }

        @Override
        public final Builder approvedAt(Instant approvedAt) {
            this.approvedAt = approvedAt;
            return this;
        }

        @Override
        public PutApprovalResultResponse build() {
            return new PutApprovalResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
