/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the output of an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputArtifact implements SdkPojo, Serializable, ToCopyableBuilder<OutputArtifact.Builder, OutputArtifact> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(OutputArtifact::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private OutputArtifact(BuilderImpl builder) {
        this.name = builder.name;
    }

    /**
     * <p>
     * The name of the output of an artifact, such as "My App".
     * </p>
     * <p>
     * The input artifact of an action must exactly match the output artifact declared in a preceding action, but the
     * input artifact does not have to be the next action in strict sequence from the action that provided the output
     * artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different
     * following actions.
     * </p>
     * <p>
     * Output artifact names must be unique within a pipeline.
     * </p>
     * 
     * @return The name of the output of an artifact, such as "My App".</p>
     *         <p>
     *         The input artifact of an action must exactly match the output artifact declared in a preceding action,
     *         but the input artifact does not have to be the next action in strict sequence from the action that
     *         provided the output artifact. Actions in parallel can declare different output artifacts, which are in
     *         turn consumed by different following actions.
     *         </p>
     *         <p>
     *         Output artifact names must be unique within a pipeline.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputArtifact)) {
            return false;
        }
        OutputArtifact other = (OutputArtifact) obj;
        return Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputArtifact").add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputArtifact, T> g) {
        return obj -> g.apply((OutputArtifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputArtifact> {
        /**
         * <p>
         * The name of the output of an artifact, such as "My App".
         * </p>
         * <p>
         * The input artifact of an action must exactly match the output artifact declared in a preceding action, but
         * the input artifact does not have to be the next action in strict sequence from the action that provided the
         * output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by
         * different following actions.
         * </p>
         * <p>
         * Output artifact names must be unique within a pipeline.
         * </p>
         * 
         * @param name
         *        The name of the output of an artifact, such as "My App".</p>
         *        <p>
         *        The input artifact of an action must exactly match the output artifact declared in a preceding action,
         *        but the input artifact does not have to be the next action in strict sequence from the action that
         *        provided the output artifact. Actions in parallel can declare different output artifacts, which are in
         *        turn consumed by different following actions.
         *        </p>
         *        <p>
         *        Output artifact names must be unique within a pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputArtifact model) {
            name(model.name);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public OutputArtifact build() {
            return new OutputArtifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
