/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a CreateCustomActionType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomActionTypeRequest extends CodePipelineRequest implements
        ToCopyableBuilder<CreateCustomActionTypeRequest.Builder, CreateCustomActionTypeRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(CreateCustomActionTypeRequest::categoryAsString))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(CreateCustomActionTypeRequest::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CreateCustomActionTypeRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<ActionTypeSettings> SETTINGS_FIELD = SdkField
            .<ActionTypeSettings> builder(MarshallingType.SDK_POJO).memberName("settings")
            .getter(getter(CreateCustomActionTypeRequest::settings)).setter(setter(Builder::settings))
            .constructor(ActionTypeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<List<ActionConfigurationProperty>> CONFIGURATION_PROPERTIES_FIELD = SdkField
            .<List<ActionConfigurationProperty>> builder(MarshallingType.LIST)
            .memberName("configurationProperties")
            .getter(getter(CreateCustomActionTypeRequest::configurationProperties))
            .setter(setter(Builder::configurationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionConfigurationProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionConfigurationProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField
            .<ArtifactDetails> builder(MarshallingType.SDK_POJO).memberName("inputArtifactDetails")
            .getter(getter(CreateCustomActionTypeRequest::inputArtifactDetails)).setter(setter(Builder::inputArtifactDetails))
            .constructor(ArtifactDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build())
            .build();

    private static final SdkField<ArtifactDetails> OUTPUT_ARTIFACT_DETAILS_FIELD = SdkField
            .<ArtifactDetails> builder(MarshallingType.SDK_POJO).memberName("outputArtifactDetails")
            .getter(getter(CreateCustomActionTypeRequest::outputArtifactDetails)).setter(setter(Builder::outputArtifactDetails))
            .constructor(ArtifactDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifactDetails").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCustomActionTypeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            PROVIDER_FIELD, VERSION_FIELD, SETTINGS_FIELD, CONFIGURATION_PROPERTIES_FIELD, INPUT_ARTIFACT_DETAILS_FIELD,
            OUTPUT_ARTIFACT_DETAILS_FIELD, TAGS_FIELD));

    private final String category;

    private final String provider;

    private final String version;

    private final ActionTypeSettings settings;

    private final List<ActionConfigurationProperty> configurationProperties;

    private final ArtifactDetails inputArtifactDetails;

    private final ArtifactDetails outputArtifactDetails;

    private final List<Tag> tags;

    private CreateCustomActionTypeRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.provider = builder.provider;
        this.version = builder.version;
        this.settings = builder.settings;
        this.configurationProperties = builder.configurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The category of the custom action, such as a build action or a test action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the custom action, such as a build action or a test action.
     * @see ActionCategory
     */
    public final ActionCategory category() {
        return ActionCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of the custom action, such as a build action or a test action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the custom action, such as a build action or a test action.
     * @see ActionCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The provider of the service used in the custom action, such as CodeDeploy.
     * </p>
     * 
     * @return The provider of the service used in the custom action, such as CodeDeploy.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The version identifier of the custom action.
     * </p>
     * 
     * @return The version identifier of the custom action.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * URLs that provide users information about this custom action.
     * </p>
     * 
     * @return URLs that provide users information about this custom action.
     */
    public final ActionTypeSettings settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationProperties() {
        return configurationProperties != null && !(configurationProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration properties for the custom action.
     * </p>
     * <note>
     * <p>
     * You can refer to a name in the configuration properties of the custom action within the URL templates by
     * following the format of {Config:name}, as long as the configuration property is both required and not secret. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom
     * Action for a Pipeline</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationProperties} method.
     * </p>
     * 
     * @return The configuration properties for the custom action.</p> <note>
     *         <p>
     *         You can refer to a name in the configuration properties of the custom action within the URL templates by
     *         following the format of {Config:name}, as long as the configuration property is both required and not
     *         secret. For more information, see <a
     *         href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create
     *         a Custom Action for a Pipeline</a>.
     *         </p>
     */
    public final List<ActionConfigurationProperty> configurationProperties() {
        return configurationProperties;
    }

    /**
     * <p>
     * The details of the input artifact for the action, such as its commit ID.
     * </p>
     * 
     * @return The details of the input artifact for the action, such as its commit ID.
     */
    public final ArtifactDetails inputArtifactDetails() {
        return inputArtifactDetails;
    }

    /**
     * <p>
     * The details of the output artifact of the action, such as its commit ID.
     * </p>
     * 
     * @return The details of the output artifact of the action, such as its commit ID.
     */
    public final ArtifactDetails outputArtifactDetails() {
        return outputArtifactDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the custom action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the custom action.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationProperties() ? configurationProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(outputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomActionTypeRequest)) {
            return false;
        }
        CreateCustomActionTypeRequest other = (CreateCustomActionTypeRequest) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(provider(), other.provider())
                && Objects.equals(version(), other.version()) && Objects.equals(settings(), other.settings())
                && hasConfigurationProperties() == other.hasConfigurationProperties()
                && Objects.equals(configurationProperties(), other.configurationProperties())
                && Objects.equals(inputArtifactDetails(), other.inputArtifactDetails())
                && Objects.equals(outputArtifactDetails(), other.outputArtifactDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomActionTypeRequest").add("Category", categoryAsString()).add("Provider", provider())
                .add("Version", version()).add("Settings", settings())
                .add("ConfigurationProperties", hasConfigurationProperties() ? configurationProperties() : null)
                .add("InputArtifactDetails", inputArtifactDetails()).add("OutputArtifactDetails", outputArtifactDetails())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "configurationProperties":
            return Optional.ofNullable(clazz.cast(configurationProperties()));
        case "inputArtifactDetails":
            return Optional.ofNullable(clazz.cast(inputArtifactDetails()));
        case "outputArtifactDetails":
            return Optional.ofNullable(clazz.cast(outputArtifactDetails()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomActionTypeRequest, T> g) {
        return obj -> g.apply((CreateCustomActionTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomActionTypeRequest> {
        /**
         * <p>
         * The category of the custom action, such as a build action or a test action.
         * </p>
         * 
         * @param category
         *        The category of the custom action, such as a build action or a test action.
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the custom action, such as a build action or a test action.
         * </p>
         * 
         * @param category
         *        The category of the custom action, such as a build action or a test action.
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(ActionCategory category);

        /**
         * <p>
         * The provider of the service used in the custom action, such as CodeDeploy.
         * </p>
         * 
         * @param provider
         *        The provider of the service used in the custom action, such as CodeDeploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The version identifier of the custom action.
         * </p>
         * 
         * @param version
         *        The version identifier of the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * URLs that provide users information about this custom action.
         * </p>
         * 
         * @param settings
         *        URLs that provide users information about this custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(ActionTypeSettings settings);

        /**
         * <p>
         * URLs that provide users information about this custom action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeSettings.Builder} avoiding the
         * need to create one manually via {@link ActionTypeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #settings(ActionTypeSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link ActionTypeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(ActionTypeSettings)
         */
        default Builder settings(Consumer<ActionTypeSettings.Builder> settings) {
            return settings(ActionTypeSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * The configuration properties for the custom action.
         * </p>
         * <note>
         * <p>
         * You can refer to a name in the configuration properties of the custom action within the URL templates by
         * following the format of {Config:name}, as long as the configuration property is both required and not secret.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a
         * Custom Action for a Pipeline</a>.
         * </p>
         * </note>
         * 
         * @param configurationProperties
         *        The configuration properties for the custom action.</p> <note>
         *        <p>
         *        You can refer to a name in the configuration properties of the custom action within the URL templates
         *        by following the format of {Config:name}, as long as the configuration property is both required and
         *        not secret. For more information, see <a
         *        href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html"
         *        >Create a Custom Action for a Pipeline</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProperties(Collection<ActionConfigurationProperty> configurationProperties);

        /**
         * <p>
         * The configuration properties for the custom action.
         * </p>
         * <note>
         * <p>
         * You can refer to a name in the configuration properties of the custom action within the URL templates by
         * following the format of {Config:name}, as long as the configuration property is both required and not secret.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a
         * Custom Action for a Pipeline</a>.
         * </p>
         * </note>
         * 
         * @param configurationProperties
         *        The configuration properties for the custom action.</p> <note>
         *        <p>
         *        You can refer to a name in the configuration properties of the custom action within the URL templates
         *        by following the format of {Config:name}, as long as the configuration property is both required and
         *        not secret. For more information, see <a
         *        href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html"
         *        >Create a Custom Action for a Pipeline</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProperties(ActionConfigurationProperty... configurationProperties);

        /**
         * <p>
         * The configuration properties for the custom action.
         * </p>
         * <note>
         * <p>
         * You can refer to a name in the configuration properties of the custom action within the URL templates by
         * following the format of {Config:name}, as long as the configuration property is both required and not secret.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a
         * Custom Action for a Pipeline</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #configurationProperties(List<ActionConfigurationProperty>)}.
         * 
         * @param configurationProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationProperties(java.util.Collection<ActionConfigurationProperty>)
         */
        Builder configurationProperties(Consumer<ActionConfigurationProperty.Builder>... configurationProperties);

        /**
         * <p>
         * The details of the input artifact for the action, such as its commit ID.
         * </p>
         * 
         * @param inputArtifactDetails
         *        The details of the input artifact for the action, such as its commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails);

        /**
         * <p>
         * The details of the input artifact for the action, such as its commit ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArtifactDetails.Builder} avoiding the
         * need to create one manually via {@link ArtifactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArtifactDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #inputArtifactDetails(ArtifactDetails)}.
         * 
         * @param inputArtifactDetails
         *        a consumer that will call methods on {@link ArtifactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputArtifactDetails(ArtifactDetails)
         */
        default Builder inputArtifactDetails(Consumer<ArtifactDetails.Builder> inputArtifactDetails) {
            return inputArtifactDetails(ArtifactDetails.builder().applyMutation(inputArtifactDetails).build());
        }

        /**
         * <p>
         * The details of the output artifact of the action, such as its commit ID.
         * </p>
         * 
         * @param outputArtifactDetails
         *        The details of the output artifact of the action, such as its commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails);

        /**
         * <p>
         * The details of the output artifact of the action, such as its commit ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArtifactDetails.Builder} avoiding the
         * need to create one manually via {@link ArtifactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArtifactDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #outputArtifactDetails(ArtifactDetails)}.
         * 
         * @param outputArtifactDetails
         *        a consumer that will call methods on {@link ArtifactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputArtifactDetails(ArtifactDetails)
         */
        default Builder outputArtifactDetails(Consumer<ArtifactDetails.Builder> outputArtifactDetails) {
            return outputArtifactDetails(ArtifactDetails.builder().applyMutation(outputArtifactDetails).build());
        }

        /**
         * <p>
         * The tags for the custom action.
         * </p>
         * 
         * @param tags
         *        The tags for the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the custom action.
         * </p>
         * 
         * @param tags
         *        The tags for the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the custom action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codepipeline.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String category;

        private String provider;

        private String version;

        private ActionTypeSettings settings;

        private List<ActionConfigurationProperty> configurationProperties = DefaultSdkAutoConstructList.getInstance();

        private ArtifactDetails inputArtifactDetails;

        private ArtifactDetails outputArtifactDetails;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomActionTypeRequest model) {
            super(model);
            category(model.category);
            provider(model.provider);
            version(model.version);
            settings(model.settings);
            configurationProperties(model.configurationProperties);
            inputArtifactDetails(model.inputArtifactDetails);
            outputArtifactDetails(model.outputArtifactDetails);
            tags(model.tags);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final ActionTypeSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(ActionTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(ActionTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<ActionConfigurationProperty.Builder> getConfigurationProperties() {
            List<ActionConfigurationProperty.Builder> result = ActionConfigurationPropertyListCopier
                    .copyToBuilder(this.configurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationProperties(Collection<ActionConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copyFromBuilder(configurationProperties);
        }

        @Override
        public final Builder configurationProperties(Collection<ActionConfigurationProperty> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(ActionConfigurationProperty... configurationProperties) {
            configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(Consumer<ActionConfigurationProperty.Builder>... configurationProperties) {
            configurationProperties(Stream.of(configurationProperties)
                    .map(c -> ActionConfigurationProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return inputArtifactDetails != null ? inputArtifactDetails.toBuilder() : null;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final ArtifactDetails.Builder getOutputArtifactDetails() {
            return outputArtifactDetails != null ? outputArtifactDetails.toBuilder() : null;
        }

        public final void setOutputArtifactDetails(ArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomActionTypeRequest build() {
            return new CreateCustomActionTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
