/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a specific approval on a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Approval implements SdkPojo, Serializable, ToCopyableBuilder<Approval.Builder, Approval> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userArn").getter(getter(Approval::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> APPROVAL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalState").getter(getter(Approval::approvalStateAsString)).setter(setter(Builder::approvalState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD,
            APPROVAL_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userArn;

    private final String approvalState;

    private Approval(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.approvalState = builder.approvalState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalState}
     * will return {@link ApprovalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalStateAsString}.
     * </p>
     * 
     * @return The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
     * @see ApprovalState
     */
    public final ApprovalState approvalState() {
        return ApprovalState.fromValue(approvalState);
    }

    /**
     * <p>
     * The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalState}
     * will return {@link ApprovalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalStateAsString}.
     * </p>
     * 
     * @return The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
     * @see ApprovalState
     */
    public final String approvalStateAsString() {
        return approvalState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(approvalStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Approval)) {
            return false;
        }
        Approval other = (Approval) obj;
        return Objects.equals(userArn(), other.userArn())
                && Objects.equals(approvalStateAsString(), other.approvalStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Approval").add("UserArn", userArn()).add("ApprovalState", approvalStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "approvalState":
            return Optional.ofNullable(clazz.cast(approvalStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Approval, T> g) {
        return obj -> g.apply((Approval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Approval> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
         * </p>
         * 
         * @param approvalState
         *        The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
         * @see ApprovalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalState
         */
        Builder approvalState(String approvalState);

        /**
         * <p>
         * The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
         * </p>
         * 
         * @param approvalState
         *        The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.
         * @see ApprovalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalState
         */
        Builder approvalState(ApprovalState approvalState);
    }

    static final class BuilderImpl implements Builder {
        private String userArn;

        private String approvalState;

        private BuilderImpl() {
        }

        private BuilderImpl(Approval model) {
            userArn(model.userArn);
            approvalState(model.approvalState);
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getApprovalState() {
            return approvalState;
        }

        public final void setApprovalState(String approvalState) {
            this.approvalState = approvalState;
        }

        @Override
        public final Builder approvalState(String approvalState) {
            this.approvalState = approvalState;
            return this;
        }

        @Override
        public final Builder approvalState(ApprovalState approvalState) {
            this.approvalState(approvalState == null ? null : approvalState.toString());
            return this;
        }

        @Override
        public Approval build() {
            return new Approval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
