/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A named expression that can be evaluated at search time. Can be used to sort the search results, define other
 * expressions, or return computed information in the search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Expression implements SdkPojo, Serializable, ToCopyableBuilder<Expression.Builder, Expression> {
    private static final SdkField<String> EXPRESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpressionName").getter(getter(Expression::expressionName)).setter(setter(Builder::expressionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionName").build()).build();

    private static final SdkField<String> EXPRESSION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpressionValue").getter(getter(Expression::expressionValue)).setter(setter(Builder::expressionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_NAME_FIELD,
            EXPRESSION_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expressionName;

    private final String expressionValue;

    private Expression(BuilderImpl builder) {
        this.expressionName = builder.expressionName;
        this.expressionValue = builder.expressionValue;
    }

    /**
     * Returns the value of the ExpressionName property for this object.
     * 
     * @return The value of the ExpressionName property for this object.
     */
    public final String expressionName() {
        return expressionName;
    }

    /**
     * Returns the value of the ExpressionValue property for this object.
     * 
     * @return The value of the ExpressionValue property for this object.
     */
    public final String expressionValue() {
        return expressionValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expressionName());
        hashCode = 31 * hashCode + Objects.hashCode(expressionValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression) obj;
        return Objects.equals(expressionName(), other.expressionName())
                && Objects.equals(expressionValue(), other.expressionValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Expression").add("ExpressionName", expressionName()).add("ExpressionValue", expressionValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpressionName":
            return Optional.ofNullable(clazz.cast(expressionName()));
        case "ExpressionValue":
            return Optional.ofNullable(clazz.cast(expressionValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Expression> {
        /**
         * Sets the value of the ExpressionName property for this object.
         *
         * @param expressionName
         *        The new value for the ExpressionName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionName(String expressionName);

        /**
         * Sets the value of the ExpressionValue property for this object.
         *
         * @param expressionValue
         *        The new value for the ExpressionValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionValue(String expressionValue);
    }

    static final class BuilderImpl implements Builder {
        private String expressionName;

        private String expressionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            expressionName(model.expressionName);
            expressionValue(model.expressionValue);
        }

        public final String getExpressionName() {
            return expressionName;
        }

        public final void setExpressionName(String expressionName) {
            this.expressionName = expressionName;
        }

        @Override
        public final Builder expressionName(String expressionName) {
            this.expressionName = expressionName;
            return this;
        }

        public final String getExpressionValue() {
            return expressionValue;
        }

        public final void setExpressionValue(String expressionValue) {
            this.expressionValue = expressionValue;
        }

        @Override
        public final Builder expressionValue(String expressionValue) {
            this.expressionValue = expressionValue;
            return this;
        }

        @Override
        public Expression build() {
            return new Expression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
