/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudsearch.model.BaseException;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchException;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsRequest;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsResponse;
import software.amazon.awssdk.services.cloudsearch.model.InternalException;
import software.amazon.awssdk.services.cloudsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.cloudsearch.model.LimitExceededException;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.cloudsearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.ValidationException;

/**
 * Service client for accessing Amazon CloudSearch. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon CloudSearch Configuration Service</fullname>
 * <p>
 * You use the Amazon CloudSearch configuration service to create, configure, and manage search domains. Configuration
 * service requests are submitted using the AWS Query protocol. AWS Query requests are HTTP or HTTPS requests submitted
 * via HTTP GET or POST with a query parameter named Action.
 * </p>
 * <p>
 * The endpoint for configuration service requests is region-specific: cloudsearch.<i>region</i>.amazonaws.com. For
 * example, cloudsearch.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a
 * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cloudsearch_region" target="_blank">Regions and
 * Endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudSearchClient extends AwsClient {
    String SERVICE_NAME = "cloudsearch";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudsearch";

    /**
     * <p>
     * Indexes the search suggestions. For more information, see <a href=
     * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters"
     * >Configuring Suggesters</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param buildSuggestersRequest
     *        Container for the parameters to the <code><a>BuildSuggester</a></code> operation. Specifies the name of
     *        the domain you want to update.
     * @return Result of the BuildSuggesters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.BuildSuggesters
     */
    default BuildSuggestersResponse buildSuggesters(BuildSuggestersRequest buildSuggestersRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indexes the search suggestions. For more information, see <a href=
     * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters"
     * >Configuring Suggesters</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BuildSuggestersRequest.Builder} avoiding the need
     * to create one manually via {@link BuildSuggestersRequest#builder()}
     * </p>
     *
     * @param buildSuggestersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>BuildSuggester</a></code> operation. Specifies the
     *        name of the domain you want to update.
     * @return Result of the BuildSuggesters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.BuildSuggesters
     */
    default BuildSuggestersResponse buildSuggesters(Consumer<BuildSuggestersRequest.Builder> buildSuggestersRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        return buildSuggesters(BuildSuggestersRequest.builder().applyMutation(buildSuggestersRequest).build());
    }

    /**
     * <p>
     * Creates a new search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html"
     * target="_blank">Creating a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param createDomainRequest
     *        Container for the parameters to the <code><a>CreateDomain</a></code> operation. Specifies a name for the
     *        new search domain.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.CreateDomain
     */
    default CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws BaseException, InternalException,
            LimitExceededException, ResourceAlreadyExistsException, ValidationException, AwsServiceException, SdkClientException,
            CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html"
     * target="_blank">Creating a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>CreateDomain</a></code> operation. Specifies a name for the
     *        new search domain.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.CreateDomain
     */
    default CreateDomainResponse createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) throws BaseException,
            InternalException, LimitExceededException, ResourceAlreadyExistsException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Configures an analysis scheme that can be applied to a <code>text</code> or <code>text-array</code> field to
     * define language-specific text processing options. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineAnalysisSchemeRequest
     *        Container for the parameters to the <code><a>DefineAnalysisScheme</a></code> operation. Specifies the name
     *        of the domain you want to update and the analysis scheme configuration.
     * @return Result of the DefineAnalysisScheme operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineAnalysisScheme
     */
    default DefineAnalysisSchemeResponse defineAnalysisScheme(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest)
            throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an analysis scheme that can be applied to a <code>text</code> or <code>text-array</code> field to
     * define language-specific text processing options. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineAnalysisSchemeRequest.Builder} avoiding the
     * need to create one manually via {@link DefineAnalysisSchemeRequest#builder()}
     * </p>
     *
     * @param defineAnalysisSchemeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineAnalysisScheme</a></code> operation. Specifies
     *        the name of the domain you want to update and the analysis scheme configuration.
     * @return Result of the DefineAnalysisScheme operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineAnalysisScheme
     */
    default DefineAnalysisSchemeResponse defineAnalysisScheme(
            Consumer<DefineAnalysisSchemeRequest.Builder> defineAnalysisSchemeRequest) throws BaseException, InternalException,
            LimitExceededException, InvalidTypeException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        return defineAnalysisScheme(DefineAnalysisSchemeRequest.builder().applyMutation(defineAnalysisSchemeRequest).build());
    }

    /**
     * <p>
     * Configures an <code><a>Expression</a></code> for the search domain. Used to create new expressions and modify
     * existing ones. If the expression exists, the new configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineExpressionRequest
     *        Container for the parameters to the <code><a>DefineExpression</a></code> operation. Specifies the name of
     *        the domain you want to update and the expression you want to configure.
     * @return Result of the DefineExpression operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineExpression
     */
    default DefineExpressionResponse defineExpression(DefineExpressionRequest defineExpressionRequest) throws BaseException,
            InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an <code><a>Expression</a></code> for the search domain. Used to create new expressions and modify
     * existing ones. If the expression exists, the new configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineExpressionRequest.Builder} avoiding the need
     * to create one manually via {@link DefineExpressionRequest#builder()}
     * </p>
     *
     * @param defineExpressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineExpression</a></code> operation. Specifies the
     *        name of the domain you want to update and the expression you want to configure.
     * @return Result of the DefineExpression operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineExpression
     */
    default DefineExpressionResponse defineExpression(Consumer<DefineExpressionRequest.Builder> defineExpressionRequest)
            throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        return defineExpression(DefineExpressionRequest.builder().applyMutation(defineExpressionRequest).build());
    }

    /**
     * <p>
     * Configures an <code><a>IndexField</a></code> for the search domain. Used to create new fields and modify existing
     * ones. You must specify the name of the domain you are configuring and an index field configuration. The index
     * field configuration specifies a unique name, the index field type, and the options you want to configure for the
     * field. The options you can specify depend on the <code><a>IndexFieldType</a></code>. If the field exists, the new
     * configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineIndexFieldRequest
     *        Container for the parameters to the <code><a>DefineIndexField</a></code> operation. Specifies the name of
     *        the domain you want to update and the index field configuration.
     * @return Result of the DefineIndexField operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineIndexField
     */
    default DefineIndexFieldResponse defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) throws BaseException,
            InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an <code><a>IndexField</a></code> for the search domain. Used to create new fields and modify existing
     * ones. You must specify the name of the domain you are configuring and an index field configuration. The index
     * field configuration specifies a unique name, the index field type, and the options you want to configure for the
     * field. The options you can specify depend on the <code><a>IndexFieldType</a></code>. If the field exists, the new
     * configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineIndexFieldRequest.Builder} avoiding the need
     * to create one manually via {@link DefineIndexFieldRequest#builder()}
     * </p>
     *
     * @param defineIndexFieldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineIndexField</a></code> operation. Specifies the
     *        name of the domain you want to update and the index field configuration.
     * @return Result of the DefineIndexField operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineIndexField
     */
    default DefineIndexFieldResponse defineIndexField(Consumer<DefineIndexFieldRequest.Builder> defineIndexFieldRequest)
            throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        return defineIndexField(DefineIndexFieldRequest.builder().applyMutation(defineIndexFieldRequest).build());
    }

    /**
     * <p>
     * Configures a suggester for a domain. A suggester enables you to display possible matches before users finish
     * typing their queries. When you configure a suggester, you must specify the name of the text field you want to
     * search for possible matches and a unique name for the suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineSuggesterRequest
     *        Container for the parameters to the <code><a>DefineSuggester</a></code> operation. Specifies the name of
     *        the domain you want to update and the suggester configuration.
     * @return Result of the DefineSuggester operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineSuggester
     */
    default DefineSuggesterResponse defineSuggester(DefineSuggesterRequest defineSuggesterRequest) throws BaseException,
            InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures a suggester for a domain. A suggester enables you to display possible matches before users finish
     * typing their queries. When you configure a suggester, you must specify the name of the text field you want to
     * search for possible matches and a unique name for the suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineSuggesterRequest.Builder} avoiding the need
     * to create one manually via {@link DefineSuggesterRequest#builder()}
     * </p>
     *
     * @param defineSuggesterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineSuggester</a></code> operation. Specifies the
     *        name of the domain you want to update and the suggester configuration.
     * @return Result of the DefineSuggester operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DefineSuggester
     */
    default DefineSuggesterResponse defineSuggester(Consumer<DefineSuggesterRequest.Builder> defineSuggesterRequest)
            throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        return defineSuggester(DefineSuggesterRequest.builder().applyMutation(defineSuggesterRequest).build());
    }

    /**
     * <p>
     * Deletes an analysis scheme. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteAnalysisSchemeRequest
     *        Container for the parameters to the <code><a>DeleteAnalysisScheme</a></code> operation. Specifies the name
     *        of the domain you want to update and the analysis scheme you want to delete.
     * @return Result of the DeleteAnalysisScheme operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteAnalysisScheme
     */
    default DeleteAnalysisSchemeResponse deleteAnalysisScheme(DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest)
            throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an analysis scheme. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnalysisSchemeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnalysisSchemeRequest#builder()}
     * </p>
     *
     * @param deleteAnalysisSchemeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteAnalysisScheme</a></code> operation. Specifies
     *        the name of the domain you want to update and the analysis scheme you want to delete.
     * @return Result of the DeleteAnalysisScheme operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteAnalysisScheme
     */
    default DeleteAnalysisSchemeResponse deleteAnalysisScheme(
            Consumer<DeleteAnalysisSchemeRequest.Builder> deleteAnalysisSchemeRequest) throws BaseException, InternalException,
            InvalidTypeException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            CloudSearchException {
        return deleteAnalysisScheme(DeleteAnalysisSchemeRequest.builder().applyMutation(deleteAnalysisSchemeRequest).build());
    }

    /**
     * <p>
     * Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html"
     * target="_blank">Deleting a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteDomainRequest
     *        Container for the parameters to the <code><a>DeleteDomain</a></code> operation. Specifies the name of the
     *        domain you want to delete.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteDomain
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws BaseException, InternalException,
            AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html"
     * target="_blank">Deleting a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>DeleteDomain</a></code> operation. Specifies the name of the
     *        domain you want to delete.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteDomain
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) throws BaseException,
            InternalException, AwsServiceException, SdkClientException, CloudSearchException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Removes an <code><a>Expression</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteExpressionRequest
     *        Container for the parameters to the <code><a>DeleteExpression</a></code> operation. Specifies the name of
     *        the domain you want to update and the name of the expression you want to delete.
     * @return Result of the DeleteExpression operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteExpression
     */
    default DeleteExpressionResponse deleteExpression(DeleteExpressionRequest deleteExpressionRequest) throws BaseException,
            InternalException, InvalidTypeException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an <code><a>Expression</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExpressionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExpressionRequest#builder()}
     * </p>
     *
     * @param deleteExpressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteExpression</a></code> operation. Specifies the
     *        name of the domain you want to update and the name of the expression you want to delete.
     * @return Result of the DeleteExpression operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteExpression
     */
    default DeleteExpressionResponse deleteExpression(Consumer<DeleteExpressionRequest.Builder> deleteExpressionRequest)
            throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        return deleteExpression(DeleteExpressionRequest.builder().applyMutation(deleteExpressionRequest).build());
    }

    /**
     * <p>
     * Removes an <code><a>IndexField</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteIndexFieldRequest
     *        Container for the parameters to the <code><a>DeleteIndexField</a></code> operation. Specifies the name of
     *        the domain you want to update and the name of the index field you want to delete.
     * @return Result of the DeleteIndexField operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteIndexField
     */
    default DeleteIndexFieldResponse deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) throws BaseException,
            InternalException, InvalidTypeException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an <code><a>IndexField</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexFieldRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIndexFieldRequest#builder()}
     * </p>
     *
     * @param deleteIndexFieldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteIndexField</a></code> operation. Specifies the
     *        name of the domain you want to update and the name of the index field you want to delete.
     * @return Result of the DeleteIndexField operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteIndexField
     */
    default DeleteIndexFieldResponse deleteIndexField(Consumer<DeleteIndexFieldRequest.Builder> deleteIndexFieldRequest)
            throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        return deleteIndexField(DeleteIndexFieldRequest.builder().applyMutation(deleteIndexFieldRequest).build());
    }

    /**
     * <p>
     * Deletes a suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteSuggesterRequest
     *        Container for the parameters to the <code><a>DeleteSuggester</a></code> operation. Specifies the name of
     *        the domain you want to update and name of the suggester you want to delete.
     * @return Result of the DeleteSuggester operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteSuggester
     */
    default DeleteSuggesterResponse deleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) throws BaseException,
            InternalException, InvalidTypeException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSuggesterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSuggesterRequest#builder()}
     * </p>
     *
     * @param deleteSuggesterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteSuggester</a></code> operation. Specifies the
     *        name of the domain you want to update and name of the suggester you want to delete.
     * @return Result of the DeleteSuggester operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DeleteSuggester
     */
    default DeleteSuggesterResponse deleteSuggester(Consumer<DeleteSuggesterRequest.Builder> deleteSuggesterRequest)
            throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        return deleteSuggester(DeleteSuggesterRequest.builder().applyMutation(deleteSuggesterRequest).build());
    }

    /**
     * <p>
     * Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing
     * options for a <code>text</code> field. Can be limited to specific analysis schemes by name. By default, shows all
     * analysis schemes and includes any pending changes to the configuration. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeAnalysisSchemesRequest
     *        Container for the parameters to the <code><a>DescribeAnalysisSchemes</a></code> operation. Specifies the
     *        name of the domain you want to describe. To limit the response to particular analysis schemes, specify the
     *        names of the analysis schemes you want to describe. To show the active configuration and exclude any
     *        pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeAnalysisSchemes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeAnalysisSchemes
     */
    default DescribeAnalysisSchemesResponse describeAnalysisSchemes(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing
     * options for a <code>text</code> field. Can be limited to specific analysis schemes by name. By default, shows all
     * analysis schemes and includes any pending changes to the configuration. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnalysisSchemesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAnalysisSchemesRequest#builder()}
     * </p>
     *
     * @param describeAnalysisSchemesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>DescribeAnalysisSchemes</a></code> operation.
     *        Specifies the name of the domain you want to describe. To limit the response to particular analysis
     *        schemes, specify the names of the analysis schemes you want to describe. To show the active configuration
     *        and exclude any pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeAnalysisSchemes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeAnalysisSchemes
     */
    default DescribeAnalysisSchemesResponse describeAnalysisSchemes(
            Consumer<DescribeAnalysisSchemesRequest.Builder> describeAnalysisSchemesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        return describeAnalysisSchemes(DescribeAnalysisSchemesRequest.builder().applyMutation(describeAnalysisSchemesRequest)
                .build());
    }

    /**
     * <p>
     * Gets the availability options configured for a domain. By default, shows the configuration with any pending
     * changes. Set the <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude
     * pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeAvailabilityOptionsRequest
     *        Container for the parameters to the <code><a>DescribeAvailabilityOptions</a></code> operation. Specifies
     *        the name of the domain you want to describe. To show the active configuration and exclude any pending
     *        changes, set the Deployed option to <code>true</code>.
     * @return Result of the DescribeAvailabilityOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeAvailabilityOptions
     */
    default DescribeAvailabilityOptionsResponse describeAvailabilityOptions(
            DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) throws BaseException, InternalException,
            InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the availability options configured for a domain. By default, shows the configuration with any pending
     * changes. Set the <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude
     * pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailabilityOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAvailabilityOptionsRequest#builder()}
     * </p>
     *
     * @param describeAvailabilityOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeAvailabilityOptions</a></code>
     *        operation. Specifies the name of the domain you want to describe. To show the active configuration and
     *        exclude any pending changes, set the Deployed option to <code>true</code>.
     * @return Result of the DescribeAvailabilityOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeAvailabilityOptions
     */
    default DescribeAvailabilityOptionsResponse describeAvailabilityOptions(
            Consumer<DescribeAvailabilityOptionsRequest.Builder> describeAvailabilityOptionsRequest) throws BaseException,
            InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException,
            DisabledOperationException, AwsServiceException, SdkClientException, CloudSearchException {
        return describeAvailabilityOptions(DescribeAvailabilityOptionsRequest.builder()
                .applyMutation(describeAvailabilityOptionsRequest).build());
    }

    /**
     * <p>
     * Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeDomainEndpointOptionsRequest
     *        Container for the parameters to the <code><a>DescribeDomainEndpointOptions</a></code> operation. Specify
     *        the name of the domain you want to describe. To show the active configuration and exclude any pending
     *        changes, set the Deployed option to <code>true</code>.
     * @return Result of the DescribeDomainEndpointOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeDomainEndpointOptions
     */
    default DescribeDomainEndpointOptionsResponse describeDomainEndpointOptions(
            DescribeDomainEndpointOptionsRequest describeDomainEndpointOptionsRequest) throws BaseException, InternalException,
            LimitExceededException, ResourceNotFoundException, DisabledOperationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainEndpointOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDomainEndpointOptionsRequest#builder()}
     * </p>
     *
     * @param describeDomainEndpointOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeDomainEndpointOptions</a></code>
     *        operation. Specify the name of the domain you want to describe. To show the active configuration and
     *        exclude any pending changes, set the Deployed option to <code>true</code>.
     * @return Result of the DescribeDomainEndpointOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeDomainEndpointOptions
     */
    default DescribeDomainEndpointOptionsResponse describeDomainEndpointOptions(
            Consumer<DescribeDomainEndpointOptionsRequest.Builder> describeDomainEndpointOptionsRequest) throws BaseException,
            InternalException, LimitExceededException, ResourceNotFoundException, DisabledOperationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        return describeDomainEndpointOptions(DescribeDomainEndpointOptionsRequest.builder()
                .applyMutation(describeDomainEndpointOptionsRequest).build());
    }

    /**
     * <p>
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows all
     * domains by default. To get the number of searchable documents in a domain, use the console or submit a
     * <code>matchall</code> request to your domain's search endpoint:
     * <code>q=matchall&amp;amp;q.parser=structured&amp;amp;size=0</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Information about a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeDomainsRequest
     *        Container for the parameters to the <code><a>DescribeDomains</a></code> operation. By default shows the
     *        status of all domains. To restrict the response to particular domains, specify the names of the domains
     *        you want to describe.
     * @return Result of the DescribeDomains operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeDomains
     */
    default DescribeDomainsResponse describeDomains(DescribeDomainsRequest describeDomainsRequest) throws BaseException,
            InternalException, AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows all
     * domains by default. To get the number of searchable documents in a domain, use the console or submit a
     * <code>matchall</code> request to your domain's search endpoint:
     * <code>q=matchall&amp;amp;q.parser=structured&amp;amp;size=0</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Information about a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDomainsRequest#builder()}
     * </p>
     *
     * @param describeDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeDomains</a></code> operation. By default
     *        shows the status of all domains. To restrict the response to particular domains, specify the names of the
     *        domains you want to describe.
     * @return Result of the DescribeDomains operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeDomains
     */
    default DescribeDomainsResponse describeDomains(Consumer<DescribeDomainsRequest.Builder> describeDomainsRequest)
            throws BaseException, InternalException, AwsServiceException, SdkClientException, CloudSearchException {
        return describeDomains(DescribeDomainsRequest.builder().applyMutation(describeDomainsRequest).build());
    }

    /**
     * <p>
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows all
     * domains by default. To get the number of searchable documents in a domain, use the console or submit a
     * <code>matchall</code> request to your domain's search endpoint:
     * <code>q=matchall&amp;amp;q.parser=structured&amp;amp;size=0</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Information about a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @return Result of the DescribeDomains operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeDomains
     * @see #describeDomains(DescribeDomainsRequest)
     */
    default DescribeDomainsResponse describeDomains() throws BaseException, InternalException, AwsServiceException,
            SdkClientException, CloudSearchException {
        return describeDomains(DescribeDomainsRequest.builder().build());
    }

    /**
     * <p>
     * Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By
     * default, shows all expressions and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeExpressionsRequest
     *        Container for the parameters to the <code><a>DescribeDomains</a></code> operation. Specifies the name of
     *        the domain you want to describe. To restrict the response to particular expressions, specify the names of
     *        the expressions you want to describe. To show the active configuration and exclude any pending changes,
     *        set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeExpressions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeExpressions
     */
    default DescribeExpressionsResponse describeExpressions(DescribeExpressionsRequest describeExpressionsRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By
     * default, shows all expressions and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExpressionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExpressionsRequest#builder()}
     * </p>
     *
     * @param describeExpressionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeDomains</a></code> operation. Specifies the
     *        name of the domain you want to describe. To restrict the response to particular expressions, specify the
     *        names of the expressions you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeExpressions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeExpressions
     */
    default DescribeExpressionsResponse describeExpressions(
            Consumer<DescribeExpressionsRequest.Builder> describeExpressionsRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        return describeExpressions(DescribeExpressionsRequest.builder().applyMutation(describeExpressionsRequest).build());
    }

    /**
     * <p>
     * Gets information about the index fields configured for the search domain. Can be limited to specific fields by
     * name. By default, shows all fields and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Domain Information</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeIndexFieldsRequest
     *        Container for the parameters to the <code><a>DescribeIndexFields</a></code> operation. Specifies the name
     *        of the domain you want to describe. To restrict the response to particular index fields, specify the names
     *        of the index fields you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeIndexFields operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeIndexFields
     */
    default DescribeIndexFieldsResponse describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the index fields configured for the search domain. Can be limited to specific fields by
     * name. By default, shows all fields and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Domain Information</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIndexFieldsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIndexFieldsRequest#builder()}
     * </p>
     *
     * @param describeIndexFieldsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeIndexFields</a></code> operation. Specifies
     *        the name of the domain you want to describe. To restrict the response to particular index fields, specify
     *        the names of the index fields you want to describe. To show the active configuration and exclude any
     *        pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeIndexFields operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeIndexFields
     */
    default DescribeIndexFieldsResponse describeIndexFields(
            Consumer<DescribeIndexFieldsRequest.Builder> describeIndexFieldsRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        return describeIndexFields(DescribeIndexFieldsRequest.builder().applyMutation(describeIndexFieldsRequest).build());
    }

    /**
     * <p>
     * Gets the scaling parameters configured for a domain. A domain's scaling parameters specify the desired search
     * instance type and replication count. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeScalingParametersRequest
     *        Container for the parameters to the <code><a>DescribeScalingParameters</a></code> operation. Specifies the
     *        name of the domain you want to describe.
     * @return Result of the DescribeScalingParameters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeScalingParameters
     */
    default DescribeScalingParametersResponse describeScalingParameters(
            DescribeScalingParametersRequest describeScalingParametersRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the scaling parameters configured for a domain. A domain's scaling parameters specify the desired search
     * instance type and replication count. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingParametersRequest#builder()}
     * </p>
     *
     * @param describeScalingParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeScalingParameters</a></code>
     *        operation. Specifies the name of the domain you want to describe.
     * @return Result of the DescribeScalingParameters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeScalingParameters
     */
    default DescribeScalingParametersResponse describeScalingParameters(
            Consumer<DescribeScalingParametersRequest.Builder> describeScalingParametersRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        return describeScalingParameters(DescribeScalingParametersRequest.builder()
                .applyMutation(describeScalingParametersRequest).build());
    }

    /**
     * <p>
     * Gets information about the access policies that control access to the domain's document and search endpoints. By
     * default, shows the configuration with any pending changes. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeServiceAccessPoliciesRequest
     *        Container for the parameters to the <code><a>DescribeServiceAccessPolicies</a></code> operation. Specifies
     *        the name of the domain you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeServiceAccessPolicies operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeServiceAccessPolicies
     */
    default DescribeServiceAccessPoliciesResponse describeServiceAccessPolicies(
            DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the access policies that control access to the domain's document and search endpoints. By
     * default, shows the configuration with any pending changes. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceAccessPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeServiceAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param describeServiceAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeServiceAccessPolicies</a></code>
     *        operation. Specifies the name of the domain you want to describe. To show the active configuration and
     *        exclude any pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeServiceAccessPolicies operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeServiceAccessPolicies
     */
    default DescribeServiceAccessPoliciesResponse describeServiceAccessPolicies(
            Consumer<DescribeServiceAccessPoliciesRequest.Builder> describeServiceAccessPoliciesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        return describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest.builder()
                .applyMutation(describeServiceAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users
     * finish typing their queries. Can be limited to specific suggesters by name. By default, shows all suggesters and
     * includes any pending changes to the configuration. Set the <code>Deployed</code> option to <code>true</code> to
     * show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeSuggestersRequest
     *        Container for the parameters to the <code><a>DescribeSuggester</a></code> operation. Specifies the name of
     *        the domain you want to describe. To restrict the response to particular suggesters, specify the names of
     *        the suggesters you want to describe. To show the active configuration and exclude any pending changes, set
     *        the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeSuggesters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeSuggesters
     */
    default DescribeSuggestersResponse describeSuggesters(DescribeSuggestersRequest describeSuggestersRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users
     * finish typing their queries. Can be limited to specific suggesters by name. By default, shows all suggesters and
     * includes any pending changes to the configuration. Set the <code>Deployed</code> option to <code>true</code> to
     * show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSuggestersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSuggestersRequest#builder()}
     * </p>
     *
     * @param describeSuggestersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeSuggester</a></code> operation. Specifies
     *        the name of the domain you want to describe. To restrict the response to particular suggesters, specify
     *        the names of the suggesters you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return Result of the DescribeSuggesters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.DescribeSuggesters
     */
    default DescribeSuggestersResponse describeSuggesters(Consumer<DescribeSuggestersRequest.Builder> describeSuggestersRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudSearchException {
        return describeSuggesters(DescribeSuggestersRequest.builder().applyMutation(describeSuggestersRequest).build());
    }

    /**
     * <p>
     * Tells the search domain to start indexing its documents using the latest indexing options. This operation must be
     * invoked to activate options whose <a>OptionStatus</a> is <code>RequiresIndexDocuments</code>.
     * </p>
     *
     * @param indexDocumentsRequest
     *        Container for the parameters to the <code><a>IndexDocuments</a></code> operation. Specifies the name of
     *        the domain you want to re-index.
     * @return Result of the IndexDocuments operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.IndexDocuments
     */
    default IndexDocumentsResponse indexDocuments(IndexDocumentsRequest indexDocumentsRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tells the search domain to start indexing its documents using the latest indexing options. This operation must be
     * invoked to activate options whose <a>OptionStatus</a> is <code>RequiresIndexDocuments</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IndexDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link IndexDocumentsRequest#builder()}
     * </p>
     *
     * @param indexDocumentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>IndexDocuments</a></code> operation. Specifies the
     *        name of the domain you want to re-index.
     * @return Result of the IndexDocuments operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.IndexDocuments
     */
    default IndexDocumentsResponse indexDocuments(Consumer<IndexDocumentsRequest.Builder> indexDocumentsRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        return indexDocuments(IndexDocumentsRequest.builder().applyMutation(indexDocumentsRequest).build());
    }

    /**
     * <p>
     * Lists all search domains owned by an account.
     * </p>
     *
     * @param listDomainNamesRequest
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.ListDomainNames
     */
    default ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException,
            AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all search domains owned by an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.ListDomainNames
     */
    default ListDomainNamesResponse listDomainNames(Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest)
            throws BaseException, AwsServiceException, SdkClientException, CloudSearchException {
        return listDomainNames(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * Lists all search domains owned by an account.
     * </p>
     *
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.ListDomainNames
     * @see #listDomainNames(ListDomainNamesRequest)
     */
    default ListDomainNamesResponse listDomainNames() throws BaseException, AwsServiceException, SdkClientException,
            CloudSearchException {
        return listDomainNames(ListDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch
     * domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a
     * service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param updateAvailabilityOptionsRequest
     *        Container for the parameters to the <code><a>UpdateAvailabilityOptions</a></code> operation. Specifies the
     *        name of the domain you want to update and the Multi-AZ availability option.
     * @return Result of the UpdateAvailabilityOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateAvailabilityOptions
     */
    default UpdateAvailabilityOptionsResponse updateAvailabilityOptions(
            UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) throws BaseException, InternalException,
            InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException,
            ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch
     * domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a
     * service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAvailabilityOptionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAvailabilityOptionsRequest#builder()}
     * </p>
     *
     * @param updateAvailabilityOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateAvailabilityOptions</a></code>
     *        operation. Specifies the name of the domain you want to update and the Multi-AZ availability option.
     * @return Result of the UpdateAvailabilityOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateAvailabilityOptions
     */
    default UpdateAvailabilityOptionsResponse updateAvailabilityOptions(
            Consumer<UpdateAvailabilityOptionsRequest.Builder> updateAvailabilityOptionsRequest) throws BaseException,
            InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException,
            DisabledOperationException, ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        return updateAvailabilityOptions(UpdateAvailabilityOptionsRequest.builder()
                .applyMutation(updateAvailabilityOptionsRequest).build());
    }

    /**
     * <p>
     * Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param updateDomainEndpointOptionsRequest
     *        Container for the parameters to the <code><a>UpdateDomainEndpointOptions</a></code> operation. Specifies
     *        the name of the domain you want to update and the domain endpoint options.
     * @return Result of the UpdateDomainEndpointOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateDomainEndpointOptions
     */
    default UpdateDomainEndpointOptionsResponse updateDomainEndpointOptions(
            UpdateDomainEndpointOptionsRequest updateDomainEndpointOptionsRequest) throws BaseException, InternalException,
            InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException,
            ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainEndpointOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDomainEndpointOptionsRequest#builder()}
     * </p>
     *
     * @param updateDomainEndpointOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateDomainEndpointOptions</a></code>
     *        operation. Specifies the name of the domain you want to update and the domain endpoint options.
     * @return Result of the UpdateDomainEndpointOptions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws DisabledOperationException
     *         The request was rejected because it attempted an operation which is not enabled.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateDomainEndpointOptions
     */
    default UpdateDomainEndpointOptionsResponse updateDomainEndpointOptions(
            Consumer<UpdateDomainEndpointOptionsRequest.Builder> updateDomainEndpointOptionsRequest) throws BaseException,
            InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException,
            DisabledOperationException, ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        return updateDomainEndpointOptions(UpdateDomainEndpointOptionsRequest.builder()
                .applyMutation(updateDomainEndpointOptionsRequest).build());
    }

    /**
     * <p>
     * Configures scaling parameters for a domain. A domain's scaling parameters specify the desired search instance
     * type and replication count. Amazon CloudSearch will still automatically scale your domain based on the volume of
     * data and traffic, but not below the desired instance type and replication count. If the Multi-AZ option is
     * enabled, these values control the resources used per Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param updateScalingParametersRequest
     *        Container for the parameters to the <code><a>UpdateScalingParameters</a></code> operation. Specifies the
     *        name of the domain you want to update and the scaling parameters you want to configure.
     * @return Result of the UpdateScalingParameters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateScalingParameters
     */
    default UpdateScalingParametersResponse updateScalingParameters(UpdateScalingParametersRequest updateScalingParametersRequest)
            throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, InvalidTypeException,
            ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures scaling parameters for a domain. A domain's scaling parameters specify the desired search instance
     * type and replication count. Amazon CloudSearch will still automatically scale your domain based on the volume of
     * data and traffic, but not below the desired instance type and replication count. If the Multi-AZ option is
     * enabled, these values control the resources used per Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScalingParametersRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateScalingParametersRequest#builder()}
     * </p>
     *
     * @param updateScalingParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>UpdateScalingParameters</a></code> operation.
     *        Specifies the name of the domain you want to update and the scaling parameters you want to configure.
     * @return Result of the UpdateScalingParameters operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateScalingParameters
     */
    default UpdateScalingParametersResponse updateScalingParameters(
            Consumer<UpdateScalingParametersRequest.Builder> updateScalingParametersRequest) throws BaseException,
            InternalException, LimitExceededException, ResourceNotFoundException, InvalidTypeException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        return updateScalingParameters(UpdateScalingParametersRequest.builder().applyMutation(updateScalingParametersRequest)
                .build());
    }

    /**
     * <p>
     * Configures the access rules that control access to the domain's document and search endpoints. For more
     * information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank"> Configuring Access for an Amazon CloudSearch Domain</a>.
     * </p>
     *
     * @param updateServiceAccessPoliciesRequest
     *        Container for the parameters to the <code><a>UpdateServiceAccessPolicies</a></code> operation. Specifies
     *        the name of the domain you want to update and the access rules you want to configure.
     * @return Result of the UpdateServiceAccessPolicies operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateServiceAccessPolicies
     */
    default UpdateServiceAccessPoliciesResponse updateServiceAccessPolicies(
            UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) throws BaseException, InternalException,
            LimitExceededException, ResourceNotFoundException, InvalidTypeException, ValidationException, AwsServiceException,
            SdkClientException, CloudSearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the access rules that control access to the domain's document and search endpoints. For more
     * information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank"> Configuring Access for an Amazon CloudSearch Domain</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceAccessPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServiceAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param updateServiceAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateServiceAccessPolicies</a></code>
     *        operation. Specifies the name of the domain you want to update and the access rules you want to configure.
     * @return Result of the UpdateServiceAccessPolicies operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         An internal error occurred while processing the request. If this problem persists, report an issue from
     *         the <a href="http://status.aws.amazon.com/" target="_blank">Service Health Dashboard</a>.
     * @throws LimitExceededException
     *         The request was rejected because a resource limit has already been met.
     * @throws ResourceNotFoundException
     *         The request was rejected because it attempted to reference a resource that does not exist.
     * @throws InvalidTypeException
     *         The request was rejected because it specified an invalid type definition.
     * @throws ValidationException
     *         The request was rejected because it has invalid parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudSearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudSearchClient.UpdateServiceAccessPolicies
     */
    default UpdateServiceAccessPoliciesResponse updateServiceAccessPolicies(
            Consumer<UpdateServiceAccessPoliciesRequest.Builder> updateServiceAccessPoliciesRequest) throws BaseException,
            InternalException, LimitExceededException, ResourceNotFoundException, InvalidTypeException, ValidationException,
            AwsServiceException, SdkClientException, CloudSearchException {
        return updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest.builder()
                .applyMutation(updateServiceAccessPoliciesRequest).build());
    }

    /**
     * Create a {@link CloudSearchClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudSearchClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudSearchClient}.
     */
    static CloudSearchClientBuilder builder() {
        return new DefaultCloudSearchClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CloudSearchServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
