/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of the <a>DescribeHapg</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHapgResponse extends CloudHsmResponse implements
        ToCopyableBuilder<DescribeHapgResponse.Builder, DescribeHapgResponse> {
    private static final SdkField<String> HAPG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HapgArn").getter(getter(DescribeHapgResponse::hapgArn)).setter(setter(Builder::hapgArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgArn").build()).build();

    private static final SdkField<String> HAPG_SERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HapgSerial").getter(getter(DescribeHapgResponse::hapgSerial)).setter(setter(Builder::hapgSerial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HapgSerial").build()).build();

    private static final SdkField<List<String>> HSMS_LAST_ACTION_FAILED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HsmsLastActionFailed")
            .getter(getter(DescribeHapgResponse::hsmsLastActionFailed))
            .setter(setter(Builder::hsmsLastActionFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmsLastActionFailed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> HSMS_PENDING_DELETION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HsmsPendingDeletion")
            .getter(getter(DescribeHapgResponse::hsmsPendingDeletion))
            .setter(setter(Builder::hsmsPendingDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmsPendingDeletion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> HSMS_PENDING_REGISTRATION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HsmsPendingRegistration")
            .getter(getter(DescribeHapgResponse::hsmsPendingRegistration))
            .setter(setter(Builder::hsmsPendingRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmsPendingRegistration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(DescribeHapgResponse::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedTimestamp").getter(getter(DescribeHapgResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build())
            .build();

    private static final SdkField<List<String>> PARTITION_SERIAL_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PartitionSerialList")
            .getter(getter(DescribeHapgResponse::partitionSerialList))
            .setter(setter(Builder::partitionSerialList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSerialList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeHapgResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAPG_ARN_FIELD,
            HAPG_SERIAL_FIELD, HSMS_LAST_ACTION_FAILED_FIELD, HSMS_PENDING_DELETION_FIELD, HSMS_PENDING_REGISTRATION_FIELD,
            LABEL_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, PARTITION_SERIAL_LIST_FIELD, STATE_FIELD));

    private final String hapgArn;

    private final String hapgSerial;

    private final List<String> hsmsLastActionFailed;

    private final List<String> hsmsPendingDeletion;

    private final List<String> hsmsPendingRegistration;

    private final String label;

    private final String lastModifiedTimestamp;

    private final List<String> partitionSerialList;

    private final String state;

    private DescribeHapgResponse(BuilderImpl builder) {
        super(builder);
        this.hapgArn = builder.hapgArn;
        this.hapgSerial = builder.hapgSerial;
        this.hsmsLastActionFailed = builder.hsmsLastActionFailed;
        this.hsmsPendingDeletion = builder.hsmsPendingDeletion;
        this.hsmsPendingRegistration = builder.hsmsPendingRegistration;
        this.label = builder.label;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.partitionSerialList = builder.partitionSerialList;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ARN of the high-availability partition group.
     * </p>
     * 
     * @return The ARN of the high-availability partition group.
     */
    public final String hapgArn() {
        return hapgArn;
    }

    /**
     * <p>
     * The serial number of the high-availability partition group.
     * </p>
     * 
     * @return The serial number of the high-availability partition group.
     */
    public final String hapgSerial() {
        return hapgSerial;
    }

    /**
     * For responses, this returns true if the service returned a value for the HsmsLastActionFailed property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHsmsLastActionFailed() {
        return hsmsLastActionFailed != null && !(hsmsLastActionFailed instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHsmsLastActionFailed} method.
     * </p>
     * 
     * @return
     */
    public final List<String> hsmsLastActionFailed() {
        return hsmsLastActionFailed;
    }

    /**
     * For responses, this returns true if the service returned a value for the HsmsPendingDeletion property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHsmsPendingDeletion() {
        return hsmsPendingDeletion != null && !(hsmsPendingDeletion instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHsmsPendingDeletion} method.
     * </p>
     * 
     * @return
     */
    public final List<String> hsmsPendingDeletion() {
        return hsmsPendingDeletion;
    }

    /**
     * For responses, this returns true if the service returned a value for the HsmsPendingRegistration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHsmsPendingRegistration() {
        return hsmsPendingRegistration != null && !(hsmsPendingRegistration instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHsmsPendingRegistration} method.
     * </p>
     * 
     * @return
     */
    public final List<String> hsmsPendingRegistration() {
        return hsmsPendingRegistration;
    }

    /**
     * <p>
     * The label for the high-availability partition group.
     * </p>
     * 
     * @return The label for the high-availability partition group.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The date and time the high-availability partition group was last modified.
     * </p>
     * 
     * @return The date and time the high-availability partition group was last modified.
     */
    public final String lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionSerialList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionSerialList() {
        return partitionSerialList != null && !(partitionSerialList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of partition serial numbers that belong to the high-availability partition group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionSerialList} method.
     * </p>
     * 
     * @return The list of partition serial numbers that belong to the high-availability partition group.
     */
    public final List<String> partitionSerialList() {
        return partitionSerialList;
    }

    /**
     * <p>
     * The state of the high-availability partition group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CloudHsmObjectState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the high-availability partition group.
     * @see CloudHsmObjectState
     */
    public final CloudHsmObjectState state() {
        return CloudHsmObjectState.fromValue(state);
    }

    /**
     * <p>
     * The state of the high-availability partition group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CloudHsmObjectState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the high-availability partition group.
     * @see CloudHsmObjectState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hapgArn());
        hashCode = 31 * hashCode + Objects.hashCode(hapgSerial());
        hashCode = 31 * hashCode + Objects.hashCode(hasHsmsLastActionFailed() ? hsmsLastActionFailed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHsmsPendingDeletion() ? hsmsPendingDeletion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHsmsPendingRegistration() ? hsmsPendingRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionSerialList() ? partitionSerialList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHapgResponse)) {
            return false;
        }
        DescribeHapgResponse other = (DescribeHapgResponse) obj;
        return Objects.equals(hapgArn(), other.hapgArn()) && Objects.equals(hapgSerial(), other.hapgSerial())
                && hasHsmsLastActionFailed() == other.hasHsmsLastActionFailed()
                && Objects.equals(hsmsLastActionFailed(), other.hsmsLastActionFailed())
                && hasHsmsPendingDeletion() == other.hasHsmsPendingDeletion()
                && Objects.equals(hsmsPendingDeletion(), other.hsmsPendingDeletion())
                && hasHsmsPendingRegistration() == other.hasHsmsPendingRegistration()
                && Objects.equals(hsmsPendingRegistration(), other.hsmsPendingRegistration())
                && Objects.equals(label(), other.label())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && hasPartitionSerialList() == other.hasPartitionSerialList()
                && Objects.equals(partitionSerialList(), other.partitionSerialList())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHapgResponse").add("HapgArn", hapgArn()).add("HapgSerial", hapgSerial())
                .add("HsmsLastActionFailed", hasHsmsLastActionFailed() ? hsmsLastActionFailed() : null)
                .add("HsmsPendingDeletion", hasHsmsPendingDeletion() ? hsmsPendingDeletion() : null)
                .add("HsmsPendingRegistration", hasHsmsPendingRegistration() ? hsmsPendingRegistration() : null)
                .add("Label", label()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("PartitionSerialList", hasPartitionSerialList() ? partitionSerialList() : null)
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HapgArn":
            return Optional.ofNullable(clazz.cast(hapgArn()));
        case "HapgSerial":
            return Optional.ofNullable(clazz.cast(hapgSerial()));
        case "HsmsLastActionFailed":
            return Optional.ofNullable(clazz.cast(hsmsLastActionFailed()));
        case "HsmsPendingDeletion":
            return Optional.ofNullable(clazz.cast(hsmsPendingDeletion()));
        case "HsmsPendingRegistration":
            return Optional.ofNullable(clazz.cast(hsmsPendingRegistration()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "LastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "PartitionSerialList":
            return Optional.ofNullable(clazz.cast(partitionSerialList()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHapgResponse, T> g) {
        return obj -> g.apply((DescribeHapgResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHapgResponse> {
        /**
         * <p>
         * The ARN of the high-availability partition group.
         * </p>
         * 
         * @param hapgArn
         *        The ARN of the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hapgArn(String hapgArn);

        /**
         * <p>
         * The serial number of the high-availability partition group.
         * </p>
         * 
         * @param hapgSerial
         *        The serial number of the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hapgSerial(String hapgSerial);

        /**
         * <p/>
         * 
         * @param hsmsLastActionFailed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmsLastActionFailed(Collection<String> hsmsLastActionFailed);

        /**
         * <p/>
         * 
         * @param hsmsLastActionFailed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmsLastActionFailed(String... hsmsLastActionFailed);

        /**
         * <p/>
         * 
         * @param hsmsPendingDeletion
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmsPendingDeletion(Collection<String> hsmsPendingDeletion);

        /**
         * <p/>
         * 
         * @param hsmsPendingDeletion
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmsPendingDeletion(String... hsmsPendingDeletion);

        /**
         * <p/>
         * 
         * @param hsmsPendingRegistration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmsPendingRegistration(Collection<String> hsmsPendingRegistration);

        /**
         * <p/>
         * 
         * @param hsmsPendingRegistration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmsPendingRegistration(String... hsmsPendingRegistration);

        /**
         * <p>
         * The label for the high-availability partition group.
         * </p>
         * 
         * @param label
         *        The label for the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The date and time the high-availability partition group was last modified.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The date and time the high-availability partition group was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(String lastModifiedTimestamp);

        /**
         * <p>
         * The list of partition serial numbers that belong to the high-availability partition group.
         * </p>
         * 
         * @param partitionSerialList
         *        The list of partition serial numbers that belong to the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSerialList(Collection<String> partitionSerialList);

        /**
         * <p>
         * The list of partition serial numbers that belong to the high-availability partition group.
         * </p>
         * 
         * @param partitionSerialList
         *        The list of partition serial numbers that belong to the high-availability partition group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSerialList(String... partitionSerialList);

        /**
         * <p>
         * The state of the high-availability partition group.
         * </p>
         * 
         * @param state
         *        The state of the high-availability partition group.
         * @see CloudHsmObjectState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudHsmObjectState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the high-availability partition group.
         * </p>
         * 
         * @param state
         *        The state of the high-availability partition group.
         * @see CloudHsmObjectState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudHsmObjectState
         */
        Builder state(CloudHsmObjectState state);
    }

    static final class BuilderImpl extends CloudHsmResponse.BuilderImpl implements Builder {
        private String hapgArn;

        private String hapgSerial;

        private List<String> hsmsLastActionFailed = DefaultSdkAutoConstructList.getInstance();

        private List<String> hsmsPendingDeletion = DefaultSdkAutoConstructList.getInstance();

        private List<String> hsmsPendingRegistration = DefaultSdkAutoConstructList.getInstance();

        private String label;

        private String lastModifiedTimestamp;

        private List<String> partitionSerialList = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHapgResponse model) {
            super(model);
            hapgArn(model.hapgArn);
            hapgSerial(model.hapgSerial);
            hsmsLastActionFailed(model.hsmsLastActionFailed);
            hsmsPendingDeletion(model.hsmsPendingDeletion);
            hsmsPendingRegistration(model.hsmsPendingRegistration);
            label(model.label);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            partitionSerialList(model.partitionSerialList);
            state(model.state);
        }

        public final String getHapgArn() {
            return hapgArn;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final String getHapgSerial() {
            return hapgSerial;
        }

        public final void setHapgSerial(String hapgSerial) {
            this.hapgSerial = hapgSerial;
        }

        @Override
        public final Builder hapgSerial(String hapgSerial) {
            this.hapgSerial = hapgSerial;
            return this;
        }

        public final Collection<String> getHsmsLastActionFailed() {
            if (hsmsLastActionFailed instanceof SdkAutoConstructList) {
                return null;
            }
            return hsmsLastActionFailed;
        }

        public final void setHsmsLastActionFailed(Collection<String> hsmsLastActionFailed) {
            this.hsmsLastActionFailed = HsmListCopier.copy(hsmsLastActionFailed);
        }

        @Override
        public final Builder hsmsLastActionFailed(Collection<String> hsmsLastActionFailed) {
            this.hsmsLastActionFailed = HsmListCopier.copy(hsmsLastActionFailed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsLastActionFailed(String... hsmsLastActionFailed) {
            hsmsLastActionFailed(Arrays.asList(hsmsLastActionFailed));
            return this;
        }

        public final Collection<String> getHsmsPendingDeletion() {
            if (hsmsPendingDeletion instanceof SdkAutoConstructList) {
                return null;
            }
            return hsmsPendingDeletion;
        }

        public final void setHsmsPendingDeletion(Collection<String> hsmsPendingDeletion) {
            this.hsmsPendingDeletion = HsmListCopier.copy(hsmsPendingDeletion);
        }

        @Override
        public final Builder hsmsPendingDeletion(Collection<String> hsmsPendingDeletion) {
            this.hsmsPendingDeletion = HsmListCopier.copy(hsmsPendingDeletion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsPendingDeletion(String... hsmsPendingDeletion) {
            hsmsPendingDeletion(Arrays.asList(hsmsPendingDeletion));
            return this;
        }

        public final Collection<String> getHsmsPendingRegistration() {
            if (hsmsPendingRegistration instanceof SdkAutoConstructList) {
                return null;
            }
            return hsmsPendingRegistration;
        }

        public final void setHsmsPendingRegistration(Collection<String> hsmsPendingRegistration) {
            this.hsmsPendingRegistration = HsmListCopier.copy(hsmsPendingRegistration);
        }

        @Override
        public final Builder hsmsPendingRegistration(Collection<String> hsmsPendingRegistration) {
            this.hsmsPendingRegistration = HsmListCopier.copy(hsmsPendingRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmsPendingRegistration(String... hsmsPendingRegistration) {
            hsmsPendingRegistration(Arrays.asList(hsmsPendingRegistration));
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(String lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Collection<String> getPartitionSerialList() {
            if (partitionSerialList instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionSerialList;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String... partitionSerialList) {
            partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CloudHsmObjectState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DescribeHapgResponse build() {
            return new DescribeHapgResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
