/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex data type that includes information about the failover criteria for an origin group, including the status
 * codes for which CloudFront will failover from the primary origin to the second origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginGroupFailoverCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginGroupFailoverCriteria.Builder, OriginGroupFailoverCriteria> {
    private static final SdkField<StatusCodes> STATUS_CODES_FIELD = SdkField
            .<StatusCodes> builder(MarshallingType.SDK_POJO)
            .memberName("StatusCodes")
            .getter(getter(OriginGroupFailoverCriteria::statusCodes))
            .setter(setter(Builder::statusCodes))
            .constructor(StatusCodes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCodes")
                    .unmarshallLocationName("StatusCodes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final StatusCodes statusCodes;

    private OriginGroupFailoverCriteria(BuilderImpl builder) {
        this.statusCodes = builder.statusCodes;
    }

    /**
     * <p>
     * The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second
     * origin.
     * </p>
     * 
     * @return The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the
     *         second origin.
     */
    public final StatusCodes statusCodes() {
        return statusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCodes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginGroupFailoverCriteria)) {
            return false;
        }
        OriginGroupFailoverCriteria other = (OriginGroupFailoverCriteria) obj;
        return Objects.equals(statusCodes(), other.statusCodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginGroupFailoverCriteria").add("StatusCodes", statusCodes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCodes":
            return Optional.ofNullable(clazz.cast(statusCodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginGroupFailoverCriteria, T> g) {
        return obj -> g.apply((OriginGroupFailoverCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginGroupFailoverCriteria> {
        /**
         * <p>
         * The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the
         * second origin.
         * </p>
         * 
         * @param statusCodes
         *        The status codes that, when returned from the primary origin, will trigger CloudFront to failover to
         *        the second origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodes(StatusCodes statusCodes);

        /**
         * <p>
         * The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the
         * second origin.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusCodes.Builder} avoiding the need to
         * create one manually via {@link StatusCodes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusCodes.Builder#build()} is called immediately and its result
         * is passed to {@link #statusCodes(StatusCodes)}.
         * 
         * @param statusCodes
         *        a consumer that will call methods on {@link StatusCodes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusCodes(StatusCodes)
         */
        default Builder statusCodes(Consumer<StatusCodes.Builder> statusCodes) {
            return statusCodes(StatusCodes.builder().applyMutation(statusCodes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StatusCodes statusCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginGroupFailoverCriteria model) {
            statusCodes(model.statusCodes);
        }

        public final StatusCodes.Builder getStatusCodes() {
            return statusCodes != null ? statusCodes.toBuilder() : null;
        }

        public final void setStatusCodes(StatusCodes.BuilderImpl statusCodes) {
            this.statusCodes = statusCodes != null ? statusCodes.build() : null;
        }

        @Override
        public final Builder statusCodes(StatusCodes statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        @Override
        public OriginGroupFailoverCriteria build() {
            return new OriginGroupFailoverCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
