/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex data type that includes the profile configurations and other options specified for field-level encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldLevelEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldLevelEncryption.Builder, FieldLevelEncryption> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(FieldLevelEncryption::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(FieldLevelEncryption::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<FieldLevelEncryptionConfig> FIELD_LEVEL_ENCRYPTION_CONFIG_FIELD = SdkField
            .<FieldLevelEncryptionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("FieldLevelEncryptionConfig")
            .getter(getter(FieldLevelEncryption::fieldLevelEncryptionConfig))
            .setter(setter(Builder::fieldLevelEncryptionConfig))
            .constructor(FieldLevelEncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionConfig")
                    .unmarshallLocationName("FieldLevelEncryptionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, FIELD_LEVEL_ENCRYPTION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant lastModifiedTime;

    private final FieldLevelEncryptionConfig fieldLevelEncryptionConfig;

    private FieldLevelEncryption(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.fieldLevelEncryptionConfig = builder.fieldLevelEncryptionConfig;
    }

    /**
     * <p>
     * The configuration ID for a field-level encryption configuration which includes a set of profiles that specify
     * certain selected data fields to be encrypted by specific public keys.
     * </p>
     * 
     * @return The configuration ID for a field-level encryption configuration which includes a set of profiles that
     *         specify certain selected data fields to be encrypted by specific public keys.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The last time the field-level encryption configuration was changed.
     * </p>
     * 
     * @return The last time the field-level encryption configuration was changed.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A complex data type that includes the profile configurations specified for field-level encryption.
     * </p>
     * 
     * @return A complex data type that includes the profile configurations specified for field-level encryption.
     */
    public final FieldLevelEncryptionConfig fieldLevelEncryptionConfig() {
        return fieldLevelEncryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryption)) {
            return false;
        }
        FieldLevelEncryption other = (FieldLevelEncryption) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(fieldLevelEncryptionConfig(), other.fieldLevelEncryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldLevelEncryption").add("Id", id()).add("LastModifiedTime", lastModifiedTime())
                .add("FieldLevelEncryptionConfig", fieldLevelEncryptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FieldLevelEncryptionConfig":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryption, T> g) {
        return obj -> g.apply((FieldLevelEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldLevelEncryption> {
        /**
         * <p>
         * The configuration ID for a field-level encryption configuration which includes a set of profiles that specify
         * certain selected data fields to be encrypted by specific public keys.
         * </p>
         * 
         * @param id
         *        The configuration ID for a field-level encryption configuration which includes a set of profiles that
         *        specify certain selected data fields to be encrypted by specific public keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The last time the field-level encryption configuration was changed.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the field-level encryption configuration was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A complex data type that includes the profile configurations specified for field-level encryption.
         * </p>
         * 
         * @param fieldLevelEncryptionConfig
         *        A complex data type that includes the profile configurations specified for field-level encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionConfig(FieldLevelEncryptionConfig fieldLevelEncryptionConfig);

        /**
         * <p>
         * A complex data type that includes the profile configurations specified for field-level encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldLevelEncryptionConfig.Builder}
         * avoiding the need to create one manually via {@link FieldLevelEncryptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldLevelEncryptionConfig(FieldLevelEncryptionConfig)}.
         * 
         * @param fieldLevelEncryptionConfig
         *        a consumer that will call methods on {@link FieldLevelEncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionConfig(FieldLevelEncryptionConfig)
         */
        default Builder fieldLevelEncryptionConfig(Consumer<FieldLevelEncryptionConfig.Builder> fieldLevelEncryptionConfig) {
            return fieldLevelEncryptionConfig(FieldLevelEncryptionConfig.builder().applyMutation(fieldLevelEncryptionConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedTime;

        private FieldLevelEncryptionConfig fieldLevelEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryption model) {
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
            fieldLevelEncryptionConfig(model.fieldLevelEncryptionConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final FieldLevelEncryptionConfig.Builder getFieldLevelEncryptionConfig() {
            return fieldLevelEncryptionConfig != null ? fieldLevelEncryptionConfig.toBuilder() : null;
        }

        public final void setFieldLevelEncryptionConfig(FieldLevelEncryptionConfig.BuilderImpl fieldLevelEncryptionConfig) {
            this.fieldLevelEncryptionConfig = fieldLevelEncryptionConfig != null ? fieldLevelEncryptionConfig.build() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionConfig(FieldLevelEncryptionConfig fieldLevelEncryptionConfig) {
            this.fieldLevelEncryptionConfig = fieldLevelEncryptionConfig;
            return this;
        }

        @Override
        public FieldLevelEncryption build() {
            return new FieldLevelEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
