/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Origination routes define call distribution properties for your SIP hosts to receive inbound calls using your Amazon
 * Chime Voice Connector. Limit: Ten origination routes for each Amazon Chime Voice Connector.
 * </p>
 * <note>
 * <p>
 * The parameters listed below are not required, but you must use at least one.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginationRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginationRoute.Builder, OriginationRoute> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(OriginationRoute::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(OriginationRoute::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(OriginationRoute::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(OriginationRoute::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Weight").getter(getter(OriginationRoute::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD,
            PROTOCOL_FIELD, PRIORITY_FIELD, WEIGHT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String host;

    private final Integer port;

    private final String protocol;

    private final Integer priority;

    private final Integer weight;

    private OriginationRoute(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.priority = builder.priority;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The FQDN or IP address to contact for origination traffic.
     * </p>
     * 
     * @return The FQDN or IP address to contact for origination traffic.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The designated origination route port. Defaults to 5060.
     * </p>
     * 
     * @return The designated origination route port. Defaults to 5060.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol
     * by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link OriginationRouteProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP
     *         protocol by default.
     * @see OriginationRouteProtocol
     */
    public final OriginationRouteProtocol protocol() {
        return OriginationRouteProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol
     * by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link OriginationRouteProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP
     *         protocol by default.
     * @see OriginationRouteProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted
     * first.
     * </p>
     * 
     * @return The priority associated with the host, with 1 being the highest priority. Higher priority hosts are
     *         attempted first.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on
     * their relative weight.
     * </p>
     * 
     * @return The weight associated with the host. If hosts are equal in priority, calls are redistributed among them
     *         based on their relative weight.
     */
    public final Integer weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginationRoute)) {
            return false;
        }
        OriginationRoute other = (OriginationRoute) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(priority(), other.priority())
                && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginationRoute").add("Host", host()).add("Port", port()).add("Protocol", protocolAsString())
                .add("Priority", priority()).add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginationRoute, T> g) {
        return obj -> g.apply((OriginationRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginationRoute> {
        /**
         * <p>
         * The FQDN or IP address to contact for origination traffic.
         * </p>
         * 
         * @param host
         *        The FQDN or IP address to contact for origination traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The designated origination route port. Defaults to 5060.
         * </p>
         * 
         * @param port
         *        The designated origination route port. Defaults to 5060.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP
         * protocol by default.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use
         *        TCP protocol by default.
         * @see OriginationRouteProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginationRouteProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP
         * protocol by default.
         * </p>
         * 
         * @param protocol
         *        The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use
         *        TCP protocol by default.
         * @see OriginationRouteProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginationRouteProtocol
         */
        Builder protocol(OriginationRouteProtocol protocol);

        /**
         * <p>
         * The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted
         * first.
         * </p>
         * 
         * @param priority
         *        The priority associated with the host, with 1 being the highest priority. Higher priority hosts are
         *        attempted first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based
         * on their relative weight.
         * </p>
         * 
         * @param weight
         *        The weight associated with the host. If hosts are equal in priority, calls are redistributed among
         *        them based on their relative weight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private Integer port;

        private String protocol;

        private Integer priority;

        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginationRoute model) {
            host(model.host);
            port(model.port);
            protocol(model.protocol);
            priority(model.priority);
            weight(model.weight);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(OriginationRouteProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Integer getWeight() {
            return weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public OriginationRoute build() {
            return new OriginationRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
