/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVoiceConnectorGroupResponse extends ChimeResponse implements
        ToCopyableBuilder<CreateVoiceConnectorGroupResponse.Builder, CreateVoiceConnectorGroupResponse> {
    private static final SdkField<VoiceConnectorGroup> VOICE_CONNECTOR_GROUP_FIELD = SdkField
            .<VoiceConnectorGroup> builder(MarshallingType.SDK_POJO).memberName("VoiceConnectorGroup")
            .getter(getter(CreateVoiceConnectorGroupResponse::voiceConnectorGroup)).setter(setter(Builder::voiceConnectorGroup))
            .constructor(VoiceConnectorGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_GROUP_FIELD));

    private final VoiceConnectorGroup voiceConnectorGroup;

    private CreateVoiceConnectorGroupResponse(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorGroup = builder.voiceConnectorGroup;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector group details.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector group details.
     */
    public final VoiceConnectorGroup voiceConnectorGroup() {
        return voiceConnectorGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceConnectorGroupResponse)) {
            return false;
        }
        CreateVoiceConnectorGroupResponse other = (CreateVoiceConnectorGroupResponse) obj;
        return Objects.equals(voiceConnectorGroup(), other.voiceConnectorGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVoiceConnectorGroupResponse").add("VoiceConnectorGroup", voiceConnectorGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorGroup":
            return Optional.ofNullable(clazz.cast(voiceConnectorGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceConnectorGroupResponse, T> g) {
        return obj -> g.apply((CreateVoiceConnectorGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateVoiceConnectorGroupResponse> {
        /**
         * <p>
         * The Amazon Chime Voice Connector group details.
         * </p>
         * 
         * @param voiceConnectorGroup
         *        The Amazon Chime Voice Connector group details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorGroup(VoiceConnectorGroup voiceConnectorGroup);

        /**
         * <p>
         * The Amazon Chime Voice Connector group details.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceConnectorGroup.Builder} avoiding the
         * need to create one manually via {@link VoiceConnectorGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceConnectorGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #voiceConnectorGroup(VoiceConnectorGroup)}.
         * 
         * @param voiceConnectorGroup
         *        a consumer that will call methods on {@link VoiceConnectorGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnectorGroup(VoiceConnectorGroup)
         */
        default Builder voiceConnectorGroup(Consumer<VoiceConnectorGroup.Builder> voiceConnectorGroup) {
            return voiceConnectorGroup(VoiceConnectorGroup.builder().applyMutation(voiceConnectorGroup).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private VoiceConnectorGroup voiceConnectorGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceConnectorGroupResponse model) {
            super(model);
            voiceConnectorGroup(model.voiceConnectorGroup);
        }

        public final VoiceConnectorGroup.Builder getVoiceConnectorGroup() {
            return voiceConnectorGroup != null ? voiceConnectorGroup.toBuilder() : null;
        }

        public final void setVoiceConnectorGroup(VoiceConnectorGroup.BuilderImpl voiceConnectorGroup) {
            this.voiceConnectorGroup = voiceConnectorGroup != null ? voiceConnectorGroup.build() : null;
        }

        @Override
        public final Builder voiceConnectorGroup(VoiceConnectorGroup voiceConnectorGroup) {
            this.voiceConnectorGroup = voiceConnectorGroup;
            return this;
        }

        @Override
        public CreateVoiceConnectorGroupResponse build() {
            return new CreateVoiceConnectorGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
