/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Ec2ConfigurationListCopier {
    static List<Ec2Configuration> copy(Collection<? extends Ec2Configuration> ec2ConfigurationListParam) {
        List<Ec2Configuration> list;
        if (ec2ConfigurationListParam == null || ec2ConfigurationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2Configuration> modifiableList = new ArrayList<>();
            ec2ConfigurationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ec2Configuration> copyFromBuilder(Collection<? extends Ec2Configuration.Builder> ec2ConfigurationListParam) {
        List<Ec2Configuration> list;
        if (ec2ConfigurationListParam == null || ec2ConfigurationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2Configuration> modifiableList = new ArrayList<>();
            ec2ConfigurationListParam.forEach(entry -> {
                Ec2Configuration member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ec2Configuration.Builder> copyToBuilder(Collection<? extends Ec2Configuration> ec2ConfigurationListParam) {
        List<Ec2Configuration.Builder> list;
        if (ec2ConfigurationListParam == null || ec2ConfigurationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2Configuration.Builder> modifiableList = new ArrayList<>();
            ec2ConfigurationListParam.forEach(entry -> {
                Ec2Configuration.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
