/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackupVaultNotificationsResponse extends BackupResponse implements
        ToCopyableBuilder<GetBackupVaultNotificationsResponse.Builder, GetBackupVaultNotificationsResponse> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(GetBackupVaultNotificationsResponse::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(GetBackupVaultNotificationsResponse::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SNSTopicArn").getter(getter(GetBackupVaultNotificationsResponse::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopicArn").build()).build();

    private static final SdkField<List<String>> BACKUP_VAULT_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BackupVaultEvents")
            .getter(getter(GetBackupVaultNotificationsResponse::backupVaultEventsAsStrings))
            .setter(setter(Builder::backupVaultEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            BACKUP_VAULT_ARN_FIELD, SNS_TOPIC_ARN_FIELD, BACKUP_VAULT_EVENTS_FIELD));

    private final String backupVaultName;

    private final String backupVaultArn;

    private final String snsTopicArn;

    private final List<String> backupVaultEvents;

    private GetBackupVaultNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.backupVaultEvents = builder.backupVaultEvents;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Region where they are created. They consist of
     *         lowercase letters, numbers, and hyphens.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example,
     * <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example,
     *         <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * An array of events that indicate the status of jobs to back up resources to the backup vault.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupVaultEvents} method.
     * </p>
     * 
     * @return An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    public final List<BackupVaultEvent> backupVaultEvents() {
        return BackupVaultEventsCopier.copyStringToEnum(backupVaultEvents);
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupVaultEvents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupVaultEvents() {
        return backupVaultEvents != null && !(backupVaultEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of events that indicate the status of jobs to back up resources to the backup vault.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupVaultEvents} method.
     * </p>
     * 
     * @return An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    public final List<String> backupVaultEventsAsStrings() {
        return backupVaultEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupVaultEvents() ? backupVaultEventsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupVaultNotificationsResponse)) {
            return false;
        }
        GetBackupVaultNotificationsResponse other = (GetBackupVaultNotificationsResponse) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(backupVaultArn(), other.backupVaultArn()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && hasBackupVaultEvents() == other.hasBackupVaultEvents()
                && Objects.equals(backupVaultEventsAsStrings(), other.backupVaultEventsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBackupVaultNotificationsResponse").add("BackupVaultName", backupVaultName())
                .add("BackupVaultArn", backupVaultArn()).add("SNSTopicArn", snsTopicArn())
                .add("BackupVaultEvents", hasBackupVaultEvents() ? backupVaultEventsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "SNSTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "BackupVaultEvents":
            return Optional.ofNullable(clazz.cast(backupVaultEventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupVaultNotificationsResponse, T> g) {
        return obj -> g.apply((GetBackupVaultNotificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBackupVaultNotificationsResponse> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Region where they are created. They consist of lowercase
         * letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Region where they are created. They consist of
         *        lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * </p>
         * 
         * @param backupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example,
         * <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.
         * </p>
         * 
         * @param snsTopicArn
         *        An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic; for example,
         *        <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEventsWithStrings(Collection<String> backupVaultEvents);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEventsWithStrings(String... backupVaultEvents);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEvents(Collection<BackupVaultEvent> backupVaultEvents);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEvents(BackupVaultEvent... backupVaultEvents);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String backupVaultName;

        private String backupVaultArn;

        private String snsTopicArn;

        private List<String> backupVaultEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupVaultNotificationsResponse model) {
            super(model);
            backupVaultName(model.backupVaultName);
            backupVaultArn(model.backupVaultArn);
            snsTopicArn(model.snsTopicArn);
            backupVaultEventsWithStrings(model.backupVaultEvents);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Collection<String> getBackupVaultEvents() {
            if (backupVaultEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return backupVaultEvents;
        }

        public final void setBackupVaultEvents(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copy(backupVaultEvents);
        }

        @Override
        public final Builder backupVaultEventsWithStrings(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copy(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEventsWithStrings(String... backupVaultEvents) {
            backupVaultEventsWithStrings(Arrays.asList(backupVaultEvents));
            return this;
        }

        @Override
        public final Builder backupVaultEvents(Collection<BackupVaultEvent> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copyEnumToString(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEvents(BackupVaultEvent... backupVaultEvents) {
            backupVaultEvents(Arrays.asList(backupVaultEvents));
            return this;
        }

        @Override
        public GetBackupVaultNotificationsResponse build() {
            return new GetBackupVaultNotificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
