/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGraphqlApiRequest extends AppSyncRequest implements
        ToCopyableBuilder<UpdateGraphqlApiRequest.Builder, UpdateGraphqlApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(UpdateGraphqlApiRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateGraphqlApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.<LogConfig> builder(MarshallingType.SDK_POJO)
            .memberName("logConfig").getter(getter(UpdateGraphqlApiRequest::logConfig)).setter(setter(Builder::logConfig))
            .constructor(LogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(UpdateGraphqlApiRequest::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<UserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField
            .<UserPoolConfig> builder(MarshallingType.SDK_POJO).memberName("userPoolConfig")
            .getter(getter(UpdateGraphqlApiRequest::userPoolConfig)).setter(setter(Builder::userPoolConfig))
            .constructor(UserPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()).build();

    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<OpenIDConnectConfig> builder(MarshallingType.SDK_POJO).memberName("openIDConnectConfig")
            .getter(getter(UpdateGraphqlApiRequest::openIDConnectConfig)).setter(setter(Builder::openIDConnectConfig))
            .constructor(OpenIDConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build())
            .build();

    private static final SdkField<List<AdditionalAuthenticationProvider>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField
            .<List<AdditionalAuthenticationProvider>> builder(MarshallingType.LIST)
            .memberName("additionalAuthenticationProviders")
            .getter(getter(UpdateGraphqlApiRequest::additionalAuthenticationProviders))
            .setter(setter(Builder::additionalAuthenticationProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthenticationProviders")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalAuthenticationProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalAuthenticationProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("xrayEnabled").getter(getter(UpdateGraphqlApiRequest::xrayEnabled)).setter(setter(Builder::xrayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()).build();

    private static final SdkField<LambdaAuthorizerConfig> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField
            .<LambdaAuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("lambdaAuthorizerConfig")
            .getter(getter(UpdateGraphqlApiRequest::lambdaAuthorizerConfig)).setter(setter(Builder::lambdaAuthorizerConfig))
            .constructor(LambdaAuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerConfig").build())
            .build();

    private static final SdkField<String> MERGED_API_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedApiExecutionRoleArn").getter(getter(UpdateGraphqlApiRequest::mergedApiExecutionRoleArn))
            .setter(setter(Builder::mergedApiExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedApiExecutionRoleArn").build())
            .build();

    private static final SdkField<String> OWNER_CONTACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerContact").getter(getter(UpdateGraphqlApiRequest::ownerContact))
            .setter(setter(Builder::ownerContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerContact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD,
            LOG_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD, USER_POOL_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD,
            ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD, XRAY_ENABLED_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD,
            MERGED_API_EXECUTION_ROLE_ARN_FIELD, OWNER_CONTACT_FIELD));

    private final String apiId;

    private final String name;

    private final LogConfig logConfig;

    private final String authenticationType;

    private final UserPoolConfig userPoolConfig;

    private final OpenIDConnectConfig openIDConnectConfig;

    private final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;

    private final Boolean xrayEnabled;

    private final LambdaAuthorizerConfig lambdaAuthorizerConfig;

    private final String mergedApiExecutionRoleArn;

    private final String ownerContact;

    private UpdateGraphqlApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.logConfig = builder.logConfig;
        this.authenticationType = builder.authenticationType;
        this.userPoolConfig = builder.userPoolConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.xrayEnabled = builder.xrayEnabled;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
        this.mergedApiExecutionRoleArn = builder.mergedApiExecutionRoleArn;
        this.ownerContact = builder.ownerContact;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The new name for the <code>GraphqlApi</code> object.
     * </p>
     * 
     * @return The new name for the <code>GraphqlApi</code> object.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.
     */
    public final LogConfig logConfig() {
        return logConfig;
    }

    /**
     * <p>
     * The new authentication type for the <code>GraphqlApi</code> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The new authentication type for the <code>GraphqlApi</code> object.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The new authentication type for the <code>GraphqlApi</code> object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The new authentication type for the <code>GraphqlApi</code> object.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.
     * </p>
     * 
     * @return The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.
     */
    public final UserPoolConfig userPoolConfig() {
        return userPoolConfig;
    }

    /**
     * <p>
     * The OpenID Connect configuration for the <code>GraphqlApi</code> object.
     * </p>
     * 
     * @return The OpenID Connect configuration for the <code>GraphqlApi</code> object.
     */
    public final OpenIDConnectConfig openIDConnectConfig() {
        return openIDConnectConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAuthenticationProviders
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalAuthenticationProviders() {
        return additionalAuthenticationProviders != null && !(additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAuthenticationProviders}
     * method.
     * </p>
     * 
     * @return A list of additional authentication providers for the <code>GraphqlApi</code> API.
     */
    public final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders() {
        return additionalAuthenticationProviders;
    }

    /**
     * <p>
     * A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
     * </p>
     * 
     * @return A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
     */
    public final Boolean xrayEnabled() {
        return xrayEnabled;
    }

    /**
     * <p>
     * Configuration for Lambda function authorization.
     * </p>
     * 
     * @return Configuration for Lambda function authorization.
     */
    public final LambdaAuthorizerConfig lambdaAuthorizerConfig() {
        return lambdaAuthorizerConfig;
    }

    /**
     * <p>
     * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role on
     * behalf of the Merged API to validate access to source APIs at runtime and to prompt the <code>AUTO_MERGE</code>
     * to update the merged API endpoint with the source API changes automatically.
     * </p>
     * 
     * @return The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this
     *         role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the
     *         <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
     */
    public final String mergedApiExecutionRoleArn() {
        return mergedApiExecutionRoleArn;
    }

    /**
     * <p>
     * The owner contact information for an API resource.
     * </p>
     * <p>
     * This field accepts any string input with a length of 0 - 256 characters.
     * </p>
     * 
     * @return The owner contact information for an API resource.</p>
     *         <p>
     *         This field accepts any string input with a length of 0 - 256 characters.
     */
    public final String ownerContact() {
        return ownerContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfig());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAuthorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(mergedApiExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerContact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGraphqlApiRequest)) {
            return false;
        }
        UpdateGraphqlApiRequest other = (UpdateGraphqlApiRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(name(), other.name())
                && Objects.equals(logConfig(), other.logConfig())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(userPoolConfig(), other.userPoolConfig())
                && Objects.equals(openIDConnectConfig(), other.openIDConnectConfig())
                && hasAdditionalAuthenticationProviders() == other.hasAdditionalAuthenticationProviders()
                && Objects.equals(additionalAuthenticationProviders(), other.additionalAuthenticationProviders())
                && Objects.equals(xrayEnabled(), other.xrayEnabled())
                && Objects.equals(lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig())
                && Objects.equals(mergedApiExecutionRoleArn(), other.mergedApiExecutionRoleArn())
                && Objects.equals(ownerContact(), other.ownerContact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateGraphqlApiRequest")
                .add("ApiId", apiId())
                .add("Name", name())
                .add("LogConfig", logConfig())
                .add("AuthenticationType", authenticationTypeAsString())
                .add("UserPoolConfig", userPoolConfig())
                .add("OpenIDConnectConfig", openIDConnectConfig())
                .add("AdditionalAuthenticationProviders",
                        hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null)
                .add("XrayEnabled", xrayEnabled()).add("LambdaAuthorizerConfig", lambdaAuthorizerConfig())
                .add("MergedApiExecutionRoleArn", mergedApiExecutionRoleArn()).add("OwnerContact", ownerContact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "logConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "userPoolConfig":
            return Optional.ofNullable(clazz.cast(userPoolConfig()));
        case "openIDConnectConfig":
            return Optional.ofNullable(clazz.cast(openIDConnectConfig()));
        case "additionalAuthenticationProviders":
            return Optional.ofNullable(clazz.cast(additionalAuthenticationProviders()));
        case "xrayEnabled":
            return Optional.ofNullable(clazz.cast(xrayEnabled()));
        case "lambdaAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(lambdaAuthorizerConfig()));
        case "mergedApiExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(mergedApiExecutionRoleArn()));
        case "ownerContact":
            return Optional.ofNullable(clazz.cast(ownerContact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGraphqlApiRequest, T> g) {
        return obj -> g.apply((UpdateGraphqlApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGraphqlApiRequest> {
        /**
         * <p>
         * The API ID.
         * </p>
         * 
         * @param apiId
         *        The API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The new name for the <code>GraphqlApi</code> object.
         * </p>
         * 
         * @param name
         *        The new name for the <code>GraphqlApi</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.
         * </p>
         * 
         * @param logConfig
         *        The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(LogConfig logConfig);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfig.Builder} avoiding the need to
         * create one manually via {@link LogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logConfig(LogConfig)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link LogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(LogConfig)
         */
        default Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return logConfig(LogConfig.builder().applyMutation(logConfig).build());
        }

        /**
         * <p>
         * The new authentication type for the <code>GraphqlApi</code> object.
         * </p>
         * 
         * @param authenticationType
         *        The new authentication type for the <code>GraphqlApi</code> object.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The new authentication type for the <code>GraphqlApi</code> object.
         * </p>
         * 
         * @param authenticationType
         *        The new authentication type for the <code>GraphqlApi</code> object.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.
         * </p>
         * 
         * @param userPoolConfig
         *        The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfig(UserPoolConfig userPoolConfig);

        /**
         * <p>
         * The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPoolConfig.Builder} avoiding the need
         * to create one manually via {@link UserPoolConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPoolConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolConfig(UserPoolConfig)}.
         * 
         * @param userPoolConfig
         *        a consumer that will call methods on {@link UserPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfig(UserPoolConfig)
         */
        default Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return userPoolConfig(UserPoolConfig.builder().applyMutation(userPoolConfig).build());
        }

        /**
         * <p>
         * The OpenID Connect configuration for the <code>GraphqlApi</code> object.
         * </p>
         * 
         * @param openIDConnectConfig
         *        The OpenID Connect configuration for the <code>GraphqlApi</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig);

        /**
         * <p>
         * The OpenID Connect configuration for the <code>GraphqlApi</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenIDConnectConfig.Builder} avoiding the
         * need to create one manually via {@link OpenIDConnectConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenIDConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #openIDConnectConfig(OpenIDConnectConfig)}.
         * 
         * @param openIDConnectConfig
         *        a consumer that will call methods on {@link OpenIDConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfig(OpenIDConnectConfig)
         */
        default Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return openIDConnectConfig(OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig).build());
        }

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider... additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #additionalAuthenticationProviders(List<AdditionalAuthenticationProvider>)}.
         * 
         * @param additionalAuthenticationProviders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAuthenticationProviders(java.util.Collection<AdditionalAuthenticationProvider>)
         */
        Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders);

        /**
         * <p>
         * A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
         * </p>
         * 
         * @param xrayEnabled
         *        A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xrayEnabled(Boolean xrayEnabled);

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * 
         * @param lambdaAuthorizerConfig
         *        Configuration for Lambda function authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig);

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaAuthorizerConfig.Builder} avoiding
         * the need to create one manually via {@link LambdaAuthorizerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAuthorizerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaAuthorizerConfig(LambdaAuthorizerConfig)}.
         * 
         * @param lambdaAuthorizerConfig
         *        a consumer that will call methods on {@link LambdaAuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAuthorizerConfig(LambdaAuthorizerConfig)
         */
        default Builder lambdaAuthorizerConfig(Consumer<LambdaAuthorizerConfig.Builder> lambdaAuthorizerConfig) {
            return lambdaAuthorizerConfig(LambdaAuthorizerConfig.builder().applyMutation(lambdaAuthorizerConfig).build());
        }

        /**
         * <p>
         * The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this role
         * on behalf of the Merged API to validate access to source APIs at runtime and to prompt the
         * <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
         * </p>
         * 
         * @param mergedApiExecutionRoleArn
         *        The Identity and Access Management service role ARN for a merged API. The AppSync service assumes this
         *        role on behalf of the Merged API to validate access to source APIs at runtime and to prompt the
         *        <code>AUTO_MERGE</code> to update the merged API endpoint with the source API changes automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedApiExecutionRoleArn(String mergedApiExecutionRoleArn);

        /**
         * <p>
         * The owner contact information for an API resource.
         * </p>
         * <p>
         * This field accepts any string input with a length of 0 - 256 characters.
         * </p>
         * 
         * @param ownerContact
         *        The owner contact information for an API resource.</p>
         *        <p>
         *        This field accepts any string input with a length of 0 - 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerContact(String ownerContact);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String name;

        private LogConfig logConfig;

        private String authenticationType;

        private UserPoolConfig userPoolConfig;

        private OpenIDConnectConfig openIDConnectConfig;

        private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean xrayEnabled;

        private LambdaAuthorizerConfig lambdaAuthorizerConfig;

        private String mergedApiExecutionRoleArn;

        private String ownerContact;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGraphqlApiRequest model) {
            super(model);
            apiId(model.apiId);
            name(model.name);
            logConfig(model.logConfig);
            authenticationType(model.authenticationType);
            userPoolConfig(model.userPoolConfig);
            openIDConnectConfig(model.openIDConnectConfig);
            additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            xrayEnabled(model.xrayEnabled);
            lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
            mergedApiExecutionRoleArn(model.mergedApiExecutionRoleArn);
            ownerContact(model.ownerContact);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final LogConfig.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return userPoolConfig != null ? userPoolConfig.toBuilder() : null;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return openIDConnectConfig != null ? openIDConnectConfig.toBuilder() : null;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final List<AdditionalAuthenticationProvider.Builder> getAdditionalAuthenticationProviders() {
            List<AdditionalAuthenticationProvider.Builder> result = AdditionalAuthenticationProvidersCopier
                    .copyToBuilder(this.additionalAuthenticationProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copyFromBuilder(additionalAuthenticationProviders);
        }

        @Override
        public final Builder additionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                AdditionalAuthenticationProvider... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders)
                    .map(c -> AdditionalAuthenticationProvider.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getXrayEnabled() {
            return xrayEnabled;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final LambdaAuthorizerConfig.Builder getLambdaAuthorizerConfig() {
            return lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(LambdaAuthorizerConfig.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        public final String getMergedApiExecutionRoleArn() {
            return mergedApiExecutionRoleArn;
        }

        public final void setMergedApiExecutionRoleArn(String mergedApiExecutionRoleArn) {
            this.mergedApiExecutionRoleArn = mergedApiExecutionRoleArn;
        }

        @Override
        public final Builder mergedApiExecutionRoleArn(String mergedApiExecutionRoleArn) {
            this.mergedApiExecutionRoleArn = mergedApiExecutionRoleArn;
            return this;
        }

        public final String getOwnerContact() {
            return ownerContact;
        }

        public final void setOwnerContact(String ownerContact) {
            this.ownerContact = ownerContact;
        }

        @Override
        public final Builder ownerContact(String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGraphqlApiRequest build() {
            return new UpdateGraphqlApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
