/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateSourceGraphqlApiRequest extends AppSyncRequest implements
        ToCopyableBuilder<DisassociateSourceGraphqlApiRequest.Builder, DisassociateSourceGraphqlApiRequest> {
    private static final SdkField<String> MERGED_API_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedApiIdentifier").getter(getter(DisassociateSourceGraphqlApiRequest::mergedApiIdentifier))
            .setter(setter(Builder::mergedApiIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("mergedApiIdentifier").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationId").getter(getter(DisassociateSourceGraphqlApiRequest::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("associationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGED_API_IDENTIFIER_FIELD,
            ASSOCIATION_ID_FIELD));

    private final String mergedApiIdentifier;

    private final String associationId;

    private DisassociateSourceGraphqlApiRequest(BuilderImpl builder) {
        super(builder);
        this.mergedApiIdentifier = builder.mergedApiIdentifier;
        this.associationId = builder.associationId;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @return The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *         APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *         APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged
     *         API.
     */
    public final String mergedApiIdentifier() {
        return mergedApiIdentifier;
    }

    /**
     * <p>
     * The ID generated by the AppSync service for the source API association.
     * </p>
     * 
     * @return The ID generated by the AppSync service for the source API association.
     */
    public final String associationId() {
        return associationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mergedApiIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateSourceGraphqlApiRequest)) {
            return false;
        }
        DisassociateSourceGraphqlApiRequest other = (DisassociateSourceGraphqlApiRequest) obj;
        return Objects.equals(mergedApiIdentifier(), other.mergedApiIdentifier())
                && Objects.equals(associationId(), other.associationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateSourceGraphqlApiRequest").add("MergedApiIdentifier", mergedApiIdentifier())
                .add("AssociationId", associationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mergedApiIdentifier":
            return Optional.ofNullable(clazz.cast(mergedApiIdentifier()));
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateSourceGraphqlApiRequest, T> g) {
        return obj -> g.apply((DisassociateSourceGraphqlApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateSourceGraphqlApiRequest> {
        /**
         * <p>
         * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
         * APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
         * APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
         * </p>
         * 
         * @param mergedApiIdentifier
         *        The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases,
         *        Merged APIs (especially in your account) only require the API ID value or ARN of the merged API.
         *        However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource
         *        ARN of the merged API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedApiIdentifier(String mergedApiIdentifier);

        /**
         * <p>
         * The ID generated by the AppSync service for the source API association.
         * </p>
         * 
         * @param associationId
         *        The ID generated by the AppSync service for the source API association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String mergedApiIdentifier;

        private String associationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateSourceGraphqlApiRequest model) {
            super(model);
            mergedApiIdentifier(model.mergedApiIdentifier);
            associationId(model.associationId);
        }

        public final String getMergedApiIdentifier() {
            return mergedApiIdentifier;
        }

        public final void setMergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
        }

        @Override
        public final Builder mergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateSourceGraphqlApiRequest build() {
            return new DisassociateSourceGraphqlApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
