/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an interface VPC endpoint (interface endpoint) that lets you create a private connection between the
 * virtual private cloud (VPC) that you specify and AppStream 2.0. When you specify an interface endpoint for a stack,
 * users of the stack can connect to AppStream 2.0 only through that endpoint. When you specify an interface endpoint
 * for an image builder, administrators can connect to the image builder only through that endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<AccessEndpoint.Builder, AccessEndpoint> {
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(AccessEndpoint::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> VPCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpceId")
            .getter(getter(AccessEndpoint::vpceId)).setter(setter(Builder::vpceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_TYPE_FIELD,
            VPCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointType;

    private final String vpceId;

    private AccessEndpoint(BuilderImpl builder) {
        this.endpointType = builder.endpointType;
        this.vpceId = builder.vpceId;
    }

    /**
     * <p>
     * The type of interface endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link AccessEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of interface endpoint.
     * @see AccessEndpointType
     */
    public final AccessEndpointType endpointType() {
        return AccessEndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of interface endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link AccessEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of interface endpoint.
     * @see AccessEndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The identifier (ID) of the VPC in which the interface endpoint is used.
     * </p>
     * 
     * @return The identifier (ID) of the VPC in which the interface endpoint is used.
     */
    public final String vpceId() {
        return vpceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEndpoint)) {
            return false;
        }
        AccessEndpoint other = (AccessEndpoint) obj;
        return Objects.equals(endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(vpceId(), other.vpceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessEndpoint").add("EndpointType", endpointTypeAsString()).add("VpceId", vpceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "VpceId":
            return Optional.ofNullable(clazz.cast(vpceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessEndpoint, T> g) {
        return obj -> g.apply((AccessEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessEndpoint> {
        /**
         * <p>
         * The type of interface endpoint.
         * </p>
         * 
         * @param endpointType
         *        The type of interface endpoint.
         * @see AccessEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of interface endpoint.
         * </p>
         * 
         * @param endpointType
         *        The type of interface endpoint.
         * @see AccessEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEndpointType
         */
        Builder endpointType(AccessEndpointType endpointType);

        /**
         * <p>
         * The identifier (ID) of the VPC in which the interface endpoint is used.
         * </p>
         * 
         * @param vpceId
         *        The identifier (ID) of the VPC in which the interface endpoint is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceId(String vpceId);
    }

    static final class BuilderImpl implements Builder {
        private String endpointType;

        private String vpceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEndpoint model) {
            endpointType(model.endpointType);
            vpceId(model.vpceId);
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(AccessEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getVpceId() {
            return vpceId;
        }

        public final void setVpceId(String vpceId) {
            this.vpceId = vpceId;
        }

        @Override
        public final Builder vpceId(String vpceId) {
            this.vpceId = vpceId;
            return this;
        }

        @Override
        public AccessEndpoint build() {
            return new AccessEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
