/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual node service provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualNodeServiceProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualNodeServiceProvider.Builder, VirtualNodeServiceProvider> {
    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualNodeName").getter(getter(VirtualNodeServiceProvider::virtualNodeName))
            .setter(setter(Builder::virtualNodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_NODE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualNodeName;

    private VirtualNodeServiceProvider(BuilderImpl builder) {
        this.virtualNodeName = builder.virtualNodeName;
    }

    /**
     * <p>
     * The name of the virtual node that is acting as a service provider.
     * </p>
     * 
     * @return The name of the virtual node that is acting as a service provider.
     */
    public final String virtualNodeName() {
        return virtualNodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualNodeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeServiceProvider)) {
            return false;
        }
        VirtualNodeServiceProvider other = (VirtualNodeServiceProvider) obj;
        return Objects.equals(virtualNodeName(), other.virtualNodeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualNodeServiceProvider").add("VirtualNodeName", virtualNodeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualNodeName":
            return Optional.ofNullable(clazz.cast(virtualNodeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeServiceProvider, T> g) {
        return obj -> g.apply((VirtualNodeServiceProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualNodeServiceProvider> {
        /**
         * <p>
         * The name of the virtual node that is acting as a service provider.
         * </p>
         * 
         * @param virtualNodeName
         *        The name of the virtual node that is acting as a service provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNodeName(String virtualNodeName);
    }

    static final class BuilderImpl implements Builder {
        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeServiceProvider model) {
            virtualNodeName(model.virtualNodeName);
        }

        public final String getVirtualNodeName() {
            return virtualNodeName;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        @Override
        public VirtualNodeServiceProvider build() {
            return new VirtualNodeServiceProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
