/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportApiRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<ImportApiRequest.Builder, ImportApiRequest> {
    private static final SdkField<String> BASEPATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Basepath").getter(getter(ImportApiRequest::basepath)).setter(setter(Builder::basepath))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("basepath").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(ImportApiRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<Boolean> FAIL_ON_WARNINGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FailOnWarnings").getter(getter(ImportApiRequest::failOnWarnings))
            .setter(setter(Builder::failOnWarnings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("failOnWarnings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASEPATH_FIELD, BODY_FIELD,
            FAIL_ON_WARNINGS_FIELD));

    private final String basepath;

    private final String body;

    private final Boolean failOnWarnings;

    private ImportApiRequest(BuilderImpl builder) {
        super(builder);
        this.basepath = builder.basepath;
        this.body = builder.body;
        this.failOnWarnings = builder.failOnWarnings;
    }

    /**
     * <p>
     * Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split.
     * The default value is ignore. To learn more, see <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set the
     * OpenAPI basePath Property</a>. Supported only for HTTP APIs.
     * </p>
     * 
     * @return Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and
     *         split. The default value is ignore. To learn more, see <a href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set
     *         the OpenAPI basePath Property</a>. Supported only for HTTP APIs.
     */
    public final String basepath() {
        return basepath;
    }

    /**
     * <p>
     * The OpenAPI definition. Supported only for HTTP APIs.
     * </p>
     * 
     * @return The OpenAPI definition. Supported only for HTTP APIs.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues
     * if a warning is encountered.
     * </p>
     * 
     * @return Specifies whether to rollback the API creation when a warning is encountered. By default, API creation
     *         continues if a warning is encountered.
     */
    public final Boolean failOnWarnings() {
        return failOnWarnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(basepath());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(failOnWarnings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportApiRequest)) {
            return false;
        }
        ImportApiRequest other = (ImportApiRequest) obj;
        return Objects.equals(basepath(), other.basepath()) && Objects.equals(body(), other.body())
                && Objects.equals(failOnWarnings(), other.failOnWarnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportApiRequest").add("Basepath", basepath()).add("Body", body())
                .add("FailOnWarnings", failOnWarnings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Basepath":
            return Optional.ofNullable(clazz.cast(basepath()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "FailOnWarnings":
            return Optional.ofNullable(clazz.cast(failOnWarnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportApiRequest, T> g) {
        return obj -> g.apply((ImportApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ImportApiRequest> {
        /**
         * <p>
         * Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and
         * split. The default value is ignore. To learn more, see <a
         * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html">Set
         * the OpenAPI basePath Property</a>. Supported only for HTTP APIs.
         * </p>
         * 
         * @param basepath
         *        Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend,
         *        and split. The default value is ignore. To learn more, see <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html"
         *        >Set the OpenAPI basePath Property</a>. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basepath(String basepath);

        /**
         * <p>
         * The OpenAPI definition. Supported only for HTTP APIs.
         * </p>
         * 
         * @param body
         *        The OpenAPI definition. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * Specifies whether to rollback the API creation when a warning is encountered. By default, API creation
         * continues if a warning is encountered.
         * </p>
         * 
         * @param failOnWarnings
         *        Specifies whether to rollback the API creation when a warning is encountered. By default, API creation
         *        continues if a warning is encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnWarnings(Boolean failOnWarnings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String basepath;

        private String body;

        private Boolean failOnWarnings;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportApiRequest model) {
            super(model);
            basepath(model.basepath);
            body(model.body);
            failOnWarnings(model.failOnWarnings);
        }

        public final String getBasepath() {
            return basepath;
        }

        public final void setBasepath(String basepath) {
            this.basepath = basepath;
        }

        @Override
        public final Builder basepath(String basepath) {
            this.basepath = basepath;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Boolean getFailOnWarnings() {
            return failOnWarnings;
        }

        public final void setFailOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
        }

        @Override
        public final Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportApiRequest build() {
            return new ImportApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
