/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddRegionRequest;
import software.amazon.awssdk.services.directory.model.AddRegionResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveRegionRequest;
import software.amazon.awssdk.services.directory.model.RemoveRegionResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupRequest;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.directory.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.paginators.DescribeClientAuthenticationSettingsPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeDirectoriesPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeDomainControllersPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeLDAPSSettingsPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeRegionsPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeSharedDirectoriesPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeSnapshotsPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeTrustsPublisher;
import software.amazon.awssdk.services.directory.paginators.DescribeUpdateDirectoryPublisher;
import software.amazon.awssdk.services.directory.paginators.ListCertificatesPublisher;
import software.amazon.awssdk.services.directory.paginators.ListIpRoutesPublisher;
import software.amazon.awssdk.services.directory.paginators.ListLogSubscriptionsPublisher;
import software.amazon.awssdk.services.directory.paginators.ListSchemaExtensionsPublisher;
import software.amazon.awssdk.services.directory.paginators.ListTagsForResourcePublisher;

/**
 * Service client for accessing Directory Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Directory Service</fullname>
 * <p>
 * Directory Service is a web service that makes it easy for you to setup and run directories in the Amazon Web Services
 * cloud, or connect your Amazon Web Services resources with an existing self-managed Microsoft Active Directory. This
 * guide provides detailed information about Directory Service operations, data types, parameters, and errors. For
 * information about Directory Services features, see <a href="https://aws.amazon.com/directoryservice/">Directory
 * Service</a> and the <a href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/what_is.html">Directory
 * Service Administration Guide</a>.
 * </p>
 * <note>
 * <p>
 * Amazon Web Services provides SDKs that consist of libraries and sample code for various programming languages and
 * platforms (Java, Ruby, .Net, iOS, Android, etc.). The SDKs provide a convenient way to create programmatic access to
 * Directory Service and other Amazon Web Services services. For more information about the Amazon Web Services SDKs,
 * including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools for Amazon Web
 * Services</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DirectoryAsyncClient extends AwsClient {
    String SERVICE_NAME = "ds";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ds";

    /**
     * <p>
     * Accepts a directory sharing request that was sent from the directory owner account.
     * </p>
     *
     * @param acceptSharedDirectoryRequest
     * @return A Java Future containing the result of the AcceptSharedDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AcceptSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AcceptSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptSharedDirectoryResponse> acceptSharedDirectory(
            AcceptSharedDirectoryRequest acceptSharedDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a directory sharing request that was sent from the directory owner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptSharedDirectoryRequest.Builder} avoiding the
     * need to create one manually via {@link AcceptSharedDirectoryRequest#builder()}
     * </p>
     *
     * @param acceptSharedDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptSharedDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AcceptSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AcceptSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptSharedDirectoryResponse> acceptSharedDirectory(
            Consumer<AcceptSharedDirectoryRequest.Builder> acceptSharedDirectoryRequest) {
        return acceptSharedDirectory(AcceptSharedDirectoryRequest.builder().applyMutation(acceptSharedDirectoryRequest).build());
    }

    /**
     * <p>
     * If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR
     * address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. <i>AddIpRoutes</i>
     * adds this address block. You can also use <i>AddIpRoutes</i> to facilitate routing traffic that uses public IP
     * ranges from your Microsoft AD on Amazon Web Services to a peer VPC.
     * </p>
     * <p>
     * Before you call <i>AddIpRoutes</i>, ensure that all of the required permissions have been explicitly granted
     * through a policy. For details about what permissions are required to run the <i>AddIpRoutes</i> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">
     * Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param addIpRoutesRequest
     * @return A Java Future containing the result of the AddIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>IpRouteLimitExceededException The maximum allowed number of IP addresses was exceeded. The default
     *         limit is 100 IP address blocks.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddIpRoutesResponse> addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR
     * address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. <i>AddIpRoutes</i>
     * adds this address block. You can also use <i>AddIpRoutes</i> to facilitate routing traffic that uses public IP
     * ranges from your Microsoft AD on Amazon Web Services to a peer VPC.
     * </p>
     * <p>
     * Before you call <i>AddIpRoutes</i>, ensure that all of the required permissions have been explicitly granted
     * through a policy. For details about what permissions are required to run the <i>AddIpRoutes</i> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">
     * Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddIpRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link AddIpRoutesRequest#builder()}
     * </p>
     *
     * @param addIpRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.AddIpRoutesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>IpRouteLimitExceededException The maximum allowed number of IP addresses was exceeded. The default
     *         limit is 100 IP address blocks.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddIpRoutesResponse> addIpRoutes(Consumer<AddIpRoutesRequest.Builder> addIpRoutesRequest) {
        return addIpRoutes(AddIpRoutesRequest.builder().applyMutation(addIpRoutesRequest).build());
    }

    /**
     * <p>
     * Adds two domain controllers in the specified Region for the specified directory.
     * </p>
     *
     * @param addRegionRequest
     * @return A Java Future containing the result of the AddRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadyInRegionException The Region you specified is the same Region where the Managed
     *         Microsoft AD directory was created. Specify a different Region and try again.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>RegionLimitExceededException You have reached the limit for maximum number of simultaneous Region
     *         replications per directory.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRegionResponse> addRegion(AddRegionRequest addRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds two domain controllers in the specified Region for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRegionRequest.Builder} avoiding the need to
     * create one manually via {@link AddRegionRequest#builder()}
     * </p>
     *
     * @param addRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.AddRegionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadyInRegionException The Region you specified is the same Region where the Managed
     *         Microsoft AD directory was created. Specify a different Region and try again.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>RegionLimitExceededException You have reached the limit for maximum number of simultaneous Region
     *         replications per directory.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRegionResponse> addRegion(Consumer<AddRegionRequest.Builder> addRegionRequest) {
        return addRegion(AddRegionRequest.builder().applyMutation(addRegionRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique to each resource.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique to each resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started
     * replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled
     * during any of the following states; <code>Initializing</code>, <code>CreatingSnapshot</code>, and
     * <code>UpdatingSchema</code>.
     * </p>
     *
     * @param cancelSchemaExtensionRequest
     * @return A Java Future containing the result of the CancelSchemaExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CancelSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CancelSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelSchemaExtensionResponse> cancelSchemaExtension(
            CancelSchemaExtensionRequest cancelSchemaExtensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started
     * replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled
     * during any of the following states; <code>Initializing</code>, <code>CreatingSnapshot</code>, and
     * <code>UpdatingSchema</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSchemaExtensionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSchemaExtensionRequest#builder()}
     * </p>
     *
     * @param cancelSchemaExtensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSchemaExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CancelSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CancelSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelSchemaExtensionResponse> cancelSchemaExtension(
            Consumer<CancelSchemaExtensionRequest.Builder> cancelSchemaExtensionRequest) {
        return cancelSchemaExtension(CancelSchemaExtensionRequest.builder().applyMutation(cancelSchemaExtensionRequest).build());
    }

    /**
     * <p>
     * Creates an AD Connector to connect to a self-managed directory.
     * </p>
     * <p>
     * Before you call <code>ConnectDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the
     * <code>ConnectDirectory</code> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param connectDirectoryRequest
     *        Contains the inputs for the <a>ConnectDirectory</a> operation.
     * @return A Java Future containing the result of the ConnectDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ConnectDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ConnectDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConnectDirectoryResponse> connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AD Connector to connect to a self-managed directory.
     * </p>
     * <p>
     * Before you call <code>ConnectDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the
     * <code>ConnectDirectory</code> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConnectDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link ConnectDirectoryRequest#builder()}
     * </p>
     *
     * @param connectDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest.Builder} to create a
     *        request. Contains the inputs for the <a>ConnectDirectory</a> operation.
     * @return A Java Future containing the result of the ConnectDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ConnectDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ConnectDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConnectDirectoryResponse> connectDirectory(
            Consumer<ConnectDirectoryRequest.Builder> connectDirectoryRequest) {
        return connectDirectory(ConnectDirectoryRequest.builder().applyMutation(connectDirectoryRequest).build());
    }

    /**
     * <p>
     * Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the
     * access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code>.
     * </p>
     * <important>
     * <p>
     * After an alias has been created, it cannot be deleted or reused, so this operation should only be used when
     * absolutely necessary.
     * </p>
     * </important>
     *
     * @param createAliasRequest
     *        Contains the inputs for the <a>CreateAlias</a> operation.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the
     * access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code>.
     * </p>
     * <important>
     * <p>
     * After an alias has been created, it cannot be deleted or reused, so this operation should only be used when
     * absolutely necessary.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateAliasRequest.Builder} to create a request.
     *        Contains the inputs for the <a>CreateAlias</a> operation.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates an Active Directory computer object in the specified directory.
     * </p>
     *
     * @param createComputerRequest
     *        Contains the inputs for the <a>CreateComputer</a> operation.
     * @return A Java Future containing the result of the CreateComputer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateComputer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateComputer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateComputerResponse> createComputer(CreateComputerRequest createComputerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Active Directory computer object in the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComputerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateComputerRequest#builder()}
     * </p>
     *
     * @param createComputerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateComputerRequest.Builder} to create a request.
     *        Contains the inputs for the <a>CreateComputer</a> operation.
     * @return A Java Future containing the result of the CreateComputer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateComputer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateComputer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateComputerResponse> createComputer(Consumer<CreateComputerRequest.Builder> createComputerRequest) {
        return createComputer(CreateComputerRequest.builder().applyMutation(createComputerRequest).build());
    }

    /**
     * <p>
     * Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are
     * required in order to set up a trust relationship with another domain. The conditional forwarder points to the
     * trusted domain.
     * </p>
     *
     * @param createConditionalForwarderRequest
     *        Initiates the creation of a conditional forwarder for your Directory Service for Microsoft Active
     *        Directory. Conditional forwarders are required in order to set up a trust relationship with another
     *        domain.
     * @return A Java Future containing the result of the CreateConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConditionalForwarderResponse> createConditionalForwarder(
            CreateConditionalForwarderRequest createConditionalForwarderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are
     * required in order to set up a trust relationship with another domain. The conditional forwarder points to the
     * trusted domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConditionalForwarderRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConditionalForwarderRequest#builder()}
     * </p>
     *
     * @param createConditionalForwarderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest.Builder} to
     *        create a request. Initiates the creation of a conditional forwarder for your Directory Service for
     *        Microsoft Active Directory. Conditional forwarders are required in order to set up a trust relationship
     *        with another domain.
     * @return A Java Future containing the result of the CreateConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConditionalForwarderResponse> createConditionalForwarder(
            Consumer<CreateConditionalForwarderRequest.Builder> createConditionalForwarderRequest) {
        return createConditionalForwarder(CreateConditionalForwarderRequest.builder()
                .applyMutation(createConditionalForwarderRequest).build());
    }

    /**
     * <p>
     * Creates a Simple AD directory. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html">Simple Active
     * Directory</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <code>CreateDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>CreateDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createDirectoryRequest
     *        Contains the inputs for the <a>CreateDirectory</a> operation.
     * @return A Java Future containing the result of the CreateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Simple AD directory. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html">Simple Active
     * Directory</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <code>CreateDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>CreateDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDirectoryRequest#builder()}
     * </p>
     *
     * @param createDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateDirectoryRequest.Builder} to create a
     *        request. Contains the inputs for the <a>CreateDirectory</a> operation.
     * @return A Java Future containing the result of the CreateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDirectoryResponse> createDirectory(
            Consumer<CreateDirectoryRequest.Builder> createDirectoryRequest) {
        return createDirectory(CreateDirectoryRequest.builder().applyMutation(createDirectoryRequest).build());
    }

    /**
     * <p>
     * Creates a subscription to forward real-time Directory Service domain controller security logs to the specified
     * Amazon CloudWatch log group in your Amazon Web Services account.
     * </p>
     *
     * @param createLogSubscriptionRequest
     * @return A Java Future containing the result of the CreateLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLogSubscriptionResponse> createLogSubscription(
            CreateLogSubscriptionRequest createLogSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription to forward real-time Directory Service domain controller security logs to the specified
     * Amazon CloudWatch log group in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLogSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param createLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLogSubscriptionResponse> createLogSubscription(
            Consumer<CreateLogSubscriptionRequest.Builder> createLogSubscriptionRequest) {
        return createLogSubscription(CreateLogSubscriptionRequest.builder().applyMutation(createLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed
     * Microsoft AD</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <i>CreateMicrosoftAD</i>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <i>CreateMicrosoftAD</i>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createMicrosoftAdRequest
     *        Creates an Managed Microsoft AD directory.
     * @return A Java Future containing the result of the CreateMicrosoftAD operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateMicrosoftAD
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateMicrosoftAD" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMicrosoftAdResponse> createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed
     * Microsoft AD</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <i>CreateMicrosoftAD</i>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <i>CreateMicrosoftAD</i>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMicrosoftAdRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMicrosoftAdRequest#builder()}
     * </p>
     *
     * @param createMicrosoftAdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest.Builder} to create a
     *        request. Creates an Managed Microsoft AD directory.
     * @return A Java Future containing the result of the CreateMicrosoftAD operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateMicrosoftAD
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateMicrosoftAD" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMicrosoftAdResponse> createMicrosoftAD(
            Consumer<CreateMicrosoftAdRequest.Builder> createMicrosoftAdRequest) {
        return createMicrosoftAD(CreateMicrosoftAdRequest.builder().applyMutation(createMicrosoftAdRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.
     * </p>
     * <note>
     * <p>
     * You cannot take snapshots of AD Connector directories.
     * </p>
     * </note>
     *
     * @param createSnapshotRequest
     *        Contains the inputs for the <a>CreateSnapshot</a> operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.
     * </p>
     * <note>
     * <p>
     * You cannot take snapshots of AD Connector directories.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateSnapshotRequest.Builder} to create a request.
     *        Contains the inputs for the <a>CreateSnapshot</a> operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you
     * can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft
     * Active Directory. This would allow you to provide users and groups access to resources in either domain, with a
     * single set of credentials.
     * </p>
     * <p>
     * This action initiates the creation of the Amazon Web Services side of a trust relationship between an Managed
     * Microsoft AD directory and an external domain. You can create either a forest trust or an external trust.
     * </p>
     *
     * @param createTrustRequest
     *        Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example,
     *        you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed
     *        Microsoft Active Directory. This would allow you to provide users and groups access to resources in either
     *        domain, with a single set of credentials.</p>
     *        <p>
     *        This action initiates the creation of the Amazon Web Services side of a trust relationship between an
     *        Managed Microsoft AD directory and an external domain.
     * @return A Java Future containing the result of the CreateTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li> <li>
     *         EntityDoesNotExistException The specified entity could not be found.</li> <li>InvalidParameterException
     *         One or more parameters are not valid.</li> <li>ClientException A client exception has occurred.</li> <li>
     *         ServiceException An exception has occurred in Directory Service.</li> <li>UnsupportedOperationException
     *         The operation is not supported.</li> <li>SdkException Base class for all exceptions that can be thrown by
     *         the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrustResponse> createTrust(CreateTrustRequest createTrustRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you
     * can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft
     * Active Directory. This would allow you to provide users and groups access to resources in either domain, with a
     * single set of credentials.
     * </p>
     * <p>
     * This action initiates the creation of the Amazon Web Services side of a trust relationship between an Managed
     * Microsoft AD directory and an external domain. You can create either a forest trust or an external trust.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrustRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTrustRequest#builder()}
     * </p>
     *
     * @param createTrustRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.CreateTrustRequest.Builder} to create a request.
     *        Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example,
     *        you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed
     *        Microsoft Active Directory. This would allow you to provide users and groups access to resources in either
     *        domain, with a single set of credentials.</p>
     *        <p>
     *        This action initiates the creation of the Amazon Web Services side of a trust relationship between an
     *        Managed Microsoft AD directory and an external domain.
     * @return A Java Future containing the result of the CreateTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li> <li>
     *         EntityDoesNotExistException The specified entity could not be found.</li> <li>InvalidParameterException
     *         One or more parameters are not valid.</li> <li>ClientException A client exception has occurred.</li> <li>
     *         ServiceException An exception has occurred in Directory Service.</li> <li>UnsupportedOperationException
     *         The operation is not supported.</li> <li>SdkException Base class for all exceptions that can be thrown by
     *         the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrustResponse> createTrust(Consumer<CreateTrustRequest.Builder> createTrustRequest) {
        return createTrust(CreateTrustRequest.builder().applyMutation(createTrustRequest).build());
    }

    /**
     * <p>
     * Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     *
     * @param deleteConditionalForwarderRequest
     *        Deletes a conditional forwarder.
     * @return A Java Future containing the result of the DeleteConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConditionalForwarderResponse> deleteConditionalForwarder(
            DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConditionalForwarderRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConditionalForwarderRequest#builder()}
     * </p>
     *
     * @param deleteConditionalForwarderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest.Builder} to
     *        create a request. Deletes a conditional forwarder.
     * @return A Java Future containing the result of the DeleteConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConditionalForwarderResponse> deleteConditionalForwarder(
            Consumer<DeleteConditionalForwarderRequest.Builder> deleteConditionalForwarderRequest) {
        return deleteConditionalForwarder(DeleteConditionalForwarderRequest.builder()
                .applyMutation(deleteConditionalForwarderRequest).build());
    }

    /**
     * <p>
     * Deletes an Directory Service directory.
     * </p>
     * <p>
     * Before you call <code>DeleteDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>DeleteDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param deleteDirectoryRequest
     *        Contains the inputs for the <a>DeleteDirectory</a> operation.
     * @return A Java Future containing the result of the DeleteDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Directory Service directory.
     * </p>
     * <p>
     * Before you call <code>DeleteDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>DeleteDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDirectoryRequest#builder()}
     * </p>
     *
     * @param deleteDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest.Builder} to create a
     *        request. Contains the inputs for the <a>DeleteDirectory</a> operation.
     * @return A Java Future containing the result of the DeleteDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDirectoryResponse> deleteDirectory(
            Consumer<DeleteDirectoryRequest.Builder> deleteDirectoryRequest) {
        return deleteDirectory(DeleteDirectoryRequest.builder().applyMutation(deleteDirectoryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified log subscription.
     * </p>
     *
     * @param deleteLogSubscriptionRequest
     * @return A Java Future containing the result of the DeleteLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLogSubscriptionResponse> deleteLogSubscription(
            DeleteLogSubscriptionRequest deleteLogSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified log subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLogSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLogSubscriptionResponse> deleteLogSubscription(
            Consumer<DeleteLogSubscriptionRequest.Builder> deleteLogSubscriptionRequest) {
        return deleteLogSubscription(DeleteLogSubscriptionRequest.builder().applyMutation(deleteLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes a directory snapshot.
     * </p>
     *
     * @param deleteSnapshotRequest
     *        Contains the inputs for the <a>DeleteSnapshot</a> operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a directory snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest.Builder} to create a request.
     *        Contains the inputs for the <a>DeleteSnapshot</a> operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest) {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     *
     * @param deleteTrustRequest
     *        Deletes the local side of an existing trust relationship between the Managed Microsoft AD directory and
     *        the external domain.
     * @return A Java Future containing the result of the DeleteTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrustResponse> deleteTrust(DeleteTrustRequest deleteTrustRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrustRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTrustRequest#builder()}
     * </p>
     *
     * @param deleteTrustRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DeleteTrustRequest.Builder} to create a request.
     *        Deletes the local side of an existing trust relationship between the Managed Microsoft AD directory and
     *        the external domain.
     * @return A Java Future containing the result of the DeleteTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrustResponse> deleteTrust(Consumer<DeleteTrustRequest.Builder> deleteTrustRequest) {
        return deleteTrust(DeleteTrustRequest.builder().applyMutation(deleteTrustRequest).build());
    }

    /**
     * <p>
     * Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param deregisterCertificateRequest
     * @return A Java Future containing the result of the DeregisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>CertificateInUseException The certificate is being used for the LDAP security connection and cannot
     *         be removed without disabling LDAP security.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterCertificateResponse> deregisterCertificate(
            DeregisterCertificateRequest deregisterCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterCertificateRequest#builder()}
     * </p>
     *
     * @param deregisterCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>CertificateInUseException The certificate is being used for the LDAP security connection and cannot
     *         be removed without disabling LDAP security.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterCertificateResponse> deregisterCertificate(
            Consumer<DeregisterCertificateRequest.Builder> deregisterCertificateRequest) {
        return deregisterCertificate(DeregisterCertificateRequest.builder().applyMutation(deregisterCertificateRequest).build());
    }

    /**
     * <p>
     * Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * </p>
     *
     * @param deregisterEventTopicRequest
     *        Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * @return A Java Future containing the result of the DeregisterEventTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterEventTopicResponse> deregisterEventTopic(
            DeregisterEventTopicRequest deregisterEventTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterEventTopicRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterEventTopicRequest#builder()}
     * </p>
     *
     * @param deregisterEventTopicRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest.Builder} to create a
     *        request. Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * @return A Java Future containing the result of the DeregisterEventTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeregisterEventTopicResponse> deregisterEventTopic(
            Consumer<DeregisterEventTopicRequest.Builder> deregisterEventTopicRequest) {
        return deregisterEventTopic(DeregisterEventTopicRequest.builder().applyMutation(deregisterEventTopicRequest).build());
    }

    /**
     * <p>
     * Displays information about the certificate registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param describeCertificateRequest
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificateResponse> describeCertificate(
            DescribeCertificateRequest describeCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays information about the certificate registered for secure LDAP or client certificate authentication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificateRequest#builder()}
     * </p>
     *
     * @param describeCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificateResponse> describeCertificate(
            Consumer<DescribeCertificateRequest.Builder> describeCertificateRequest) {
        return describeCertificate(DescribeCertificateRequest.builder().applyMutation(describeCertificateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the type of client authentication for the specified directory, if the type is
     * specified. If no type is specified, information about all client authentication types that are supported for the
     * specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
     * </p>
     *
     * @param describeClientAuthenticationSettingsRequest
     * @return A Java Future containing the result of the DescribeClientAuthenticationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeClientAuthenticationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeClientAuthenticationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClientAuthenticationSettingsResponse> describeClientAuthenticationSettings(
            DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the type of client authentication for the specified directory, if the type is
     * specified. If no type is specified, information about all client authentication types that are supported for the
     * specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeClientAuthenticationSettingsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeClientAuthenticationSettingsRequest#builder()}
     * </p>
     *
     * @param describeClientAuthenticationSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeClientAuthenticationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeClientAuthenticationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeClientAuthenticationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClientAuthenticationSettingsResponse> describeClientAuthenticationSettings(
            Consumer<DescribeClientAuthenticationSettingsRequest.Builder> describeClientAuthenticationSettingsRequest) {
        return describeClientAuthenticationSettings(DescribeClientAuthenticationSettingsRequest.builder()
                .applyMutation(describeClientAuthenticationSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the type of client authentication for the specified directory, if the type is
     * specified. If no type is specified, information about all client authentication types that are supported for the
     * specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClientAuthenticationSettings(software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeClientAuthenticationSettingsPublisher publisher = client.describeClientAuthenticationSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeClientAuthenticationSettingsPublisher publisher = client.describeClientAuthenticationSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClientAuthenticationSettings(software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClientAuthenticationSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeClientAuthenticationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeClientAuthenticationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientAuthenticationSettingsPublisher describeClientAuthenticationSettingsPaginator(
            DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest) {
        return new DescribeClientAuthenticationSettingsPublisher(this, describeClientAuthenticationSettingsRequest);
    }

    /**
     * <p>
     * Retrieves information about the type of client authentication for the specified directory, if the type is
     * specified. If no type is specified, information about all client authentication types that are supported for the
     * specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClientAuthenticationSettings(software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeClientAuthenticationSettingsPublisher publisher = client.describeClientAuthenticationSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeClientAuthenticationSettingsPublisher publisher = client.describeClientAuthenticationSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClientAuthenticationSettings(software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeClientAuthenticationSettingsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeClientAuthenticationSettingsRequest#builder()}
     * </p>
     *
     * @param describeClientAuthenticationSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeClientAuthenticationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeClientAuthenticationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClientAuthenticationSettingsPublisher describeClientAuthenticationSettingsPaginator(
            Consumer<DescribeClientAuthenticationSettingsRequest.Builder> describeClientAuthenticationSettingsRequest) {
        return describeClientAuthenticationSettingsPaginator(DescribeClientAuthenticationSettingsRequest.builder()
                .applyMutation(describeClientAuthenticationSettingsRequest).build());
    }

    /**
     * <p>
     * Obtains information about the conditional forwarders for this account.
     * </p>
     * <p>
     * If no input parameters are provided for RemoteDomainNames, this request describes all conditional forwarders for
     * the specified directory ID.
     * </p>
     *
     * @param describeConditionalForwardersRequest
     *        Describes a conditional forwarder.
     * @return A Java Future containing the result of the DescribeConditionalForwarders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeConditionalForwarders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConditionalForwardersResponse> describeConditionalForwarders(
            DescribeConditionalForwardersRequest describeConditionalForwardersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains information about the conditional forwarders for this account.
     * </p>
     * <p>
     * If no input parameters are provided for RemoteDomainNames, this request describes all conditional forwarders for
     * the specified directory ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConditionalForwardersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConditionalForwardersRequest#builder()}
     * </p>
     *
     * @param describeConditionalForwardersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest.Builder} to
     *        create a request. Describes a conditional forwarder.
     * @return A Java Future containing the result of the DescribeConditionalForwarders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeConditionalForwarders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConditionalForwardersResponse> describeConditionalForwarders(
            Consumer<DescribeConditionalForwardersRequest.Builder> describeConditionalForwardersRequest) {
        return describeConditionalForwarders(DescribeConditionalForwardersRequest.builder()
                .applyMutation(describeConditionalForwardersRequest).build());
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     *
     * @param describeDirectoriesRequest
     *        Contains the inputs for the <a>DescribeDirectories</a> operation.
     * @return A Java Future containing the result of the DescribeDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDirectoriesResponse> describeDirectories(
            DescribeDirectoriesRequest describeDirectoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDirectoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest.Builder} to create a
     *        request. Contains the inputs for the <a>DescribeDirectories</a> operation.
     * @return A Java Future containing the result of the DescribeDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDirectoriesResponse> describeDirectories(
            Consumer<DescribeDirectoriesRequest.Builder> describeDirectoriesRequest) {
        return describeDirectories(DescribeDirectoriesRequest.builder().applyMutation(describeDirectoriesRequest).build());
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDirectoriesResponse> describeDirectories() {
        return describeDirectories(DescribeDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDirectories(software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDirectoriesPublisher publisher = client.describeDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDirectoriesPublisher publisher = client.describeDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDirectories(software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDirectoriesPublisher describeDirectoriesPaginator() {
        return describeDirectoriesPaginator(DescribeDirectoriesRequest.builder().build());
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDirectories(software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDirectoriesPublisher publisher = client.describeDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDirectoriesPublisher publisher = client.describeDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDirectories(software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDirectoriesRequest
     *        Contains the inputs for the <a>DescribeDirectories</a> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDirectoriesPublisher describeDirectoriesPaginator(DescribeDirectoriesRequest describeDirectoriesRequest) {
        return new DescribeDirectoriesPublisher(this, describeDirectoriesRequest);
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDirectories(software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDirectoriesPublisher publisher = client.describeDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDirectoriesPublisher publisher = client.describeDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDirectories(software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDirectoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest.Builder} to create a
     *        request. Contains the inputs for the <a>DescribeDirectories</a> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDirectoriesPublisher describeDirectoriesPaginator(
            Consumer<DescribeDirectoriesRequest.Builder> describeDirectoriesRequest) {
        return describeDirectoriesPaginator(DescribeDirectoriesRequest.builder().applyMutation(describeDirectoriesRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about any domain controllers in your directory.
     * </p>
     *
     * @param describeDomainControllersRequest
     * @return A Java Future containing the result of the DescribeDomainControllers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDomainControllersResponse> describeDomainControllers(
            DescribeDomainControllersRequest describeDomainControllersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about any domain controllers in your directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainControllersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainControllersRequest#builder()}
     * </p>
     *
     * @param describeDomainControllersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDomainControllers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDomainControllersResponse> describeDomainControllers(
            Consumer<DescribeDomainControllersRequest.Builder> describeDomainControllersRequest) {
        return describeDomainControllers(DescribeDomainControllersRequest.builder()
                .applyMutation(describeDomainControllersRequest).build());
    }

    /**
     * <p>
     * Provides information about any domain controllers in your directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDomainControllers(software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDomainControllersPublisher publisher = client.describeDomainControllersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDomainControllersPublisher publisher = client.describeDomainControllersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainControllers(software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDomainControllersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDomainControllersPublisher describeDomainControllersPaginator(
            DescribeDomainControllersRequest describeDomainControllersRequest) {
        return new DescribeDomainControllersPublisher(this, describeDomainControllersRequest);
    }

    /**
     * <p>
     * Provides information about any domain controllers in your directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDomainControllers(software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDomainControllersPublisher publisher = client.describeDomainControllersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeDomainControllersPublisher publisher = client.describeDomainControllersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainControllers(software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainControllersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainControllersRequest#builder()}
     * </p>
     *
     * @param describeDomainControllersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDomainControllersPublisher describeDomainControllersPaginator(
            Consumer<DescribeDomainControllersRequest.Builder> describeDomainControllersRequest) {
        return describeDomainControllersPaginator(DescribeDomainControllersRequest.builder()
                .applyMutation(describeDomainControllersRequest).build());
    }

    /**
     * <p>
     * Obtains information about which Amazon SNS topics receive status messages from the specified directory.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the
     * associations in the account.
     * </p>
     *
     * @param describeEventTopicsRequest
     *        Describes event topics.
     * @return A Java Future containing the result of the DescribeEventTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeEventTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventTopicsResponse> describeEventTopics(
            DescribeEventTopicsRequest describeEventTopicsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains information about which Amazon SNS topics receive status messages from the specified directory.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the
     * associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventTopicsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEventTopicsRequest#builder()}
     * </p>
     *
     * @param describeEventTopicsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest.Builder} to create a
     *        request. Describes event topics.
     * @return A Java Future containing the result of the DescribeEventTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeEventTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventTopicsResponse> describeEventTopics(
            Consumer<DescribeEventTopicsRequest.Builder> describeEventTopicsRequest) {
        return describeEventTopics(DescribeEventTopicsRequest.builder().applyMutation(describeEventTopicsRequest).build());
    }

    /**
     * <p>
     * Obtains information about which Amazon SNS topics receive status messages from the specified directory.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the
     * associations in the account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeEventTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventTopicsResponse> describeEventTopics() {
        return describeEventTopics(DescribeEventTopicsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the status of LDAP security for the specified directory.
     * </p>
     *
     * @param describeLdapsSettingsRequest
     * @return A Java Future containing the result of the DescribeLDAPSSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeLDAPSSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLdapsSettingsResponse> describeLDAPSSettings(
            DescribeLdapsSettingsRequest describeLdapsSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of LDAP security for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLdapsSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLdapsSettingsRequest#builder()}
     * </p>
     *
     * @param describeLdapsSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLDAPSSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeLDAPSSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeLdapsSettingsResponse> describeLDAPSSettings(
            Consumer<DescribeLdapsSettingsRequest.Builder> describeLdapsSettingsRequest) {
        return describeLDAPSSettings(DescribeLdapsSettingsRequest.builder().applyMutation(describeLdapsSettingsRequest).build());
    }

    /**
     * <p>
     * Describes the status of LDAP security for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLDAPSSettings(software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeLDAPSSettingsPublisher publisher = client.describeLDAPSSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeLDAPSSettingsPublisher publisher = client.describeLDAPSSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLDAPSSettings(software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLdapsSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeLDAPSSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLDAPSSettingsPublisher describeLDAPSSettingsPaginator(
            DescribeLdapsSettingsRequest describeLdapsSettingsRequest) {
        return new DescribeLDAPSSettingsPublisher(this, describeLdapsSettingsRequest);
    }

    /**
     * <p>
     * Describes the status of LDAP security for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLDAPSSettings(software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeLDAPSSettingsPublisher publisher = client.describeLDAPSSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeLDAPSSettingsPublisher publisher = client.describeLDAPSSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLDAPSSettings(software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLdapsSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLdapsSettingsRequest#builder()}
     * </p>
     *
     * @param describeLdapsSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeLDAPSSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLDAPSSettingsPublisher describeLDAPSSettingsPaginator(
            Consumer<DescribeLdapsSettingsRequest.Builder> describeLdapsSettingsRequest) {
        return describeLDAPSSettingsPaginator(DescribeLdapsSettingsRequest.builder().applyMutation(describeLdapsSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the Regions that are configured for multi-Region replication.
     * </p>
     *
     * @param describeRegionsRequest
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRegionsResponse> describeRegions(DescribeRegionsRequest describeRegionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the Regions that are configured for multi-Region replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRegionsRequest#builder()}
     * </p>
     *
     * @param describeRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeRegionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRegionsResponse> describeRegions(
            Consumer<DescribeRegionsRequest.Builder> describeRegionsRequest) {
        return describeRegions(DescribeRegionsRequest.builder().applyMutation(describeRegionsRequest).build());
    }

    /**
     * <p>
     * Provides information about the Regions that are configured for multi-Region replication.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRegions(software.amazon.awssdk.services.directory.model.DescribeRegionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeRegionsPublisher publisher = client.describeRegionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeRegionsPublisher publisher = client.describeRegionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeRegionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeRegionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegions(software.amazon.awssdk.services.directory.model.DescribeRegionsRequest)} operation.</b>
     * </p>
     *
     * @param describeRegionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRegionsPublisher describeRegionsPaginator(DescribeRegionsRequest describeRegionsRequest) {
        return new DescribeRegionsPublisher(this, describeRegionsRequest);
    }

    /**
     * <p>
     * Provides information about the Regions that are configured for multi-Region replication.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRegions(software.amazon.awssdk.services.directory.model.DescribeRegionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeRegionsPublisher publisher = client.describeRegionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeRegionsPublisher publisher = client.describeRegionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeRegionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeRegionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegions(software.amazon.awssdk.services.directory.model.DescribeRegionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRegionsRequest#builder()}
     * </p>
     *
     * @param describeRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeRegionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRegionsPublisher describeRegionsPaginator(Consumer<DescribeRegionsRequest.Builder> describeRegionsRequest) {
        return describeRegionsPaginator(DescribeRegionsRequest.builder().applyMutation(describeRegionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the configurable settings for the specified directory.
     * </p>
     *
     * @param describeSettingsRequest
     * @return A Java Future containing the result of the DescribeSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSettingsResponse> describeSettings(DescribeSettingsRequest describeSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the configurable settings for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSettingsRequest#builder()}
     * </p>
     *
     * @param describeSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSettingsResponse> describeSettings(
            Consumer<DescribeSettingsRequest.Builder> describeSettingsRequest) {
        return describeSettings(DescribeSettingsRequest.builder().applyMutation(describeSettingsRequest).build());
    }

    /**
     * <p>
     * Returns the shared directories in your account.
     * </p>
     *
     * @param describeSharedDirectoriesRequest
     * @return A Java Future containing the result of the DescribeSharedDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSharedDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSharedDirectoriesResponse> describeSharedDirectories(
            DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the shared directories in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSharedDirectoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSharedDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeSharedDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeSharedDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSharedDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeSharedDirectoriesResponse> describeSharedDirectories(
            Consumer<DescribeSharedDirectoriesRequest.Builder> describeSharedDirectoriesRequest) {
        return describeSharedDirectories(DescribeSharedDirectoriesRequest.builder()
                .applyMutation(describeSharedDirectoriesRequest).build());
    }

    /**
     * <p>
     * Returns the shared directories in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSharedDirectories(software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSharedDirectoriesPublisher publisher = client.describeSharedDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSharedDirectoriesPublisher publisher = client.describeSharedDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSharedDirectories(software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSharedDirectoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSharedDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSharedDirectoriesPublisher describeSharedDirectoriesPaginator(
            DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) {
        return new DescribeSharedDirectoriesPublisher(this, describeSharedDirectoriesRequest);
    }

    /**
     * <p>
     * Returns the shared directories in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSharedDirectories(software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSharedDirectoriesPublisher publisher = client.describeSharedDirectoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSharedDirectoriesPublisher publisher = client.describeSharedDirectoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSharedDirectories(software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSharedDirectoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSharedDirectoriesRequest#builder()}
     * </p>
     *
     * @param describeSharedDirectoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSharedDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSharedDirectoriesPublisher describeSharedDirectoriesPaginator(
            Consumer<DescribeSharedDirectoriesRequest.Builder> describeSharedDirectoriesRequest) {
        return describeSharedDirectoriesPaginator(DescribeSharedDirectoriesRequest.builder()
                .applyMutation(describeSharedDirectoriesRequest).build());
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Contains the inputs for the <a>DescribeSnapshots</a> operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest.Builder} to create a
     *        request. Contains the inputs for the <a>DescribeSnapshots</a> operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest) {
        return describeSnapshots(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotsResponse> describeSnapshots() {
        return describeSnapshots(DescribeSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSnapshotsPublisher describeSnapshotsPaginator() {
        return describeSnapshotsPaginator(DescribeSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Contains the inputs for the <a>DescribeSnapshots</a> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSnapshotsPublisher describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return new DescribeSnapshotsPublisher(this, describeSnapshotsRequest);
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest.Builder} to create a
     *        request. Contains the inputs for the <a>DescribeSnapshots</a> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSnapshotsPublisher describeSnapshotsPaginator(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest) {
        return describeSnapshotsPaginator(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     *
     * @param describeTrustsRequest
     *        Describes the trust relationships for a particular Managed Microsoft AD directory. If no input parameters
     *        are provided, such as directory ID or trust ID, this request describes all the trust relationships.
     * @return A Java Future containing the result of the DescribeTrusts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrustsResponse> describeTrusts(DescribeTrustsRequest describeTrustsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTrustsRequest#builder()}
     * </p>
     *
     * @param describeTrustsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeTrustsRequest.Builder} to create a request.
     *        Describes the trust relationships for a particular Managed Microsoft AD directory. If no input parameters
     *        are provided, such as directory ID or trust ID, this request describes all the trust relationships.
     * @return A Java Future containing the result of the DescribeTrusts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrustsResponse> describeTrusts(Consumer<DescribeTrustsRequest.Builder> describeTrustsRequest) {
        return describeTrusts(DescribeTrustsRequest.builder().applyMutation(describeTrustsRequest).build());
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTrusts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrustsResponse> describeTrusts() {
        return describeTrusts(DescribeTrustsRequest.builder().build());
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTrusts(software.amazon.awssdk.services.directory.model.DescribeTrustsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeTrustsPublisher publisher = client.describeTrustsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeTrustsPublisher publisher = client.describeTrustsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeTrustsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeTrustsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrusts(software.amazon.awssdk.services.directory.model.DescribeTrustsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTrustsPublisher describeTrustsPaginator() {
        return describeTrustsPaginator(DescribeTrustsRequest.builder().build());
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTrusts(software.amazon.awssdk.services.directory.model.DescribeTrustsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeTrustsPublisher publisher = client.describeTrustsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeTrustsPublisher publisher = client.describeTrustsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeTrustsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeTrustsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrusts(software.amazon.awssdk.services.directory.model.DescribeTrustsRequest)} operation.</b>
     * </p>
     *
     * @param describeTrustsRequest
     *        Describes the trust relationships for a particular Managed Microsoft AD directory. If no input parameters
     *        are provided, such as directory ID or trust ID, this request describes all the trust relationships.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTrustsPublisher describeTrustsPaginator(DescribeTrustsRequest describeTrustsRequest) {
        return new DescribeTrustsPublisher(this, describeTrustsRequest);
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTrusts(software.amazon.awssdk.services.directory.model.DescribeTrustsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeTrustsPublisher publisher = client.describeTrustsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeTrustsPublisher publisher = client.describeTrustsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeTrustsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeTrustsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTrusts(software.amazon.awssdk.services.directory.model.DescribeTrustsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrustsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTrustsRequest#builder()}
     * </p>
     *
     * @param describeTrustsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeTrustsRequest.Builder} to create a request.
     *        Describes the trust relationships for a particular Managed Microsoft AD directory. If no input parameters
     *        are provided, such as directory ID or trust ID, this request describes all the trust relationships.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTrustsPublisher describeTrustsPaginator(Consumer<DescribeTrustsRequest.Builder> describeTrustsRequest) {
        return describeTrustsPaginator(DescribeTrustsRequest.builder().applyMutation(describeTrustsRequest).build());
    }

    /**
     * <p>
     * Describes the updates of a directory for a particular update type.
     * </p>
     *
     * @param describeUpdateDirectoryRequest
     * @return A Java Future containing the result of the DescribeUpdateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeUpdateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeUpdateDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUpdateDirectoryResponse> describeUpdateDirectory(
            DescribeUpdateDirectoryRequest describeUpdateDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the updates of a directory for a particular update type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUpdateDirectoryRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeUpdateDirectoryRequest#builder()}
     * </p>
     *
     * @param describeUpdateDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeUpdateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeUpdateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeUpdateDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUpdateDirectoryResponse> describeUpdateDirectory(
            Consumer<DescribeUpdateDirectoryRequest.Builder> describeUpdateDirectoryRequest) {
        return describeUpdateDirectory(DescribeUpdateDirectoryRequest.builder().applyMutation(describeUpdateDirectoryRequest)
                .build());
    }

    /**
     * <p>
     * Describes the updates of a directory for a particular update type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUpdateDirectory(software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeUpdateDirectoryPublisher publisher = client.describeUpdateDirectoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeUpdateDirectoryPublisher publisher = client.describeUpdateDirectoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUpdateDirectory(software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeUpdateDirectoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeUpdateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeUpdateDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUpdateDirectoryPublisher describeUpdateDirectoryPaginator(
            DescribeUpdateDirectoryRequest describeUpdateDirectoryRequest) {
        return new DescribeUpdateDirectoryPublisher(this, describeUpdateDirectoryRequest);
    }

    /**
     * <p>
     * Describes the updates of a directory for a particular update type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUpdateDirectory(software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeUpdateDirectoryPublisher publisher = client.describeUpdateDirectoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.DescribeUpdateDirectoryPublisher publisher = client.describeUpdateDirectoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUpdateDirectory(software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUpdateDirectoryRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeUpdateDirectoryRequest#builder()}
     * </p>
     *
     * @param describeUpdateDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeUpdateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeUpdateDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUpdateDirectoryPublisher describeUpdateDirectoryPaginator(
            Consumer<DescribeUpdateDirectoryRequest.Builder> describeUpdateDirectoryRequest) {
        return describeUpdateDirectoryPaginator(DescribeUpdateDirectoryRequest.builder()
                .applyMutation(describeUpdateDirectoryRequest).build());
    }

    /**
     * <p>
     * Disables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param disableClientAuthenticationRequest
     * @return A Java Future containing the result of the DisableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableClientAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableClientAuthenticationResponse> disableClientAuthentication(
            DisableClientAuthenticationRequest disableClientAuthenticationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables alternative client authentication methods for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableClientAuthenticationRequest.Builder}
     * avoiding the need to create one manually via {@link DisableClientAuthenticationRequest#builder()}
     * </p>
     *
     * @param disableClientAuthenticationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableClientAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableClientAuthenticationResponse> disableClientAuthentication(
            Consumer<DisableClientAuthenticationRequest.Builder> disableClientAuthenticationRequest) {
        return disableClientAuthentication(DisableClientAuthenticationRequest.builder()
                .applyMutation(disableClientAuthenticationRequest).build());
    }

    /**
     * <p>
     * Deactivates LDAP secure calls for the specified directory.
     * </p>
     *
     * @param disableLdapsRequest
     * @return A Java Future containing the result of the DisableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableLdapsResponse> disableLDAPS(DisableLdapsRequest disableLdapsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates LDAP secure calls for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableLdapsRequest.Builder} avoiding the need to
     * create one manually via {@link DisableLdapsRequest#builder()}
     * </p>
     *
     * @param disableLdapsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DisableLdapsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableLdapsResponse> disableLDAPS(Consumer<DisableLdapsRequest.Builder> disableLdapsRequest) {
        return disableLDAPS(DisableLdapsRequest.builder().applyMutation(disableLdapsRequest).build());
    }

    /**
     * <p>
     * Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server
     * for an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param disableRadiusRequest
     *        Contains the inputs for the <a>DisableRadius</a> operation.
     * @return A Java Future containing the result of the DisableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableRadiusResponse> disableRadius(DisableRadiusRequest disableRadiusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server
     * for an AD Connector or Microsoft AD directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableRadiusRequest.Builder} avoiding the need to
     * create one manually via {@link DisableRadiusRequest#builder()}
     * </p>
     *
     * @param disableRadiusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DisableRadiusRequest.Builder} to create a request.
     *        Contains the inputs for the <a>DisableRadius</a> operation.
     * @return A Java Future containing the result of the DisableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableRadiusResponse> disableRadius(Consumer<DisableRadiusRequest.Builder> disableRadiusRequest) {
        return disableRadius(DisableRadiusRequest.builder().applyMutation(disableRadiusRequest).build());
    }

    /**
     * <p>
     * Disables single-sign on for a directory.
     * </p>
     *
     * @param disableSsoRequest
     *        Contains the inputs for the <a>DisableSso</a> operation.
     * @return A Java Future containing the result of the DisableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableSso" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableSsoResponse> disableSso(DisableSsoRequest disableSsoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables single-sign on for a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSsoRequest.Builder} avoiding the need to
     * create one manually via {@link DisableSsoRequest#builder()}
     * </p>
     *
     * @param disableSsoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.DisableSsoRequest.Builder} to create a request.
     *        Contains the inputs for the <a>DisableSso</a> operation.
     * @return A Java Future containing the result of the DisableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableSso" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableSsoResponse> disableSso(Consumer<DisableSsoRequest.Builder> disableSsoRequest) {
        return disableSso(DisableSsoRequest.builder().applyMutation(disableSsoRequest).build());
    }

    /**
     * <p>
     * Enables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param enableClientAuthenticationRequest
     * @return A Java Future containing the result of the EnableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableClientAuthentication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableClientAuthenticationResponse> enableClientAuthentication(
            EnableClientAuthenticationRequest enableClientAuthenticationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables alternative client authentication methods for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableClientAuthenticationRequest.Builder} avoiding
     * the need to create one manually via {@link EnableClientAuthenticationRequest#builder()}
     * </p>
     *
     * @param enableClientAuthenticationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableClientAuthentication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableClientAuthenticationResponse> enableClientAuthentication(
            Consumer<EnableClientAuthenticationRequest.Builder> enableClientAuthenticationRequest) {
        return enableClientAuthentication(EnableClientAuthenticationRequest.builder()
                .applyMutation(enableClientAuthenticationRequest).build());
    }

    /**
     * <p>
     * Activates the switch for the specific directory to always use LDAP secure calls.
     * </p>
     *
     * @param enableLdapsRequest
     * @return A Java Future containing the result of the EnableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableLdapsResponse> enableLDAPS(EnableLdapsRequest enableLdapsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates the switch for the specific directory to always use LDAP secure calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableLdapsRequest.Builder} avoiding the need to
     * create one manually via {@link EnableLdapsRequest#builder()}
     * </p>
     *
     * @param enableLdapsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.EnableLdapsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableLdapsResponse> enableLDAPS(Consumer<EnableLdapsRequest.Builder> enableLdapsRequest) {
        return enableLDAPS(EnableLdapsRequest.builder().applyMutation(enableLdapsRequest).build());
    }

    /**
     * <p>
     * Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for
     * an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param enableRadiusRequest
     *        Contains the inputs for the <a>EnableRadius</a> operation.
     * @return A Java Future containing the result of the EnableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableRadiusResponse> enableRadius(EnableRadiusRequest enableRadiusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for
     * an AD Connector or Microsoft AD directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableRadiusRequest.Builder} avoiding the need to
     * create one manually via {@link EnableRadiusRequest#builder()}
     * </p>
     *
     * @param enableRadiusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.EnableRadiusRequest.Builder} to create a request.
     *        Contains the inputs for the <a>EnableRadius</a> operation.
     * @return A Java Future containing the result of the EnableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableRadiusResponse> enableRadius(Consumer<EnableRadiusRequest.Builder> enableRadiusRequest) {
        return enableRadius(EnableRadiusRequest.builder().applyMutation(enableRadiusRequest).build());
    }

    /**
     * <p>
     * Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain Amazon
     * Web Services services from a computer joined to the directory without having to enter their credentials
     * separately.
     * </p>
     *
     * @param enableSsoRequest
     *        Contains the inputs for the <a>EnableSso</a> operation.
     * @return A Java Future containing the result of the EnableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableSso" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableSsoResponse> enableSso(EnableSsoRequest enableSsoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain Amazon
     * Web Services services from a computer joined to the directory without having to enter their credentials
     * separately.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSsoRequest.Builder} avoiding the need to
     * create one manually via {@link EnableSsoRequest#builder()}
     * </p>
     *
     * @param enableSsoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.EnableSsoRequest.Builder} to create a request.
     *        Contains the inputs for the <a>EnableSso</a> operation.
     * @return A Java Future containing the result of the EnableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableSso" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableSsoResponse> enableSso(Consumer<EnableSsoRequest.Builder> enableSsoRequest) {
        return enableSso(EnableSsoRequest.builder().applyMutation(enableSsoRequest).build());
    }

    /**
     * <p>
     * Obtains directory limit information for the current Region.
     * </p>
     *
     * @param getDirectoryLimitsRequest
     *        Contains the inputs for the <a>GetDirectoryLimits</a> operation.
     * @return A Java Future containing the result of the GetDirectoryLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetDirectoryLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDirectoryLimitsResponse> getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains directory limit information for the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDirectoryLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDirectoryLimitsRequest#builder()}
     * </p>
     *
     * @param getDirectoryLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest.Builder} to create a
     *        request. Contains the inputs for the <a>GetDirectoryLimits</a> operation.
     * @return A Java Future containing the result of the GetDirectoryLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetDirectoryLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDirectoryLimitsResponse> getDirectoryLimits(
            Consumer<GetDirectoryLimitsRequest.Builder> getDirectoryLimitsRequest) {
        return getDirectoryLimits(GetDirectoryLimitsRequest.builder().applyMutation(getDirectoryLimitsRequest).build());
    }

    /**
     * <p>
     * Obtains directory limit information for the current Region.
     * </p>
     *
     * @return A Java Future containing the result of the GetDirectoryLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetDirectoryLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDirectoryLimitsResponse> getDirectoryLimits() {
        return getDirectoryLimits(GetDirectoryLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Obtains the manual snapshot limits for a directory.
     * </p>
     *
     * @param getSnapshotLimitsRequest
     *        Contains the inputs for the <a>GetSnapshotLimits</a> operation.
     * @return A Java Future containing the result of the GetSnapshotLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetSnapshotLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetSnapshotLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSnapshotLimitsResponse> getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtains the manual snapshot limits for a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotLimitsRequest.Builder} avoiding the need
     * to create one manually via {@link GetSnapshotLimitsRequest#builder()}
     * </p>
     *
     * @param getSnapshotLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest.Builder} to create a
     *        request. Contains the inputs for the <a>GetSnapshotLimits</a> operation.
     * @return A Java Future containing the result of the GetSnapshotLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetSnapshotLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetSnapshotLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSnapshotLimitsResponse> getSnapshotLimits(
            Consumer<GetSnapshotLimitsRequest.Builder> getSnapshotLimitsRequest) {
        return getSnapshotLimits(GetSnapshotLimitsRequest.builder().applyMutation(getSnapshotLimitsRequest).build());
    }

    /**
     * <p>
     * For the specified directory, lists all the certificates registered for a secure LDAP or client certificate
     * authentication.
     * </p>
     *
     * @param listCertificatesRequest
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the specified directory, lists all the certificates registered for a secure LDAP or client certificate
     * authentication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListCertificatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCertificatesResponse> listCertificates(
            Consumer<ListCertificatesRequest.Builder> listCertificatesRequest) {
        return listCertificates(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * For the specified directory, lists all the certificates registered for a secure LDAP or client certificate
     * authentication.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificates(software.amazon.awssdk.services.directory.model.ListCertificatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.directory.model.ListCertificatesRequest)} operation.</b>
     * </p>
     *
     * @param listCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesPublisher listCertificatesPaginator(ListCertificatesRequest listCertificatesRequest) {
        return new ListCertificatesPublisher(this, listCertificatesRequest);
    }

    /**
     * <p>
     * For the specified directory, lists all the certificates registered for a secure LDAP or client certificate
     * authentication.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificates(software.amazon.awssdk.services.directory.model.ListCertificatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.directory.model.ListCertificatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListCertificatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesPublisher listCertificatesPaginator(Consumer<ListCertificatesRequest.Builder> listCertificatesRequest) {
        return listCertificatesPaginator(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the address blocks that you have added to a directory.
     * </p>
     *
     * @param listIpRoutesRequest
     * @return A Java Future containing the result of the ListIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpRoutesResponse> listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the address blocks that you have added to a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpRoutesRequest#builder()}
     * </p>
     *
     * @param listIpRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListIpRoutesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIpRoutesResponse> listIpRoutes(Consumer<ListIpRoutesRequest.Builder> listIpRoutesRequest) {
        return listIpRoutes(ListIpRoutesRequest.builder().applyMutation(listIpRoutesRequest).build());
    }

    /**
     * <p>
     * Lists the address blocks that you have added to a directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIpRoutes(software.amazon.awssdk.services.directory.model.ListIpRoutesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListIpRoutesPublisher publisher = client.listIpRoutesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListIpRoutesPublisher publisher = client.listIpRoutesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListIpRoutesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListIpRoutesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIpRoutes(software.amazon.awssdk.services.directory.model.ListIpRoutesRequest)} operation.</b>
     * </p>
     *
     * @param listIpRoutesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIpRoutesPublisher listIpRoutesPaginator(ListIpRoutesRequest listIpRoutesRequest) {
        return new ListIpRoutesPublisher(this, listIpRoutesRequest);
    }

    /**
     * <p>
     * Lists the address blocks that you have added to a directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIpRoutes(software.amazon.awssdk.services.directory.model.ListIpRoutesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListIpRoutesPublisher publisher = client.listIpRoutesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListIpRoutesPublisher publisher = client.listIpRoutesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListIpRoutesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListIpRoutesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIpRoutes(software.amazon.awssdk.services.directory.model.ListIpRoutesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIpRoutesRequest#builder()}
     * </p>
     *
     * @param listIpRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListIpRoutesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIpRoutesPublisher listIpRoutesPaginator(Consumer<ListIpRoutesRequest.Builder> listIpRoutesRequest) {
        return listIpRoutesPaginator(ListIpRoutesRequest.builder().applyMutation(listIpRoutesRequest).build());
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     *
     * @param listLogSubscriptionsRequest
     * @return A Java Future containing the result of the ListLogSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLogSubscriptionsResponse> listLogSubscriptions(
            ListLogSubscriptionsRequest listLogSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLogSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listLogSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLogSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLogSubscriptionsResponse> listLogSubscriptions(
            Consumer<ListLogSubscriptionsRequest.Builder> listLogSubscriptionsRequest) {
        return listLogSubscriptions(ListLogSubscriptionsRequest.builder().applyMutation(listLogSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the ListLogSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLogSubscriptionsResponse> listLogSubscriptions() {
        return listLogSubscriptions(ListLogSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogSubscriptions(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListLogSubscriptionsPublisher publisher = client.listLogSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListLogSubscriptionsPublisher publisher = client.listLogSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogSubscriptions(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLogSubscriptionsPublisher listLogSubscriptionsPaginator() {
        return listLogSubscriptionsPaginator(ListLogSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogSubscriptions(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListLogSubscriptionsPublisher publisher = client.listLogSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListLogSubscriptionsPublisher publisher = client.listLogSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogSubscriptions(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLogSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLogSubscriptionsPublisher listLogSubscriptionsPaginator(ListLogSubscriptionsRequest listLogSubscriptionsRequest) {
        return new ListLogSubscriptionsPublisher(this, listLogSubscriptionsRequest);
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLogSubscriptions(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListLogSubscriptionsPublisher publisher = client.listLogSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListLogSubscriptionsPublisher publisher = client.listLogSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLogSubscriptions(software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLogSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLogSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listLogSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLogSubscriptionsPublisher listLogSubscriptionsPaginator(
            Consumer<ListLogSubscriptionsRequest.Builder> listLogSubscriptionsRequest) {
        return listLogSubscriptionsPaginator(ListLogSubscriptionsRequest.builder().applyMutation(listLogSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all schema extensions applied to a Microsoft AD Directory.
     * </p>
     *
     * @param listSchemaExtensionsRequest
     * @return A Java Future containing the result of the ListSchemaExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListSchemaExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchemaExtensionsResponse> listSchemaExtensions(
            ListSchemaExtensionsRequest listSchemaExtensionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all schema extensions applied to a Microsoft AD Directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaExtensionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaExtensionsRequest#builder()}
     * </p>
     *
     * @param listSchemaExtensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSchemaExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListSchemaExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchemaExtensionsResponse> listSchemaExtensions(
            Consumer<ListSchemaExtensionsRequest.Builder> listSchemaExtensionsRequest) {
        return listSchemaExtensions(ListSchemaExtensionsRequest.builder().applyMutation(listSchemaExtensionsRequest).build());
    }

    /**
     * <p>
     * Lists all schema extensions applied to a Microsoft AD Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaExtensions(software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListSchemaExtensionsPublisher publisher = client.listSchemaExtensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListSchemaExtensionsPublisher publisher = client.listSchemaExtensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaExtensions(software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSchemaExtensionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListSchemaExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaExtensionsPublisher listSchemaExtensionsPaginator(ListSchemaExtensionsRequest listSchemaExtensionsRequest) {
        return new ListSchemaExtensionsPublisher(this, listSchemaExtensionsRequest);
    }

    /**
     * <p>
     * Lists all schema extensions applied to a Microsoft AD Directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaExtensions(software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListSchemaExtensionsPublisher publisher = client.listSchemaExtensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListSchemaExtensionsPublisher publisher = client.listSchemaExtensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaExtensions(software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaExtensionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaExtensionsRequest#builder()}
     * </p>
     *
     * @param listSchemaExtensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListSchemaExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaExtensionsPublisher listSchemaExtensionsPaginator(
            Consumer<ListSchemaExtensionsRequest.Builder> listSchemaExtensionsRequest) {
        return listSchemaExtensionsPaginator(ListSchemaExtensionsRequest.builder().applyMutation(listSchemaExtensionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all tags on a directory.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * Lists all tags on a directory.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.directory.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Registers a certificate for a secure LDAP or client certificate authentication.
     * </p>
     *
     * @param registerCertificateRequest
     * @return A Java Future containing the result of the RegisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidCertificateException The certificate PEM that was provided has incorrect encoding.</li>
     *         <li>CertificateLimitExceededException The certificate could not be added because the certificate limit
     *         has been reached.</li>
     *         <li>CertificateAlreadyExistsException The certificate has already been registered into the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RegisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterCertificateResponse> registerCertificate(
            RegisterCertificateRequest registerCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a certificate for a secure LDAP or client certificate authentication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterCertificateRequest#builder()}
     * </p>
     *
     * @param registerCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.RegisterCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidCertificateException The certificate PEM that was provided has incorrect encoding.</li>
     *         <li>CertificateLimitExceededException The certificate could not be added because the certificate limit
     *         has been reached.</li>
     *         <li>CertificateAlreadyExistsException The certificate has already been registered into the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RegisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterCertificateResponse> registerCertificate(
            Consumer<RegisterCertificateRequest.Builder> registerCertificateRequest) {
        return registerCertificate(RegisterCertificateRequest.builder().applyMutation(registerCertificateRequest).build());
    }

    /**
     * <p>
     * Associates a directory with an Amazon SNS topic. This establishes the directory as a publisher to the specified
     * Amazon SNS topic. You can then receive email or text (SMS) messages when the status of your directory changes.
     * You get notified if your directory goes from an Active status to an Impaired or Inoperable status. You also
     * receive a notification when the directory returns to an Active status.
     * </p>
     *
     * @param registerEventTopicRequest
     *        Registers a new event topic.
     * @return A Java Future containing the result of the RegisterEventTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RegisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterEventTopicResponse> registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a directory with an Amazon SNS topic. This establishes the directory as a publisher to the specified
     * Amazon SNS topic. You can then receive email or text (SMS) messages when the status of your directory changes.
     * You get notified if your directory goes from an Active status to an Impaired or Inoperable status. You also
     * receive a notification when the directory returns to an Active status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterEventTopicRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterEventTopicRequest#builder()}
     * </p>
     *
     * @param registerEventTopicRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest.Builder} to create a
     *        request. Registers a new event topic.
     * @return A Java Future containing the result of the RegisterEventTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RegisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterEventTopicResponse> registerEventTopic(
            Consumer<RegisterEventTopicRequest.Builder> registerEventTopicRequest) {
        return registerEventTopic(RegisterEventTopicRequest.builder().applyMutation(registerEventTopicRequest).build());
    }

    /**
     * <p>
     * Rejects a directory sharing request that was sent from the directory owner account.
     * </p>
     *
     * @param rejectSharedDirectoryRequest
     * @return A Java Future containing the result of the RejectSharedDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RejectSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RejectSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RejectSharedDirectoryResponse> rejectSharedDirectory(
            RejectSharedDirectoryRequest rejectSharedDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a directory sharing request that was sent from the directory owner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectSharedDirectoryRequest.Builder} avoiding the
     * need to create one manually via {@link RejectSharedDirectoryRequest#builder()}
     * </p>
     *
     * @param rejectSharedDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RejectSharedDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RejectSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RejectSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RejectSharedDirectoryResponse> rejectSharedDirectory(
            Consumer<RejectSharedDirectoryRequest.Builder> rejectSharedDirectoryRequest) {
        return rejectSharedDirectory(RejectSharedDirectoryRequest.builder().applyMutation(rejectSharedDirectoryRequest).build());
    }

    /**
     * <p>
     * Removes IP address blocks from a directory.
     * </p>
     *
     * @param removeIpRoutesRequest
     * @return A Java Future containing the result of the RemoveIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveIpRoutesResponse> removeIpRoutes(RemoveIpRoutesRequest removeIpRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes IP address blocks from a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveIpRoutesRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveIpRoutesRequest#builder()}
     * </p>
     *
     * @param removeIpRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RemoveIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveIpRoutesResponse> removeIpRoutes(Consumer<RemoveIpRoutesRequest.Builder> removeIpRoutesRequest) {
        return removeIpRoutes(RemoveIpRoutesRequest.builder().applyMutation(removeIpRoutesRequest).build());
    }

    /**
     * <p>
     * Stops all replication and removes the domain controllers from the specified Region. You cannot remove the primary
     * Region with this operation. Instead, use the <code>DeleteDirectory</code> API.
     * </p>
     *
     * @param removeRegionRequest
     * @return A Java Future containing the result of the RemoveRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveRegionResponse> removeRegion(RemoveRegionRequest removeRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops all replication and removes the domain controllers from the specified Region. You cannot remove the primary
     * Region with this operation. Instead, use the <code>DeleteDirectory</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveRegionRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveRegionRequest#builder()}
     * </p>
     *
     * @param removeRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.RemoveRegionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RemoveRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveRegionResponse> removeRegion(Consumer<RemoveRegionRequest.Builder> removeRegionRequest) {
        return removeRegion(RemoveRegionRequest.builder().applyMutation(removeRegionRequest).build());
    }

    /**
     * <p>
     * Removes tags from a directory.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveTagsFromResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveTagsFromResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Resets the password for any user in your Managed Microsoft AD or Simple AD directory.
     * </p>
     * <p>
     * You can reset the password for any user in your directory with the following exceptions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Simple AD, you cannot reset the password for any user that is a member of either the <b>Domain Admins</b> or
     * <b>Enterprise Admins</b> group except for the administrator user.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Managed Microsoft AD, you can only reset the password for a user that is in an OU based off of the NetBIOS
     * name that you typed when you created your directory. For example, you cannot reset the password for a user in the
     * <b>Amazon Web Services Reserved</b> OU. For more information about the OU structure for an Managed Microsoft AD
     * directory, see <a href=
     * "https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html"
     * >What Gets Created</a> in the <i>Directory Service Administration Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param resetUserPasswordRequest
     * @return A Java Future containing the result of the ResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>UserDoesNotExistException The user provided a username that does not exist in your directory.</li>
     *         <li>InvalidPasswordException The new password provided by the user does not meet the password complexity
     *         requirements defined in your directory.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ResetUserPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetUserPasswordResponse> resetUserPassword(ResetUserPasswordRequest resetUserPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets the password for any user in your Managed Microsoft AD or Simple AD directory.
     * </p>
     * <p>
     * You can reset the password for any user in your directory with the following exceptions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Simple AD, you cannot reset the password for any user that is a member of either the <b>Domain Admins</b> or
     * <b>Enterprise Admins</b> group except for the administrator user.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Managed Microsoft AD, you can only reset the password for a user that is in an OU based off of the NetBIOS
     * name that you typed when you created your directory. For example, you cannot reset the password for a user in the
     * <b>Amazon Web Services Reserved</b> OU. For more information about the OU structure for an Managed Microsoft AD
     * directory, see <a href=
     * "https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html"
     * >What Gets Created</a> in the <i>Directory Service Administration Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetUserPasswordRequest.Builder} avoiding the need
     * to create one manually via {@link ResetUserPasswordRequest#builder()}
     * </p>
     *
     * @param resetUserPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>UserDoesNotExistException The user provided a username that does not exist in your directory.</li>
     *         <li>InvalidPasswordException The new password provided by the user does not meet the password complexity
     *         requirements defined in your directory.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ResetUserPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetUserPasswordResponse> resetUserPassword(
            Consumer<ResetUserPasswordRequest.Builder> resetUserPasswordRequest) {
        return resetUserPassword(ResetUserPasswordRequest.builder().applyMutation(resetUserPasswordRequest).build());
    }

    /**
     * <p>
     * Restores a directory using an existing directory snapshot.
     * </p>
     * <p>
     * When you restore a directory from a snapshot, any changes made to the directory after the snapshot date are
     * overwritten.
     * </p>
     * <p>
     * This action returns as soon as the restore operation is initiated. You can monitor the progress of the restore
     * operation by calling the <a>DescribeDirectories</a> operation with the directory identifier. When the
     * <b>DirectoryDescription.Stage</b> value changes to <code>Active</code>, the restore operation is complete.
     * </p>
     *
     * @param restoreFromSnapshotRequest
     *        An object representing the inputs for the <a>RestoreFromSnapshot</a> operation.
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RestoreFromSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a directory using an existing directory snapshot.
     * </p>
     * <p>
     * When you restore a directory from a snapshot, any changes made to the directory after the snapshot date are
     * overwritten.
     * </p>
     * <p>
     * This action returns as soon as the restore operation is initiated. You can monitor the progress of the restore
     * operation by calling the <a>DescribeDirectories</a> operation with the directory identifier. When the
     * <b>DirectoryDescription.Stage</b> value changes to <code>Active</code>, the restore operation is complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest.Builder} to create a
     *        request. An object representing the inputs for the <a>RestoreFromSnapshot</a> operation.
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RestoreFromSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            Consumer<RestoreFromSnapshotRequest.Builder> restoreFromSnapshotRequest) {
        return restoreFromSnapshot(RestoreFromSnapshotRequest.builder().applyMutation(restoreFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Shares a specified directory (<code>DirectoryId</code>) in your Amazon Web Services account (directory owner)
     * with another Amazon Web Services account (directory consumer). With this operation you can use your directory
     * from any Amazon Web Services account and from any Amazon VPC within an Amazon Web Services Region.
     * </p>
     * <p>
     * When you share your Managed Microsoft AD directory, Directory Service creates a shared directory in the directory
     * consumer account. This shared directory contains the metadata to provide access to the directory within the
     * directory owner account. The shared directory is visible in all VPCs in the directory consumer account.
     * </p>
     * <p>
     * The <code>ShareMethod</code> parameter determines whether the specified directory can be shared between Amazon
     * Web Services accounts inside the same Amazon Web Services organization (<code>ORGANIZATIONS</code>). It also
     * determines whether you can share the directory with any other Amazon Web Services account either inside or
     * outside of the organization (<code>HANDSHAKE</code>).
     * </p>
     * <p>
     * The <code>ShareNotes</code> parameter is only used when <code>HANDSHAKE</code> is called, which sends a directory
     * sharing request to the directory consumer.
     * </p>
     *
     * @param shareDirectoryRequest
     * @return A Java Future containing the result of the ShareDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidTargetException The specified shared target is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ShareLimitExceededException The maximum number of Amazon Web Services accounts that you can share
     *         with this directory has been reached.</li>
     *         <li>OrganizationsException Exception encountered while trying to access your Amazon Web Services
     *         organization.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ShareDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ShareDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ShareDirectoryResponse> shareDirectory(ShareDirectoryRequest shareDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shares a specified directory (<code>DirectoryId</code>) in your Amazon Web Services account (directory owner)
     * with another Amazon Web Services account (directory consumer). With this operation you can use your directory
     * from any Amazon Web Services account and from any Amazon VPC within an Amazon Web Services Region.
     * </p>
     * <p>
     * When you share your Managed Microsoft AD directory, Directory Service creates a shared directory in the directory
     * consumer account. This shared directory contains the metadata to provide access to the directory within the
     * directory owner account. The shared directory is visible in all VPCs in the directory consumer account.
     * </p>
     * <p>
     * The <code>ShareMethod</code> parameter determines whether the specified directory can be shared between Amazon
     * Web Services accounts inside the same Amazon Web Services organization (<code>ORGANIZATIONS</code>). It also
     * determines whether you can share the directory with any other Amazon Web Services account either inside or
     * outside of the organization (<code>HANDSHAKE</code>).
     * </p>
     * <p>
     * The <code>ShareNotes</code> parameter is only used when <code>HANDSHAKE</code> is called, which sends a directory
     * sharing request to the directory consumer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ShareDirectoryRequest.Builder} avoiding the need to
     * create one manually via {@link ShareDirectoryRequest#builder()}
     * </p>
     *
     * @param shareDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.ShareDirectoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ShareDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidTargetException The specified shared target is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ShareLimitExceededException The maximum number of Amazon Web Services accounts that you can share
     *         with this directory has been reached.</li>
     *         <li>OrganizationsException Exception encountered while trying to access your Amazon Web Services
     *         organization.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ShareDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ShareDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ShareDirectoryResponse> shareDirectory(Consumer<ShareDirectoryRequest.Builder> shareDirectoryRequest) {
        return shareDirectory(ShareDirectoryRequest.builder().applyMutation(shareDirectoryRequest).build());
    }

    /**
     * <p>
     * Applies a schema extension to a Microsoft AD directory.
     * </p>
     *
     * @param startSchemaExtensionRequest
     * @return A Java Future containing the result of the StartSchemaExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.StartSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/StartSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartSchemaExtensionResponse> startSchemaExtension(
            StartSchemaExtensionRequest startSchemaExtensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a schema extension to a Microsoft AD directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSchemaExtensionRequest.Builder} avoiding the
     * need to create one manually via {@link StartSchemaExtensionRequest#builder()}
     * </p>
     *
     * @param startSchemaExtensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSchemaExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.StartSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/StartSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartSchemaExtensionResponse> startSchemaExtension(
            Consumer<StartSchemaExtensionRequest.Builder> startSchemaExtensionRequest) {
        return startSchemaExtension(StartSchemaExtensionRequest.builder().applyMutation(startSchemaExtensionRequest).build());
    }

    /**
     * <p>
     * Stops the directory sharing between the directory owner and consumer accounts.
     * </p>
     *
     * @param unshareDirectoryRequest
     * @return A Java Future containing the result of the UnshareDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidTargetException The specified shared target is not valid.</li>
     *         <li>DirectoryNotSharedException The specified directory has not been shared with this Amazon Web Services
     *         account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UnshareDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnshareDirectoryResponse> unshareDirectory(UnshareDirectoryRequest unshareDirectoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the directory sharing between the directory owner and consumer accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnshareDirectoryRequest.Builder} avoiding the need
     * to create one manually via {@link UnshareDirectoryRequest#builder()}
     * </p>
     *
     * @param unshareDirectoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UnshareDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidTargetException The specified shared target is not valid.</li>
     *         <li>DirectoryNotSharedException The specified directory has not been shared with this Amazon Web Services
     *         account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UnshareDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnshareDirectoryResponse> unshareDirectory(
            Consumer<UnshareDirectoryRequest.Builder> unshareDirectoryRequest) {
        return unshareDirectory(UnshareDirectoryRequest.builder().applyMutation(unshareDirectoryRequest).build());
    }

    /**
     * <p>
     * Updates a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     *
     * @param updateConditionalForwarderRequest
     *        Updates a conditional forwarder.
     * @return A Java Future containing the result of the UpdateConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConditionalForwarderResponse> updateConditionalForwarder(
            UpdateConditionalForwarderRequest updateConditionalForwarderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConditionalForwarderRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConditionalForwarderRequest#builder()}
     * </p>
     *
     * @param updateConditionalForwarderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest.Builder} to
     *        create a request. Updates a conditional forwarder.
     * @return A Java Future containing the result of the UpdateConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateConditionalForwarderResponse> updateConditionalForwarder(
            Consumer<UpdateConditionalForwarderRequest.Builder> updateConditionalForwarderRequest) {
        return updateConditionalForwarder(UpdateConditionalForwarderRequest.builder()
                .applyMutation(updateConditionalForwarderRequest).build());
    }

    /**
     * <p>
     * Updates the directory for a particular update type.
     * </p>
     *
     * @param updateDirectorySetupRequest
     * @return A Java Future containing the result of the UpdateDirectorySetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryInDesiredStateException The directory is already updated to desired update type settings.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateDirectorySetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateDirectorySetup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDirectorySetupResponse> updateDirectorySetup(
            UpdateDirectorySetupRequest updateDirectorySetupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the directory for a particular update type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDirectorySetupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDirectorySetupRequest#builder()}
     * </p>
     *
     * @param updateDirectorySetupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.UpdateDirectorySetupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDirectorySetup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryInDesiredStateException The directory is already updated to desired update type settings.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>AccessDeniedException Client authentication is not available in this region at this time.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateDirectorySetup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateDirectorySetup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDirectorySetupResponse> updateDirectorySetup(
            Consumer<UpdateDirectorySetupRequest.Builder> updateDirectorySetupRequest) {
        return updateDirectorySetup(UpdateDirectorySetupRequest.builder().applyMutation(updateDirectorySetupRequest).build());
    }

    /**
     * <p>
     * Adds or removes domain controllers to or from the directory. Based on the difference between current value and
     * new value (provided through this API call), domain controllers will be added or removed. It may take up to 45
     * minutes for any new domain controllers to become fully active once the requested number of domain controllers is
     * updated. During this time, you cannot make another update request.
     * </p>
     *
     * @param updateNumberOfDomainControllersRequest
     * @return A Java Future containing the result of the UpdateNumberOfDomainControllers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DomainControllerLimitExceededException The maximum allowed number of domain controllers per directory
     *         was exceeded. The default limit per directory is 20 domain controllers.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateNumberOfDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateNumberOfDomainControllers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNumberOfDomainControllersResponse> updateNumberOfDomainControllers(
            UpdateNumberOfDomainControllersRequest updateNumberOfDomainControllersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or removes domain controllers to or from the directory. Based on the difference between current value and
     * new value (provided through this API call), domain controllers will be added or removed. It may take up to 45
     * minutes for any new domain controllers to become fully active once the requested number of domain controllers is
     * updated. During this time, you cannot make another update request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNumberOfDomainControllersRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNumberOfDomainControllersRequest#builder()}
     * </p>
     *
     * @param updateNumberOfDomainControllersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateNumberOfDomainControllers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>DomainControllerLimitExceededException The maximum allowed number of domain controllers per directory
     *         was exceeded. The default limit per directory is 20 domain controllers.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateNumberOfDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateNumberOfDomainControllers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNumberOfDomainControllersResponse> updateNumberOfDomainControllers(
            Consumer<UpdateNumberOfDomainControllersRequest.Builder> updateNumberOfDomainControllersRequest) {
        return updateNumberOfDomainControllers(UpdateNumberOfDomainControllersRequest.builder()
                .applyMutation(updateNumberOfDomainControllersRequest).build());
    }

    /**
     * <p>
     * Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or
     * Microsoft AD directory.
     * </p>
     *
     * @param updateRadiusRequest
     *        Contains the inputs for the <a>UpdateRadius</a> operation.
     * @return A Java Future containing the result of the UpdateRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadius" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRadiusResponse> updateRadius(UpdateRadiusRequest updateRadiusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or
     * Microsoft AD directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRadiusRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRadiusRequest#builder()}
     * </p>
     *
     * @param updateRadiusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.UpdateRadiusRequest.Builder} to create a request.
     *        Contains the inputs for the <a>UpdateRadius</a> operation.
     * @return A Java Future containing the result of the UpdateRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadius" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRadiusResponse> updateRadius(Consumer<UpdateRadiusRequest.Builder> updateRadiusRequest) {
        return updateRadius(UpdateRadiusRequest.builder().applyMutation(updateRadiusRequest).build());
    }

    /**
     * <p>
     * Updates the configurable settings for the specified directory.
     * </p>
     *
     * @param updateSettingsRequest
     * @return A Java Future containing the result of the UpdateSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>IncompatibleSettingsException The specified directory setting is not compatible with other settings.</li>
     *         <li>UnsupportedSettingsException The specified directory setting is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSettingsResponse> updateSettings(UpdateSettingsRequest updateSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configurable settings for the specified directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSettingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSettingsRequest#builder()}
     * </p>
     *
     * @param updateSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.UpdateSettingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable or could not be found.</li>
     *         <li>IncompatibleSettingsException The specified directory setting is not compatible with other settings.</li>
     *         <li>UnsupportedSettingsException The specified directory setting is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSettingsResponse> updateSettings(Consumer<UpdateSettingsRequest.Builder> updateSettingsRequest) {
        return updateSettings(UpdateSettingsRequest.builder().applyMutation(updateSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the trust that has been set up between your Managed Microsoft AD directory and an self-managed Active
     * Directory.
     * </p>
     *
     * @param updateTrustRequest
     * @return A Java Future containing the result of the UpdateTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrustResponse> updateTrust(UpdateTrustRequest updateTrustRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the trust that has been set up between your Managed Microsoft AD directory and an self-managed Active
     * Directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrustRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTrustRequest#builder()}
     * </p>
     *
     * @param updateTrustRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.UpdateTrustRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.UpdateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrustResponse> updateTrust(Consumer<UpdateTrustRequest.Builder> updateTrustRequest) {
        return updateTrust(UpdateTrustRequest.builder().applyMutation(updateTrustRequest).build());
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships.
     * </p>
     * <p>
     * This action verifies a trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     *
     * @param verifyTrustRequest
     *        Initiates the verification of an existing trust relationship between an Managed Microsoft AD directory and
     *        an external domain.
     * @return A Java Future containing the result of the VerifyTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.VerifyTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/VerifyTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyTrustResponse> verifyTrust(VerifyTrustRequest verifyTrustRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships.
     * </p>
     * <p>
     * This action verifies a trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyTrustRequest.Builder} avoiding the need to
     * create one manually via {@link VerifyTrustRequest#builder()}
     * </p>
     *
     * @param verifyTrustRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directory.model.VerifyTrustRequest.Builder} to create a request.
     *        Initiates the verification of an existing trust relationship between an Managed Microsoft AD directory and
     *        an external domain.
     * @return A Java Future containing the result of the VerifyTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.VerifyTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/VerifyTrust" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<VerifyTrustResponse> verifyTrust(Consumer<VerifyTrustRequest.Builder> verifyTrustRequest) {
        return verifyTrust(VerifyTrustRequest.builder().applyMutation(verifyTrustRequest).build());
    }

    @Override
    default DirectoryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DirectoryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DirectoryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DirectoryAsyncClient}.
     */
    static DirectoryAsyncClientBuilder builder() {
        return new DefaultDirectoryAsyncClientBuilder();
    }
}
