/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about scoring strategy for an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormScoringStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormScoringStrategy.Builder, EvaluationFormScoringStrategy> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(EvaluationFormScoringStrategy::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EvaluationFormScoringStrategy::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String status;

    private EvaluationFormScoringStrategy(BuilderImpl builder) {
        this.mode = builder.mode;
        this.status = builder.status;
    }

    /**
     * <p>
     * The scoring mode of the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link EvaluationFormScoringMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The scoring mode of the evaluation form.
     * @see EvaluationFormScoringMode
     */
    public final EvaluationFormScoringMode mode() {
        return EvaluationFormScoringMode.fromValue(mode);
    }

    /**
     * <p>
     * The scoring mode of the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link EvaluationFormScoringMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The scoring mode of the evaluation form.
     * @see EvaluationFormScoringMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The scoring status of the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationFormScoringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The scoring status of the evaluation form.
     * @see EvaluationFormScoringStatus
     */
    public final EvaluationFormScoringStatus status() {
        return EvaluationFormScoringStatus.fromValue(status);
    }

    /**
     * <p>
     * The scoring status of the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationFormScoringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The scoring status of the evaluation form.
     * @see EvaluationFormScoringStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormScoringStrategy)) {
            return false;
        }
        EvaluationFormScoringStrategy other = (EvaluationFormScoringStrategy) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormScoringStrategy").add("Mode", modeAsString()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormScoringStrategy, T> g) {
        return obj -> g.apply((EvaluationFormScoringStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormScoringStrategy> {
        /**
         * <p>
         * The scoring mode of the evaluation form.
         * </p>
         * 
         * @param mode
         *        The scoring mode of the evaluation form.
         * @see EvaluationFormScoringMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormScoringMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The scoring mode of the evaluation form.
         * </p>
         * 
         * @param mode
         *        The scoring mode of the evaluation form.
         * @see EvaluationFormScoringMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormScoringMode
         */
        Builder mode(EvaluationFormScoringMode mode);

        /**
         * <p>
         * The scoring status of the evaluation form.
         * </p>
         * 
         * @param status
         *        The scoring status of the evaluation form.
         * @see EvaluationFormScoringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormScoringStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The scoring status of the evaluation form.
         * </p>
         * 
         * @param status
         *        The scoring status of the evaluation form.
         * @see EvaluationFormScoringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormScoringStatus
         */
        Builder status(EvaluationFormScoringStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormScoringStrategy model) {
            mode(model.mode);
            status(model.status);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(EvaluationFormScoringMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationFormScoringStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EvaluationFormScoringStrategy build() {
            return new EvaluationFormScoringStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
