/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a scaling plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingPlan implements SdkPojo, Serializable, ToCopyableBuilder<ScalingPlan.Builder, ScalingPlan> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingPlanName").getter(getter(ScalingPlan::scalingPlanName)).setter(setter(Builder::scalingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()).build();

    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScalingPlanVersion").getter(getter(ScalingPlan::scalingPlanVersion))
            .setter(setter(Builder::scalingPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build())
            .build();

    private static final SdkField<ApplicationSource> APPLICATION_SOURCE_FIELD = SdkField
            .<ApplicationSource> builder(MarshallingType.SDK_POJO).memberName("ApplicationSource")
            .getter(getter(ScalingPlan::applicationSource)).setter(setter(Builder::applicationSource))
            .constructor(ApplicationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSource").build()).build();

    private static final SdkField<List<ScalingInstruction>> SCALING_INSTRUCTIONS_FIELD = SdkField
            .<List<ScalingInstruction>> builder(MarshallingType.LIST)
            .memberName("ScalingInstructions")
            .getter(getter(ScalingPlan::scalingInstructions))
            .setter(setter(Builder::scalingInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingInstructions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingInstruction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingInstruction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(ScalingPlan::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ScalingPlan::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> STATUS_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StatusStartTime").getter(getter(ScalingPlan::statusStartTime)).setter(setter(Builder::statusStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusStartTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ScalingPlan::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD,
            SCALING_PLAN_VERSION_FIELD, APPLICATION_SOURCE_FIELD, SCALING_INSTRUCTIONS_FIELD, STATUS_CODE_FIELD,
            STATUS_MESSAGE_FIELD, STATUS_START_TIME_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scalingPlanName;

    private final Long scalingPlanVersion;

    private final ApplicationSource applicationSource;

    private final List<ScalingInstruction> scalingInstructions;

    private final String statusCode;

    private final String statusMessage;

    private final Instant statusStartTime;

    private final Instant creationTime;

    private ScalingPlan(BuilderImpl builder) {
        this.scalingPlanName = builder.scalingPlanName;
        this.scalingPlanVersion = builder.scalingPlanVersion;
        this.applicationSource = builder.applicationSource;
        this.scalingInstructions = builder.scalingInstructions;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.statusStartTime = builder.statusStartTime;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the scaling plan.
     * </p>
     * 
     * @return The name of the scaling plan.
     */
    public final String scalingPlanName() {
        return scalingPlanName;
    }

    /**
     * <p>
     * The version number of the scaling plan.
     * </p>
     * 
     * @return The version number of the scaling plan.
     */
    public final Long scalingPlanVersion() {
        return scalingPlanVersion;
    }

    /**
     * <p>
     * A CloudFormation stack or a set of tags. You can create one scaling plan per application source.
     * </p>
     * 
     * @return A CloudFormation stack or a set of tags. You can create one scaling plan per application source.
     */
    public final ApplicationSource applicationSource() {
        return applicationSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalingInstructions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalingInstructions() {
        return scalingInstructions != null && !(scalingInstructions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scaling instructions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalingInstructions} method.
     * </p>
     * 
     * @return The scaling instructions.
     */
    public final List<ScalingInstruction> scalingInstructions() {
        return scalingInstructions;
    }

    /**
     * <p>
     * The status of the scaling plan.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code> - The scaling plan is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more
     * resources could not be applied.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationInProgress</code> - The scaling plan is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationFailed</code> - The scaling plan could not be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletionInProgress</code> - The scaling plan is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletionFailed</code> - The scaling plan could not be deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - The scaling plan is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateFailed</code> - The scaling plan could not be updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScalingPlanStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status of the scaling plan.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code> - The scaling plan is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or
     *         more resources could not be applied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreationInProgress</code> - The scaling plan is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreationFailed</code> - The scaling plan could not be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletionInProgress</code> - The scaling plan is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletionFailed</code> - The scaling plan could not be deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - The scaling plan is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateFailed</code> - The scaling plan could not be updated.
     *         </p>
     *         </li>
     * @see ScalingPlanStatusCode
     */
    public final ScalingPlanStatusCode statusCode() {
        return ScalingPlanStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * The status of the scaling plan.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code> - The scaling plan is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more
     * resources could not be applied.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationInProgress</code> - The scaling plan is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationFailed</code> - The scaling plan could not be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletionInProgress</code> - The scaling plan is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletionFailed</code> - The scaling plan could not be deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - The scaling plan is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateFailed</code> - The scaling plan could not be updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScalingPlanStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status of the scaling plan.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code> - The scaling plan is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or
     *         more resources could not be applied.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreationInProgress</code> - The scaling plan is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreationFailed</code> - The scaling plan could not be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletionInProgress</code> - The scaling plan is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletionFailed</code> - The scaling plan could not be deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - The scaling plan is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateFailed</code> - The scaling plan could not be updated.
     *         </p>
     *         </li>
     * @see ScalingPlanStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * A simple message about the current status of the scaling plan.
     * </p>
     * 
     * @return A simple message about the current status of the scaling plan.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The Unix time stamp when the scaling plan entered the current status.
     * </p>
     * 
     * @return The Unix time stamp when the scaling plan entered the current status.
     */
    public final Instant statusStartTime() {
        return statusStartTime;
    }

    /**
     * <p>
     * The Unix time stamp when the scaling plan was created.
     * </p>
     * 
     * @return The Unix time stamp when the scaling plan was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingInstructions() ? scalingInstructions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(statusStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPlan)) {
            return false;
        }
        ScalingPlan other = (ScalingPlan) obj;
        return Objects.equals(scalingPlanName(), other.scalingPlanName())
                && Objects.equals(scalingPlanVersion(), other.scalingPlanVersion())
                && Objects.equals(applicationSource(), other.applicationSource())
                && hasScalingInstructions() == other.hasScalingInstructions()
                && Objects.equals(scalingInstructions(), other.scalingInstructions())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(statusStartTime(), other.statusStartTime())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingPlan").add("ScalingPlanName", scalingPlanName())
                .add("ScalingPlanVersion", scalingPlanVersion()).add("ApplicationSource", applicationSource())
                .add("ScalingInstructions", hasScalingInstructions() ? scalingInstructions() : null)
                .add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage())
                .add("StatusStartTime", statusStartTime()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanName":
            return Optional.ofNullable(clazz.cast(scalingPlanName()));
        case "ScalingPlanVersion":
            return Optional.ofNullable(clazz.cast(scalingPlanVersion()));
        case "ApplicationSource":
            return Optional.ofNullable(clazz.cast(applicationSource()));
        case "ScalingInstructions":
            return Optional.ofNullable(clazz.cast(scalingInstructions()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "StatusStartTime":
            return Optional.ofNullable(clazz.cast(statusStartTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPlan, T> g) {
        return obj -> g.apply((ScalingPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingPlan> {
        /**
         * <p>
         * The name of the scaling plan.
         * </p>
         * 
         * @param scalingPlanName
         *        The name of the scaling plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanName(String scalingPlanName);

        /**
         * <p>
         * The version number of the scaling plan.
         * </p>
         * 
         * @param scalingPlanVersion
         *        The version number of the scaling plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanVersion(Long scalingPlanVersion);

        /**
         * <p>
         * A CloudFormation stack or a set of tags. You can create one scaling plan per application source.
         * </p>
         * 
         * @param applicationSource
         *        A CloudFormation stack or a set of tags. You can create one scaling plan per application source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSource(ApplicationSource applicationSource);

        /**
         * <p>
         * A CloudFormation stack or a set of tags. You can create one scaling plan per application source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationSource.Builder} avoiding the
         * need to create one manually via {@link ApplicationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSource.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationSource(ApplicationSource)}.
         * 
         * @param applicationSource
         *        a consumer that will call methods on {@link ApplicationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSource(ApplicationSource)
         */
        default Builder applicationSource(Consumer<ApplicationSource.Builder> applicationSource) {
            return applicationSource(ApplicationSource.builder().applyMutation(applicationSource).build());
        }

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * 
         * @param scalingInstructions
         *        The scaling instructions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions);

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * 
         * @param scalingInstructions
         *        The scaling instructions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingInstructions(ScalingInstruction... scalingInstructions);

        /**
         * <p>
         * The scaling instructions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingInstructions(List<ScalingInstruction>)}.
         * 
         * @param scalingInstructions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingInstructions(java.util.Collection<ScalingInstruction>)
         */
        Builder scalingInstructions(Consumer<ScalingInstruction.Builder>... scalingInstructions);

        /**
         * <p>
         * The status of the scaling plan.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code> - The scaling plan is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more
         * resources could not be applied.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreationInProgress</code> - The scaling plan is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreationFailed</code> - The scaling plan could not be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletionInProgress</code> - The scaling plan is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletionFailed</code> - The scaling plan could not be deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - The scaling plan is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateFailed</code> - The scaling plan could not be updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusCode
         *        The status of the scaling plan.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code> - The scaling plan is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or
         *        more resources could not be applied.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreationInProgress</code> - The scaling plan is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreationFailed</code> - The scaling plan could not be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletionInProgress</code> - The scaling plan is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletionFailed</code> - The scaling plan could not be deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - The scaling plan is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateFailed</code> - The scaling plan could not be updated.
         *        </p>
         *        </li>
         * @see ScalingPlanStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingPlanStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The status of the scaling plan.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code> - The scaling plan is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or more
         * resources could not be applied.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreationInProgress</code> - The scaling plan is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreationFailed</code> - The scaling plan could not be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletionInProgress</code> - The scaling plan is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletionFailed</code> - The scaling plan could not be deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - The scaling plan is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateFailed</code> - The scaling plan could not be updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusCode
         *        The status of the scaling plan.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code> - The scaling plan is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ActiveWithProblems</code> - The scaling plan is active, but the scaling configuration for one or
         *        more resources could not be applied.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreationInProgress</code> - The scaling plan is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreationFailed</code> - The scaling plan could not be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletionInProgress</code> - The scaling plan is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletionFailed</code> - The scaling plan could not be deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - The scaling plan is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateFailed</code> - The scaling plan could not be updated.
         *        </p>
         *        </li>
         * @see ScalingPlanStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingPlanStatusCode
         */
        Builder statusCode(ScalingPlanStatusCode statusCode);

        /**
         * <p>
         * A simple message about the current status of the scaling plan.
         * </p>
         * 
         * @param statusMessage
         *        A simple message about the current status of the scaling plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The Unix time stamp when the scaling plan entered the current status.
         * </p>
         * 
         * @param statusStartTime
         *        The Unix time stamp when the scaling plan entered the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusStartTime(Instant statusStartTime);

        /**
         * <p>
         * The Unix time stamp when the scaling plan was created.
         * </p>
         * 
         * @param creationTime
         *        The Unix time stamp when the scaling plan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String scalingPlanName;

        private Long scalingPlanVersion;

        private ApplicationSource applicationSource;

        private List<ScalingInstruction> scalingInstructions = DefaultSdkAutoConstructList.getInstance();

        private String statusCode;

        private String statusMessage;

        private Instant statusStartTime;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPlan model) {
            scalingPlanName(model.scalingPlanName);
            scalingPlanVersion(model.scalingPlanVersion);
            applicationSource(model.applicationSource);
            scalingInstructions(model.scalingInstructions);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
            statusStartTime(model.statusStartTime);
            creationTime(model.creationTime);
        }

        public final String getScalingPlanName() {
            return scalingPlanName;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final Long getScalingPlanVersion() {
            return scalingPlanVersion;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final ApplicationSource.Builder getApplicationSource() {
            return applicationSource != null ? applicationSource.toBuilder() : null;
        }

        public final void setApplicationSource(ApplicationSource.BuilderImpl applicationSource) {
            this.applicationSource = applicationSource != null ? applicationSource.build() : null;
        }

        @Override
        public final Builder applicationSource(ApplicationSource applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        public final List<ScalingInstruction.Builder> getScalingInstructions() {
            List<ScalingInstruction.Builder> result = ScalingInstructionsCopier.copyToBuilder(this.scalingInstructions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingInstructions(Collection<ScalingInstruction.BuilderImpl> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copyFromBuilder(scalingInstructions);
        }

        @Override
        public final Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copy(scalingInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(ScalingInstruction... scalingInstructions) {
            scalingInstructions(Arrays.asList(scalingInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(Consumer<ScalingInstruction.Builder>... scalingInstructions) {
            scalingInstructions(Stream.of(scalingInstructions).map(c -> ScalingInstruction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ScalingPlanStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStatusStartTime() {
            return statusStartTime;
        }

        public final void setStatusStartTime(Instant statusStartTime) {
            this.statusStartTime = statusStartTime;
        }

        @Override
        public final Builder statusStartTime(Instant statusStartTime) {
            this.statusStartTime = statusStartTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public ScalingPlan build() {
            return new ScalingPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
