/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the service discovery information for a service mesh.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeshServiceDiscovery implements SdkPojo, Serializable,
        ToCopyableBuilder<MeshServiceDiscovery.Builder, MeshServiceDiscovery> {
    private static final SdkField<String> IP_PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipPreference").getter(getter(MeshServiceDiscovery::ipPreferenceAsString))
            .setter(setter(Builder::ipPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPreference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_PREFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipPreference;

    private MeshServiceDiscovery(BuilderImpl builder) {
        this.ipPreference = builder.ipPreference;
    }

    /**
     * <p>
     * The IP version to use to control traffic within the mesh.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipPreference} will
     * return {@link IpPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipPreferenceAsString}.
     * </p>
     * 
     * @return The IP version to use to control traffic within the mesh.
     * @see IpPreference
     */
    public final IpPreference ipPreference() {
        return IpPreference.fromValue(ipPreference);
    }

    /**
     * <p>
     * The IP version to use to control traffic within the mesh.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipPreference} will
     * return {@link IpPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipPreferenceAsString}.
     * </p>
     * 
     * @return The IP version to use to control traffic within the mesh.
     * @see IpPreference
     */
    public final String ipPreferenceAsString() {
        return ipPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipPreferenceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeshServiceDiscovery)) {
            return false;
        }
        MeshServiceDiscovery other = (MeshServiceDiscovery) obj;
        return Objects.equals(ipPreferenceAsString(), other.ipPreferenceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeshServiceDiscovery").add("IpPreference", ipPreferenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipPreference":
            return Optional.ofNullable(clazz.cast(ipPreferenceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeshServiceDiscovery, T> g) {
        return obj -> g.apply((MeshServiceDiscovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeshServiceDiscovery> {
        /**
         * <p>
         * The IP version to use to control traffic within the mesh.
         * </p>
         * 
         * @param ipPreference
         *        The IP version to use to control traffic within the mesh.
         * @see IpPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpPreference
         */
        Builder ipPreference(String ipPreference);

        /**
         * <p>
         * The IP version to use to control traffic within the mesh.
         * </p>
         * 
         * @param ipPreference
         *        The IP version to use to control traffic within the mesh.
         * @see IpPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpPreference
         */
        Builder ipPreference(IpPreference ipPreference);
    }

    static final class BuilderImpl implements Builder {
        private String ipPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(MeshServiceDiscovery model) {
            ipPreference(model.ipPreference);
        }

        public final String getIpPreference() {
            return ipPreference;
        }

        public final void setIpPreference(String ipPreference) {
            this.ipPreference = ipPreference;
        }

        @Override
        public final Builder ipPreference(String ipPreference) {
            this.ipPreference = ipPreference;
            return this;
        }

        @Override
        public final Builder ipPreference(IpPreference ipPreference) {
            this.ipPreference(ipPreference == null ? null : ipPreference.toString());
            return this;
        }

        @Override
        public MeshServiceDiscovery build() {
            return new MeshServiceDiscovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
