/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Spend
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Spend> {
    private static final SdkField<BigDecimal> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BIG_DECIMAL).memberName("Amount").getter(Spend.getter(Spend::amount)).setter(Spend.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(Spend.getter(Spend::unit)).setter(Spend.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Spend.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BigDecimal amount;
    private final String unit;

    private Spend(BuilderImpl builder) {
        this.amount = builder.amount;
        this.unit = builder.unit;
    }

    public final BigDecimal amount() {
        return this.amount;
    }

    public final String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spend)) {
            return false;
        }
        Spend other = (Spend)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.unit(), other.unit());
    }

    public final String toString() {
        return ToString.builder((String)"Spend").add("Amount", (Object)this.amount()).add("Unit", (Object)this.unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Amount", AMOUNT_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Spend, T> g) {
        return obj -> g.apply((Spend)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BigDecimal amount;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Spend model) {
            this.amount(model.amount);
            this.unit(model.unit);
        }

        public final BigDecimal getAmount() {
            return this.amount;
        }

        public final void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Spend build() {
            return new Spend(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Spend> {
        public Builder amount(BigDecimal var1);

        public Builder unit(String var1);
    }
}

