/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.Action;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse;

public class DescribeBudgetActionsForBudgetPublisher
implements SdkPublisher<DescribeBudgetActionsForBudgetResponse> {
    private final BudgetsAsyncClient client;
    private final DescribeBudgetActionsForBudgetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBudgetActionsForBudgetPublisher(BudgetsAsyncClient client, DescribeBudgetActionsForBudgetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBudgetActionsForBudgetPublisher(BudgetsAsyncClient client, DescribeBudgetActionsForBudgetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBudgetActionsForBudgetResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBudgetActionsForBudgetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Action> actions() {
        Function<DescribeBudgetActionsForBudgetResponse, Iterator> getIterator = response -> {
            if (response != null && response.actions() != null) {
                return response.actions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBudgetActionsForBudgetResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBudgetActionsForBudgetResponseFetcher
    implements AsyncPageFetcher<DescribeBudgetActionsForBudgetResponse> {
        private DescribeBudgetActionsForBudgetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetActionsForBudgetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBudgetActionsForBudgetResponse> nextPage(DescribeBudgetActionsForBudgetResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetActionsForBudgetPublisher.this.client.describeBudgetActionsForBudget(DescribeBudgetActionsForBudgetPublisher.this.firstRequest);
            }
            return DescribeBudgetActionsForBudgetPublisher.this.client.describeBudgetActionsForBudget((DescribeBudgetActionsForBudgetRequest)((Object)DescribeBudgetActionsForBudgetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

