/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.TargetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScpActionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScpActionDefinition> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(ScpActionDefinition.getter(ScpActionDefinition::policyId)).setter(ScpActionDefinition.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<List<String>> TARGET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetIds").getter(ScpActionDefinition.getter(ScpActionDefinition::targetIds)).setter(ScpActionDefinition.setter(Builder::targetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, TARGET_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final List<String> targetIds;

    private ScpActionDefinition(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.targetIds = builder.targetIds;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final boolean hasTargetIds() {
        return this.targetIds != null && !(this.targetIds instanceof SdkAutoConstructList);
    }

    public final List<String> targetIds() {
        return this.targetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetIds() ? this.targetIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScpActionDefinition)) {
            return false;
        }
        ScpActionDefinition other = (ScpActionDefinition)obj;
        return Objects.equals(this.policyId(), other.policyId()) && this.hasTargetIds() == other.hasTargetIds() && Objects.equals(this.targetIds(), other.targetIds());
    }

    public final String toString() {
        return ToString.builder((String)"ScpActionDefinition").add("PolicyId", (Object)this.policyId()).add("TargetIds", this.hasTargetIds() ? this.targetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "TargetIds": {
                return Optional.ofNullable(clazz.cast(this.targetIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScpActionDefinition, T> g) {
        return obj -> g.apply((ScpActionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private List<String> targetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScpActionDefinition model) {
            this.policyId(model.policyId);
            this.targetIds(model.targetIds);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final Collection<String> getTargetIds() {
            if (this.targetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetIds;
        }

        public final void setTargetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdsCopier.copy(targetIds);
        }

        @Override
        public final Builder targetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdsCopier.copy(targetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIds(String ... targetIds) {
            this.targetIds(Arrays.asList(targetIds));
            return this;
        }

        public ScpActionDefinition build() {
            return new ScpActionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScpActionDefinition> {
        public Builder policyId(String var1);

        public Builder targetIds(Collection<String> var1);

        public Builder targetIds(String ... var1);
    }
}

