/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.budgets.model.BudgetType;
import software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmounts;
import software.amazon.awssdk.services.budgets.model.BudgetedAndActualAmountsListCopier;
import software.amazon.awssdk.services.budgets.model.CostFiltersCopier;
import software.amazon.awssdk.services.budgets.model.CostTypes;
import software.amazon.awssdk.services.budgets.model.TimeUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BudgetPerformanceHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BudgetPerformanceHistory> {
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(BudgetPerformanceHistory.getter(BudgetPerformanceHistory::budgetName)).setter(BudgetPerformanceHistory.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<String> BUDGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetType").getter(BudgetPerformanceHistory.getter(BudgetPerformanceHistory::budgetTypeAsString)).setter(BudgetPerformanceHistory.setter(Builder::budgetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetType").build()}).build();
    private static final SdkField<Map<String, List<String>>> COST_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CostFilters").getter(BudgetPerformanceHistory.getter(BudgetPerformanceHistory::costFilters)).setter(BudgetPerformanceHistory.setter(Builder::costFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostFilters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<CostTypes> COST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CostTypes").getter(BudgetPerformanceHistory.getter(BudgetPerformanceHistory::costTypes)).setter(BudgetPerformanceHistory.setter(Builder::costTypes)).constructor(CostTypes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostTypes").build()}).build();
    private static final SdkField<String> TIME_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeUnit").getter(BudgetPerformanceHistory.getter(BudgetPerformanceHistory::timeUnitAsString)).setter(BudgetPerformanceHistory.setter(Builder::timeUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeUnit").build()}).build();
    private static final SdkField<List<BudgetedAndActualAmounts>> BUDGETED_AND_ACTUAL_AMOUNTS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BudgetedAndActualAmountsList").getter(BudgetPerformanceHistory.getter(BudgetPerformanceHistory::budgetedAndActualAmountsList)).setter(BudgetPerformanceHistory.setter(Builder::budgetedAndActualAmountsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetedAndActualAmountsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetedAndActualAmounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_NAME_FIELD, BUDGET_TYPE_FIELD, COST_FILTERS_FIELD, COST_TYPES_FIELD, TIME_UNIT_FIELD, BUDGETED_AND_ACTUAL_AMOUNTS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BudgetName", BUDGET_NAME_FIELD);
            this.put("BudgetType", BUDGET_TYPE_FIELD);
            this.put("CostFilters", COST_FILTERS_FIELD);
            this.put("CostTypes", COST_TYPES_FIELD);
            this.put("TimeUnit", TIME_UNIT_FIELD);
            this.put("BudgetedAndActualAmountsList", BUDGETED_AND_ACTUAL_AMOUNTS_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String budgetName;
    private final String budgetType;
    private final Map<String, List<String>> costFilters;
    private final CostTypes costTypes;
    private final String timeUnit;
    private final List<BudgetedAndActualAmounts> budgetedAndActualAmountsList;

    private BudgetPerformanceHistory(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetType = builder.budgetType;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.budgetedAndActualAmountsList = builder.budgetedAndActualAmountsList;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final BudgetType budgetType() {
        return BudgetType.fromValue(this.budgetType);
    }

    public final String budgetTypeAsString() {
        return this.budgetType;
    }

    public final boolean hasCostFilters() {
        return this.costFilters != null && !(this.costFilters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> costFilters() {
        return this.costFilters;
    }

    public final CostTypes costTypes() {
        return this.costTypes;
    }

    public final TimeUnit timeUnit() {
        return TimeUnit.fromValue(this.timeUnit);
    }

    public final String timeUnitAsString() {
        return this.timeUnit;
    }

    public final boolean hasBudgetedAndActualAmountsList() {
        return this.budgetedAndActualAmountsList != null && !(this.budgetedAndActualAmountsList instanceof SdkAutoConstructList);
    }

    public final List<BudgetedAndActualAmounts> budgetedAndActualAmountsList() {
        return this.budgetedAndActualAmountsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostFilters() ? this.costFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.costTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBudgetedAndActualAmountsList() ? this.budgetedAndActualAmountsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetPerformanceHistory)) {
            return false;
        }
        BudgetPerformanceHistory other = (BudgetPerformanceHistory)obj;
        return Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.budgetTypeAsString(), other.budgetTypeAsString()) && this.hasCostFilters() == other.hasCostFilters() && Objects.equals(this.costFilters(), other.costFilters()) && Objects.equals(this.costTypes(), other.costTypes()) && Objects.equals(this.timeUnitAsString(), other.timeUnitAsString()) && this.hasBudgetedAndActualAmountsList() == other.hasBudgetedAndActualAmountsList() && Objects.equals(this.budgetedAndActualAmountsList(), other.budgetedAndActualAmountsList());
    }

    public final String toString() {
        return ToString.builder((String)"BudgetPerformanceHistory").add("BudgetName", (Object)this.budgetName()).add("BudgetType", (Object)this.budgetTypeAsString()).add("CostFilters", this.hasCostFilters() ? this.costFilters() : null).add("CostTypes", (Object)this.costTypes()).add("TimeUnit", (Object)this.timeUnitAsString()).add("BudgetedAndActualAmountsList", this.hasBudgetedAndActualAmountsList() ? this.budgetedAndActualAmountsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "BudgetType": {
                return Optional.ofNullable(clazz.cast(this.budgetTypeAsString()));
            }
            case "CostFilters": {
                return Optional.ofNullable(clazz.cast(this.costFilters()));
            }
            case "CostTypes": {
                return Optional.ofNullable(clazz.cast(this.costTypes()));
            }
            case "TimeUnit": {
                return Optional.ofNullable(clazz.cast(this.timeUnitAsString()));
            }
            case "BudgetedAndActualAmountsList": {
                return Optional.ofNullable(clazz.cast(this.budgetedAndActualAmountsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BudgetPerformanceHistory, T> g) {
        return obj -> g.apply((BudgetPerformanceHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String budgetName;
        private String budgetType;
        private Map<String, List<String>> costFilters = DefaultSdkAutoConstructMap.getInstance();
        private CostTypes costTypes;
        private String timeUnit;
        private List<BudgetedAndActualAmounts> budgetedAndActualAmountsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetPerformanceHistory model) {
            this.budgetName(model.budgetName);
            this.budgetType(model.budgetType);
            this.costFilters(model.costFilters);
            this.costTypes(model.costTypes);
            this.timeUnit(model.timeUnit);
            this.budgetedAndActualAmountsList(model.budgetedAndActualAmountsList);
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final String getBudgetType() {
            return this.budgetType;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType == null ? null : budgetType.toString());
            return this;
        }

        public final Map<String, ? extends Collection<String>> getCostFilters() {
            if (this.costFilters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.costFilters;
        }

        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        @Override
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        public final CostTypes.Builder getCostTypes() {
            return this.costTypes != null ? this.costTypes.toBuilder() : null;
        }

        public final void setCostTypes(CostTypes.BuilderImpl costTypes) {
            this.costTypes = costTypes != null ? costTypes.build() : null;
        }

        @Override
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit == null ? null : timeUnit.toString());
            return this;
        }

        public final List<BudgetedAndActualAmounts.Builder> getBudgetedAndActualAmountsList() {
            List<BudgetedAndActualAmounts.Builder> result = BudgetedAndActualAmountsListCopier.copyToBuilder(this.budgetedAndActualAmountsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgetedAndActualAmountsList(Collection<BudgetedAndActualAmounts.BuilderImpl> budgetedAndActualAmountsList) {
            this.budgetedAndActualAmountsList = BudgetedAndActualAmountsListCopier.copyFromBuilder(budgetedAndActualAmountsList);
        }

        @Override
        public final Builder budgetedAndActualAmountsList(Collection<BudgetedAndActualAmounts> budgetedAndActualAmountsList) {
            this.budgetedAndActualAmountsList = BudgetedAndActualAmountsListCopier.copy(budgetedAndActualAmountsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetedAndActualAmountsList(BudgetedAndActualAmounts ... budgetedAndActualAmountsList) {
            this.budgetedAndActualAmountsList(Arrays.asList(budgetedAndActualAmountsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetedAndActualAmountsList(Consumer<BudgetedAndActualAmounts.Builder> ... budgetedAndActualAmountsList) {
            this.budgetedAndActualAmountsList(Stream.of(budgetedAndActualAmountsList).map(c -> (BudgetedAndActualAmounts)((BudgetedAndActualAmounts.Builder)BudgetedAndActualAmounts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BudgetPerformanceHistory build() {
            return new BudgetPerformanceHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BudgetPerformanceHistory> {
        public Builder budgetName(String var1);

        public Builder budgetType(String var1);

        public Builder budgetType(BudgetType var1);

        public Builder costFilters(Map<String, ? extends Collection<String>> var1);

        public Builder costTypes(CostTypes var1);

        default public Builder costTypes(Consumer<CostTypes.Builder> costTypes) {
            return this.costTypes((CostTypes)((CostTypes.Builder)CostTypes.builder().applyMutation(costTypes)).build());
        }

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder budgetedAndActualAmountsList(Collection<BudgetedAndActualAmounts> var1);

        public Builder budgetedAndActualAmountsList(BudgetedAndActualAmounts ... var1);

        public Builder budgetedAndActualAmountsList(Consumer<BudgetedAndActualAmounts.Builder> ... var1);
    }
}

