/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.ActionHistoryDetails;
import software.amazon.awssdk.services.budgets.model.ActionStatus;
import software.amazon.awssdk.services.budgets.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionHistory> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(ActionHistory.getter(ActionHistory::timestamp)).setter(ActionHistory.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ActionHistory.getter(ActionHistory::statusAsString)).setter(ActionHistory.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(ActionHistory.getter(ActionHistory::eventTypeAsString)).setter(ActionHistory.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<ActionHistoryDetails> ACTION_HISTORY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActionHistoryDetails").getter(ActionHistory.getter(ActionHistory::actionHistoryDetails)).setter(ActionHistory.setter(Builder::actionHistoryDetails)).constructor(ActionHistoryDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionHistoryDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, STATUS_FIELD, EVENT_TYPE_FIELD, ACTION_HISTORY_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Timestamp", TIMESTAMP_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("EventType", EVENT_TYPE_FIELD);
            this.put("ActionHistoryDetails", ACTION_HISTORY_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String status;
    private final String eventType;
    private final ActionHistoryDetails actionHistoryDetails;

    private ActionHistory(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.status = builder.status;
        this.eventType = builder.eventType;
        this.actionHistoryDetails = builder.actionHistoryDetails;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final ActionHistoryDetails actionHistoryDetails() {
        return this.actionHistoryDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionHistoryDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionHistory)) {
            return false;
        }
        ActionHistory other = (ActionHistory)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.actionHistoryDetails(), other.actionHistoryDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ActionHistory").add("Timestamp", (Object)this.timestamp()).add("Status", (Object)this.statusAsString()).add("EventType", (Object)this.eventTypeAsString()).add("ActionHistoryDetails", (Object)this.actionHistoryDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "ActionHistoryDetails": {
                return Optional.ofNullable(clazz.cast(this.actionHistoryDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActionHistory, T> g) {
        return obj -> g.apply((ActionHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String status;
        private String eventType;
        private ActionHistoryDetails actionHistoryDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionHistory model) {
            this.timestamp(model.timestamp);
            this.status(model.status);
            this.eventType(model.eventType);
            this.actionHistoryDetails(model.actionHistoryDetails);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final ActionHistoryDetails.Builder getActionHistoryDetails() {
            return this.actionHistoryDetails != null ? this.actionHistoryDetails.toBuilder() : null;
        }

        public final void setActionHistoryDetails(ActionHistoryDetails.BuilderImpl actionHistoryDetails) {
            this.actionHistoryDetails = actionHistoryDetails != null ? actionHistoryDetails.build() : null;
        }

        @Override
        public final Builder actionHistoryDetails(ActionHistoryDetails actionHistoryDetails) {
            this.actionHistoryDetails = actionHistoryDetails;
            return this;
        }

        public ActionHistory build() {
            return new ActionHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionHistory> {
        public Builder timestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder actionHistoryDetails(ActionHistoryDetails var1);

        default public Builder actionHistoryDetails(Consumer<ActionHistoryDetails.Builder> actionHistoryDetails) {
            return this.actionHistoryDetails((ActionHistoryDetails)((ActionHistoryDetails.Builder)ActionHistoryDetails.builder().applyMutation(actionHistoryDetails)).build());
        }
    }
}

