/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionSubType {
    STOP_EC2_INSTANCES("STOP_EC2_INSTANCES"),
    STOP_RDS_INSTANCES("STOP_RDS_INSTANCES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionSubType> VALUE_MAP;
    private final String value;

    private ActionSubType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionSubType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionSubType> knownValues() {
        EnumSet<ActionSubType> knownValues = EnumSet.allOf(ActionSubType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionSubType.class, ActionSubType::toString);
    }
}

