/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteBudgetActionResponse extends BudgetsResponse implements
        ToCopyableBuilder<ExecuteBudgetActionResponse.Builder, ExecuteBudgetActionResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ExecuteBudgetActionResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetName").getter(getter(ExecuteBudgetActionResponse::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionId").getter(getter(ExecuteBudgetActionResponse::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> EXECUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionType").getter(getter(ExecuteBudgetActionResponse::executionTypeAsString))
            .setter(setter(Builder::executionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUDGET_NAME_FIELD, ACTION_ID_FIELD, EXECUTION_TYPE_FIELD));

    private final String accountId;

    private final String budgetName;

    private final String actionId;

    private final String executionType;

    private ExecuteBudgetActionResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.actionId = builder.actionId;
        this.executionType = builder.executionType;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public final String budgetName() {
        return budgetName;
    }

    /**
     * <p>
     * A system-generated universally unique identifier (UUID) for the action.
     * </p>
     * 
     * @return A system-generated universally unique identifier (UUID) for the action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The type of execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionType}
     * will return {@link ExecutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executionTypeAsString}.
     * </p>
     * 
     * @return The type of execution.
     * @see ExecutionType
     */
    public final ExecutionType executionType() {
        return ExecutionType.fromValue(executionType);
    }

    /**
     * <p>
     * The type of execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionType}
     * will return {@link ExecutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #executionTypeAsString}.
     * </p>
     * 
     * @return The type of execution.
     * @see ExecutionType
     */
    public final String executionTypeAsString() {
        return executionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(executionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteBudgetActionResponse)) {
            return false;
        }
        ExecuteBudgetActionResponse other = (ExecuteBudgetActionResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(actionId(), other.actionId())
                && Objects.equals(executionTypeAsString(), other.executionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteBudgetActionResponse").add("AccountId", accountId()).add("BudgetName", budgetName())
                .add("ActionId", actionId()).add("ExecutionType", executionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "ExecutionType":
            return Optional.ofNullable(clazz.cast(executionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteBudgetActionResponse, T> g) {
        return obj -> g.apply((ExecuteBudgetActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteBudgetActionResponse> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * <p>
         * A system-generated universally unique identifier (UUID) for the action.
         * </p>
         * 
         * @param actionId
         *        A system-generated universally unique identifier (UUID) for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The type of execution.
         * </p>
         * 
         * @param executionType
         *        The type of execution.
         * @see ExecutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionType
         */
        Builder executionType(String executionType);

        /**
         * <p>
         * The type of execution.
         * </p>
         * 
         * @param executionType
         *        The type of execution.
         * @see ExecutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionType
         */
        Builder executionType(ExecutionType executionType);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private String actionId;

        private String executionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteBudgetActionResponse model) {
            super(model);
            accountId(model.accountId);
            budgetName(model.budgetName);
            actionId(model.actionId);
            executionType(model.executionType);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getExecutionType() {
            return executionType;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        @Override
        public final Builder executionType(ExecutionType executionType) {
            this.executionType(executionType == null ? null : executionType.toString());
            return this;
        }

        @Override
        public ExecuteBudgetActionResponse build() {
            return new ExecuteBudgetActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
