/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApprovalModel {
    AUTOMATIC("AUTOMATIC"),
    MANUAL("MANUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApprovalModel> VALUE_MAP;
    private final String value;

    private ApprovalModel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApprovalModel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApprovalModel> knownValues() {
        EnumSet<ApprovalModel> knownValues = EnumSet.allOf(ApprovalModel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApprovalModel.class, ApprovalModel::toString);
    }
}

