/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse;

public class DescribeBudgetsPublisher
implements SdkPublisher<DescribeBudgetsResponse> {
    private final BudgetsAsyncClient client;
    private final DescribeBudgetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBudgetsPublisher(BudgetsAsyncClient client, DescribeBudgetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBudgetsPublisher(BudgetsAsyncClient client, DescribeBudgetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBudgetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBudgetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Budget> budgets() {
        Function<DescribeBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.budgets() != null) {
                return response.budgets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBudgetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBudgetsResponseFetcher
    implements AsyncPageFetcher<DescribeBudgetsResponse> {
        private DescribeBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBudgetsResponse> nextPage(DescribeBudgetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetsPublisher.this.client.describeBudgets(DescribeBudgetsPublisher.this.firstRequest);
            }
            return DescribeBudgetsPublisher.this.client.describeBudgets((DescribeBudgetsRequest)((Object)DescribeBudgetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

