/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExecutionType {
    APPROVE_BUDGET_ACTION("APPROVE_BUDGET_ACTION"),
    RETRY_BUDGET_ACTION("RETRY_BUDGET_ACTION"),
    REVERSE_BUDGET_ACTION("REVERSE_BUDGET_ACTION"),
    RESET_BUDGET_ACTION("RESET_BUDGET_ACTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExecutionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExecutionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionType> knownValues() {
        return Stream.of(ExecutionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

