/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculatedSpend
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CalculatedSpend> {
    private static final SdkField<Spend> ACTUAL_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActualSpend").getter(CalculatedSpend.getter(CalculatedSpend::actualSpend)).setter(CalculatedSpend.setter(Builder::actualSpend)).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualSpend").build()}).build();
    private static final SdkField<Spend> FORECASTED_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForecastedSpend").getter(CalculatedSpend.getter(CalculatedSpend::forecastedSpend)).setter(CalculatedSpend.setter(Builder::forecastedSpend)).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastedSpend").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_SPEND_FIELD, FORECASTED_SPEND_FIELD));
    private static final long serialVersionUID = 1L;
    private final Spend actualSpend;
    private final Spend forecastedSpend;

    private CalculatedSpend(BuilderImpl builder) {
        this.actualSpend = builder.actualSpend;
        this.forecastedSpend = builder.forecastedSpend;
    }

    public final Spend actualSpend() {
        return this.actualSpend;
    }

    public final Spend forecastedSpend() {
        return this.forecastedSpend;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actualSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastedSpend());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedSpend)) {
            return false;
        }
        CalculatedSpend other = (CalculatedSpend)obj;
        return Objects.equals(this.actualSpend(), other.actualSpend()) && Objects.equals(this.forecastedSpend(), other.forecastedSpend());
    }

    public final String toString() {
        return ToString.builder((String)"CalculatedSpend").add("ActualSpend", (Object)this.actualSpend()).add("ForecastedSpend", (Object)this.forecastedSpend()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActualSpend": {
                return Optional.ofNullable(clazz.cast(this.actualSpend()));
            }
            case "ForecastedSpend": {
                return Optional.ofNullable(clazz.cast(this.forecastedSpend()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculatedSpend, T> g) {
        return obj -> g.apply((CalculatedSpend)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Spend actualSpend;
        private Spend forecastedSpend;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedSpend model) {
            this.actualSpend(model.actualSpend);
            this.forecastedSpend(model.forecastedSpend);
        }

        public final Spend.Builder getActualSpend() {
            return this.actualSpend != null ? this.actualSpend.toBuilder() : null;
        }

        @Override
        public final Builder actualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
            return this;
        }

        public final void setActualSpend(Spend.BuilderImpl actualSpend) {
            this.actualSpend = actualSpend != null ? actualSpend.build() : null;
        }

        public final Spend.Builder getForecastedSpend() {
            return this.forecastedSpend != null ? this.forecastedSpend.toBuilder() : null;
        }

        @Override
        public final Builder forecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
            return this;
        }

        public final void setForecastedSpend(Spend.BuilderImpl forecastedSpend) {
            this.forecastedSpend = forecastedSpend != null ? forecastedSpend.build() : null;
        }

        public CalculatedSpend build() {
            return new CalculatedSpend(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CalculatedSpend> {
        public Builder actualSpend(Spend var1);

        default public Builder actualSpend(Consumer<Spend.Builder> actualSpend) {
            return this.actualSpend((Spend)((Spend.Builder)Spend.builder().applyMutation(actualSpend)).build());
        }

        public Builder forecastedSpend(Spend var1);

        default public Builder forecastedSpend(Consumer<Spend.Builder> forecastedSpend) {
            return this.forecastedSpend((Spend)((Spend.Builder)Spend.builder().applyMutation(forecastedSpend)).build());
        }
    }
}

