/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSubscriberRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, UpdateSubscriberRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::accountId)).setter(UpdateSubscriberRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::budgetName)).setter(UpdateSubscriberRequest.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::notification)).setter(UpdateSubscriberRequest.setter(Builder::notification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<Subscriber> OLD_SUBSCRIBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::oldSubscriber)).setter(UpdateSubscriberRequest.setter(Builder::oldSubscriber)).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldSubscriber").build()}).build();
    private static final SdkField<Subscriber> NEW_SUBSCRIBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateSubscriberRequest.getter(UpdateSubscriberRequest::newSubscriber)).setter(UpdateSubscriberRequest.setter(Builder::newSubscriber)).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewSubscriber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUDGET_NAME_FIELD, NOTIFICATION_FIELD, OLD_SUBSCRIBER_FIELD, NEW_SUBSCRIBER_FIELD));
    private final String accountId;
    private final String budgetName;
    private final Notification notification;
    private final Subscriber oldSubscriber;
    private final Subscriber newSubscriber;

    private UpdateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.oldSubscriber = builder.oldSubscriber;
        this.newSubscriber = builder.newSubscriber;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification notification() {
        return this.notification;
    }

    public Subscriber oldSubscriber() {
        return this.oldSubscriber;
    }

    public Subscriber newSubscriber() {
        return this.newSubscriber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldSubscriber());
        hashCode = 31 * hashCode + Objects.hashCode(this.newSubscriber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.oldSubscriber(), other.oldSubscriber()) && Objects.equals(this.newSubscriber(), other.newSubscriber());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSubscriberRequest").add("AccountId", (Object)this.accountId()).add("BudgetName", (Object)this.budgetName()).add("Notification", (Object)this.notification()).add("OldSubscriber", (Object)this.oldSubscriber()).add("NewSubscriber", (Object)this.newSubscriber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "OldSubscriber": {
                return Optional.ofNullable(clazz.cast(this.oldSubscriber()));
            }
            case "NewSubscriber": {
                return Optional.ofNullable(clazz.cast(this.newSubscriber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriberRequest, T> g) {
        return obj -> g.apply((UpdateSubscriberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification notification;
        private Subscriber oldSubscriber;
        private Subscriber newSubscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.notification(model.notification);
            this.oldSubscriber(model.oldSubscriber);
            this.newSubscriber(model.newSubscriber);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Subscriber.Builder getOldSubscriber() {
            return this.oldSubscriber != null ? this.oldSubscriber.toBuilder() : null;
        }

        @Override
        public final Builder oldSubscriber(Subscriber oldSubscriber) {
            this.oldSubscriber = oldSubscriber;
            return this;
        }

        public final void setOldSubscriber(Subscriber.BuilderImpl oldSubscriber) {
            this.oldSubscriber = oldSubscriber != null ? oldSubscriber.build() : null;
        }

        public final Subscriber.Builder getNewSubscriber() {
            return this.newSubscriber != null ? this.newSubscriber.toBuilder() : null;
        }

        @Override
        public final Builder newSubscriber(Subscriber newSubscriber) {
            this.newSubscriber = newSubscriber;
            return this;
        }

        public final void setNewSubscriber(Subscriber.BuilderImpl newSubscriber) {
            this.newSubscriber = newSubscriber != null ? newSubscriber.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSubscriberRequest build() {
            return new UpdateSubscriberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSubscriberRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder oldSubscriber(Subscriber var1);

        default public Builder oldSubscriber(Consumer<Subscriber.Builder> oldSubscriber) {
            return this.oldSubscriber((Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation(oldSubscriber)).build());
        }

        public Builder newSubscriber(Subscriber var1);

        default public Builder newSubscriber(Consumer<Subscriber.Builder> newSubscriber) {
            return this.newSubscriber((Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation(newSubscriber)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

