/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateNotificationRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();
    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OLDNOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OldNotification").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NEWNOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewNotification").isBinary(false).build();
    private static final UpdateNotificationRequestModelMarshaller INSTANCE = new UpdateNotificationRequestModelMarshaller();

    private UpdateNotificationRequestModelMarshaller() {
    }

    public static UpdateNotificationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateNotificationRequest updateNotificationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateNotificationRequest), (String)"updateNotificationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateNotificationRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)updateNotificationRequest.budgetName(), BUDGETNAME_BINDING);
            protocolMarshaller.marshall((Object)updateNotificationRequest.oldNotification(), OLDNOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)updateNotificationRequest.newNotification(), NEWNOTIFICATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

