/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotificationWithSubscribersMarshaller {
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").isBinary(false).build();
    private static final MarshallingInfo<List> SUBSCRIBERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subscribers").isBinary(false).build();
    private static final NotificationWithSubscribersMarshaller INSTANCE = new NotificationWithSubscribersMarshaller();

    private NotificationWithSubscribersMarshaller() {
    }

    public static NotificationWithSubscribersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotificationWithSubscribers notificationWithSubscribers, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notificationWithSubscribers, (String)"notificationWithSubscribers");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notificationWithSubscribers.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall(notificationWithSubscribers.subscribers(), SUBSCRIBERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

