/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.model.BudgetsCopier;
import software.amazon.awssdk.services.budgets.model.BudgetsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeBudgetsResponse
extends BudgetsResponse
implements ToCopyableBuilder<Builder, DescribeBudgetsResponse> {
    private final List<Budget> budgets;
    private final String nextToken;

    private DescribeBudgetsResponse(BuilderImpl builder) {
        super(builder);
        this.budgets = builder.budgets;
        this.nextToken = builder.nextToken;
    }

    public List<Budget> budgets() {
        return this.budgets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.budgets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetsResponse)) {
            return false;
        }
        DescribeBudgetsResponse other = (DescribeBudgetsResponse)((Object)obj);
        return Objects.equals(this.budgets(), other.budgets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBudgetsResponse").add("Budgets", this.budgets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Budgets": {
                return Optional.of(clazz.cast(this.budgets()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BudgetsResponse.BuilderImpl
    implements Builder {
        private List<Budget> budgets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetsResponse model) {
            this.budgets(model.budgets);
            this.nextToken(model.nextToken);
        }

        public final Collection<Budget.Builder> getBudgets() {
            return this.budgets != null ? (Collection)this.budgets.stream().map(Budget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder budgets(Collection<Budget> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Budget ... budgets) {
            this.budgets(Arrays.asList(budgets));
            return this;
        }

        public final void setBudgets(Collection<Budget.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBudgetsResponse build() {
            return new DescribeBudgetsResponse(this);
        }
    }

    public static interface Builder
    extends BudgetsResponse.Builder,
    CopyableBuilder<Builder, DescribeBudgetsResponse> {
        public Builder budgets(Collection<Budget> var1);

        public Builder budgets(Budget ... var1);

        public Builder nextToken(String var1);
    }
}

