/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers;
import software.amazon.awssdk.services.budgets.model.NotificationWithSubscribersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBudgetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateBudgetRequest> {
    private final String accountId;
    private final Budget budget;
    private final List<NotificationWithSubscribers> notificationsWithSubscribers;

    private CreateBudgetRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budget = builder.budget;
        this.notificationsWithSubscribers = builder.notificationsWithSubscribers;
    }

    public String accountId() {
        return this.accountId;
    }

    public Budget budget() {
        return this.budget;
    }

    public List<NotificationWithSubscribers> notificationsWithSubscribers() {
        return this.notificationsWithSubscribers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.budget() == null ? 0 : this.budget().hashCode());
        hashCode = 31 * hashCode + (this.notificationsWithSubscribers() == null ? 0 : this.notificationsWithSubscribers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budget() == null ^ this.budget() == null) {
            return false;
        }
        if (other.budget() != null && !other.budget().equals(this.budget())) {
            return false;
        }
        if (other.notificationsWithSubscribers() == null ^ this.notificationsWithSubscribers() == null) {
            return false;
        }
        return other.notificationsWithSubscribers() == null || other.notificationsWithSubscribers().equals(this.notificationsWithSubscribers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.budget() != null) {
            sb.append("Budget: ").append(this.budget()).append(",");
        }
        if (this.notificationsWithSubscribers() != null) {
            sb.append("NotificationsWithSubscribers: ").append(this.notificationsWithSubscribers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Budget budget;
        private List<NotificationWithSubscribers> notificationsWithSubscribers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBudgetRequest model) {
            this.setAccountId(model.accountId);
            this.setBudget(model.budget);
            this.setNotificationsWithSubscribers(model.notificationsWithSubscribers);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Budget getBudget() {
            return this.budget;
        }

        @Override
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public final void setBudget(Budget budget) {
            this.budget = budget;
        }

        public final Collection<NotificationWithSubscribers> getNotificationsWithSubscribers() {
            return this.notificationsWithSubscribers;
        }

        @Override
        public final Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier.copy(notificationsWithSubscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationsWithSubscribers(NotificationWithSubscribers ... notificationsWithSubscribers) {
            this.notificationsWithSubscribers(Arrays.asList(notificationsWithSubscribers));
            return this;
        }

        public final void setNotificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier.copy(notificationsWithSubscribers);
        }

        @SafeVarargs
        public final void setNotificationsWithSubscribers(NotificationWithSubscribers ... notificationsWithSubscribers) {
            this.notificationsWithSubscribers(Arrays.asList(notificationsWithSubscribers));
        }

        public CreateBudgetRequest build() {
            return new CreateBudgetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateBudgetRequest> {
        public Builder accountId(String var1);

        public Builder budget(Budget var1);

        public Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> var1);

        public Builder notificationsWithSubscribers(NotificationWithSubscribers ... var1);
    }
}

