/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.CostTypesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CostTypes
implements StructuredPojo,
ToCopyableBuilder<Builder, CostTypes> {
    private final Boolean includeTax;
    private final Boolean includeSubscription;
    private final Boolean useBlended;

    private CostTypes(BuilderImpl builder) {
        this.includeTax = builder.includeTax;
        this.includeSubscription = builder.includeSubscription;
        this.useBlended = builder.useBlended;
    }

    public Boolean includeTax() {
        return this.includeTax;
    }

    public Boolean includeSubscription() {
        return this.includeSubscription;
    }

    public Boolean useBlended() {
        return this.useBlended;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.includeTax() == null ? 0 : this.includeTax().hashCode());
        hashCode = 31 * hashCode + (this.includeSubscription() == null ? 0 : this.includeSubscription().hashCode());
        hashCode = 31 * hashCode + (this.useBlended() == null ? 0 : this.useBlended().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostTypes)) {
            return false;
        }
        CostTypes other = (CostTypes)obj;
        if (other.includeTax() == null ^ this.includeTax() == null) {
            return false;
        }
        if (other.includeTax() != null && !other.includeTax().equals(this.includeTax())) {
            return false;
        }
        if (other.includeSubscription() == null ^ this.includeSubscription() == null) {
            return false;
        }
        if (other.includeSubscription() != null && !other.includeSubscription().equals(this.includeSubscription())) {
            return false;
        }
        if (other.useBlended() == null ^ this.useBlended() == null) {
            return false;
        }
        return other.useBlended() == null || other.useBlended().equals(this.useBlended());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.includeTax() != null) {
            sb.append("IncludeTax: ").append(this.includeTax()).append(",");
        }
        if (this.includeSubscription() != null) {
            sb.append("IncludeSubscription: ").append(this.includeSubscription()).append(",");
        }
        if (this.useBlended() != null) {
            sb.append("UseBlended: ").append(this.useBlended()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CostTypesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean includeTax;
        private Boolean includeSubscription;
        private Boolean useBlended;

        private BuilderImpl() {
        }

        private BuilderImpl(CostTypes model) {
            this.setIncludeTax(model.includeTax);
            this.setIncludeSubscription(model.includeSubscription);
            this.setUseBlended(model.useBlended);
        }

        public final Boolean getIncludeTax() {
            return this.includeTax;
        }

        @Override
        public final Builder includeTax(Boolean includeTax) {
            this.includeTax = includeTax;
            return this;
        }

        public final void setIncludeTax(Boolean includeTax) {
            this.includeTax = includeTax;
        }

        public final Boolean getIncludeSubscription() {
            return this.includeSubscription;
        }

        @Override
        public final Builder includeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
            return this;
        }

        public final void setIncludeSubscription(Boolean includeSubscription) {
            this.includeSubscription = includeSubscription;
        }

        public final Boolean getUseBlended() {
            return this.useBlended;
        }

        @Override
        public final Builder useBlended(Boolean useBlended) {
            this.useBlended = useBlended;
            return this;
        }

        public final void setUseBlended(Boolean useBlended) {
            this.useBlended = useBlended;
        }

        public CostTypes build() {
            return new CostTypes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CostTypes> {
        public Builder includeTax(Boolean var1);

        public Builder includeSubscription(Boolean var1);

        public Builder useBlended(Boolean var1);
    }
}

