/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemListElement;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse;

public class ListCustomLineItemsIterable
implements SdkIterable<ListCustomLineItemsResponse> {
    private final BillingconductorClient client;
    private final ListCustomLineItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomLineItemsIterable(BillingconductorClient client, ListCustomLineItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomLineItemsResponseFetcher();
    }

    public Iterator<ListCustomLineItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomLineItemListElement> customLineItems() {
        Function<ListCustomLineItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customLineItems() != null) {
                return response.customLineItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomLineItemsResponseFetcher
    implements SyncPageFetcher<ListCustomLineItemsResponse> {
        private ListCustomLineItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomLineItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomLineItemsResponse nextPage(ListCustomLineItemsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomLineItemsIterable.this.client.listCustomLineItems(ListCustomLineItemsIterable.this.firstRequest);
            }
            return ListCustomLineItemsIterable.this.client.listCustomLineItems((ListCustomLineItemsRequest)((Object)ListCustomLineItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

