/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billing.BillingClient;
import software.amazon.awssdk.services.billing.internal.UserAgentUtils;
import software.amazon.awssdk.services.billing.model.BillingViewListElement;
import software.amazon.awssdk.services.billing.model.ListBillingViewsRequest;
import software.amazon.awssdk.services.billing.model.ListBillingViewsResponse;

public class ListBillingViewsIterable
implements SdkIterable<ListBillingViewsResponse> {
    private final BillingClient client;
    private final ListBillingViewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillingViewsIterable(BillingClient client, ListBillingViewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillingViewsResponseFetcher();
    }

    public Iterator<ListBillingViewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillingViewListElement> billingViews() {
        Function<ListBillingViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingViews() != null) {
                return response.billingViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillingViewsResponseFetcher
    implements SyncPageFetcher<ListBillingViewsResponse> {
        private ListBillingViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillingViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillingViewsResponse nextPage(ListBillingViewsResponse previousPage) {
            if (previousPage == null) {
                return ListBillingViewsIterable.this.client.listBillingViews(ListBillingViewsIterable.this.firstRequest);
            }
            return ListBillingViewsIterable.this.client.listBillingViews((ListBillingViewsRequest)((Object)ListBillingViewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

