/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billing.BillingClient;
import software.amazon.awssdk.services.billing.internal.UserAgentUtils;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse;

public class ListSourceViewsForBillingViewIterable
implements SdkIterable<ListSourceViewsForBillingViewResponse> {
    private final BillingClient client;
    private final ListSourceViewsForBillingViewRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourceViewsForBillingViewIterable(BillingClient client, ListSourceViewsForBillingViewRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSourceViewsForBillingViewResponseFetcher();
    }

    public Iterator<ListSourceViewsForBillingViewResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> sourceViews() {
        Function<ListSourceViewsForBillingViewResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceViews() != null) {
                return response.sourceViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourceViewsForBillingViewResponseFetcher
    implements SyncPageFetcher<ListSourceViewsForBillingViewResponse> {
        private ListSourceViewsForBillingViewResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceViewsForBillingViewResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourceViewsForBillingViewResponse nextPage(ListSourceViewsForBillingViewResponse previousPage) {
            if (previousPage == null) {
                return ListSourceViewsForBillingViewIterable.this.client.listSourceViewsForBillingView(ListSourceViewsForBillingViewIterable.this.firstRequest);
            }
            return ListSourceViewsForBillingViewIterable.this.client.listSourceViewsForBillingView((ListSourceViewsForBillingViewRequest)((Object)ListSourceViewsForBillingViewIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

