/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billing.model.ActiveTimeRange;
import software.amazon.awssdk.services.billing.model.BillingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingViewsRequest
extends BillingRequest
implements ToCopyableBuilder<Builder, ListBillingViewsRequest> {
    private static final SdkField<ActiveTimeRange> ACTIVE_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("activeTimeRange").getter(ListBillingViewsRequest.getter(ListBillingViewsRequest::activeTimeRange)).setter(ListBillingViewsRequest.setter(Builder::activeTimeRange)).constructor(ActiveTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeTimeRange").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListBillingViewsRequest.getter(ListBillingViewsRequest::maxResults)).setter(ListBillingViewsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBillingViewsRequest.getter(ListBillingViewsRequest::nextToken)).setter(ListBillingViewsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_TIME_RANGE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("activeTimeRange", ACTIVE_TIME_RANGE_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final ActiveTimeRange activeTimeRange;
    private final Integer maxResults;
    private final String nextToken;

    private ListBillingViewsRequest(BuilderImpl builder) {
        super(builder);
        this.activeTimeRange = builder.activeTimeRange;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final ActiveTimeRange activeTimeRange() {
        return this.activeTimeRange;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activeTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingViewsRequest)) {
            return false;
        }
        ListBillingViewsRequest other = (ListBillingViewsRequest)((Object)obj);
        return Objects.equals(this.activeTimeRange(), other.activeTimeRange()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillingViewsRequest").add("ActiveTimeRange", (Object)this.activeTimeRange()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeTimeRange": {
                return Optional.ofNullable(clazz.cast(this.activeTimeRange()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingViewsRequest, T> g) {
        return obj -> g.apply((ListBillingViewsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingRequest.BuilderImpl
    implements Builder {
        private ActiveTimeRange activeTimeRange;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingViewsRequest model) {
            super(model);
            this.activeTimeRange(model.activeTimeRange);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final ActiveTimeRange.Builder getActiveTimeRange() {
            return this.activeTimeRange != null ? this.activeTimeRange.toBuilder() : null;
        }

        public final void setActiveTimeRange(ActiveTimeRange.BuilderImpl activeTimeRange) {
            this.activeTimeRange = activeTimeRange != null ? activeTimeRange.build() : null;
        }

        @Override
        public final Builder activeTimeRange(ActiveTimeRange activeTimeRange) {
            this.activeTimeRange = activeTimeRange;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBillingViewsRequest build() {
            return new ListBillingViewsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBillingViewsRequest> {
        public Builder activeTimeRange(ActiveTimeRange var1);

        default public Builder activeTimeRange(Consumer<ActiveTimeRange.Builder> activeTimeRange) {
            return this.activeTimeRange((ActiveTimeRange)((ActiveTimeRange.Builder)ActiveTimeRange.builder().applyMutation(activeTimeRange)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

