/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specification for the tool. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Call a tool with the Converse API</a> in
 * the Amazon Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolSpecification.Builder, ToolSpecification> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ToolSpecification::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ToolSpecification::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ToolInputSchema> INPUT_SCHEMA_FIELD = SdkField
            .<ToolInputSchema> builder(MarshallingType.SDK_POJO).memberName("inputSchema")
            .getter(getter(ToolSpecification::inputSchema)).setter(setter(Builder::inputSchema))
            .constructor(ToolInputSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            INPUT_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final ToolInputSchema inputSchema;

    private ToolSpecification(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.inputSchema = builder.inputSchema;
    }

    /**
     * <p>
     * The name for the tool.
     * </p>
     * 
     * @return The name for the tool.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the tool.
     * </p>
     * 
     * @return The description for the tool.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The input schema for the tool in JSON format.
     * </p>
     * 
     * @return The input schema for the tool in JSON format.
     */
    public final ToolInputSchema inputSchema() {
        return inputSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolSpecification)) {
            return false;
        }
        ToolSpecification other = (ToolSpecification) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(inputSchema(), other.inputSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolSpecification").add("Name", name()).add("Description", description())
                .add("InputSchema", inputSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputSchema":
            return Optional.ofNullable(clazz.cast(inputSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputSchema", INPUT_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolSpecification, T> g) {
        return obj -> g.apply((ToolSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolSpecification> {
        /**
         * <p>
         * The name for the tool.
         * </p>
         * 
         * @param name
         *        The name for the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the tool.
         * </p>
         * 
         * @param description
         *        The description for the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The input schema for the tool in JSON format.
         * </p>
         * 
         * @param inputSchema
         *        The input schema for the tool in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(ToolInputSchema inputSchema);

        /**
         * <p>
         * The input schema for the tool in JSON format.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolInputSchema.Builder} avoiding the
         * need to create one manually via {@link ToolInputSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolInputSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchema(ToolInputSchema)}.
         * 
         * @param inputSchema
         *        a consumer that will call methods on {@link ToolInputSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchema(ToolInputSchema)
         */
        default Builder inputSchema(Consumer<ToolInputSchema.Builder> inputSchema) {
            return inputSchema(ToolInputSchema.builder().applyMutation(inputSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private ToolInputSchema inputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolSpecification model) {
            name(model.name);
            description(model.description);
            inputSchema(model.inputSchema);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ToolInputSchema.Builder getInputSchema() {
            return inputSchema != null ? inputSchema.toBuilder() : null;
        }

        public final void setInputSchema(ToolInputSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        public final Builder inputSchema(ToolInputSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        @Override
        public ToolSpecification build() {
            return new ToolSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
