/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the precise location within a source document where cited content can be found. This can include
 * character-level positions, page numbers, or document chunks depending on the document type and indexing method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CitationLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<CitationLocation.Builder, CitationLocation> {
    private static final SdkField<WebLocation> WEB_FIELD = SdkField.<WebLocation> builder(MarshallingType.SDK_POJO)
            .memberName("web").getter(getter(CitationLocation::web)).setter(setter(Builder::web))
            .constructor(WebLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("web").build()).build();

    private static final SdkField<DocumentCharLocation> DOCUMENT_CHAR_FIELD = SdkField
            .<DocumentCharLocation> builder(MarshallingType.SDK_POJO).memberName("documentChar")
            .getter(getter(CitationLocation::documentChar)).setter(setter(Builder::documentChar))
            .constructor(DocumentCharLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentChar").build()).build();

    private static final SdkField<DocumentPageLocation> DOCUMENT_PAGE_FIELD = SdkField
            .<DocumentPageLocation> builder(MarshallingType.SDK_POJO).memberName("documentPage")
            .getter(getter(CitationLocation::documentPage)).setter(setter(Builder::documentPage))
            .constructor(DocumentPageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentPage").build()).build();

    private static final SdkField<DocumentChunkLocation> DOCUMENT_CHUNK_FIELD = SdkField
            .<DocumentChunkLocation> builder(MarshallingType.SDK_POJO).memberName("documentChunk")
            .getter(getter(CitationLocation::documentChunk)).setter(setter(Builder::documentChunk))
            .constructor(DocumentChunkLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentChunk").build()).build();

    private static final SdkField<SearchResultLocation> SEARCH_RESULT_LOCATION_FIELD = SdkField
            .<SearchResultLocation> builder(MarshallingType.SDK_POJO).memberName("searchResultLocation")
            .getter(getter(CitationLocation::searchResultLocation)).setter(setter(Builder::searchResultLocation))
            .constructor(SearchResultLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResultLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_FIELD,
            DOCUMENT_CHAR_FIELD, DOCUMENT_PAGE_FIELD, DOCUMENT_CHUNK_FIELD, SEARCH_RESULT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WebLocation web;

    private final DocumentCharLocation documentChar;

    private final DocumentPageLocation documentPage;

    private final DocumentChunkLocation documentChunk;

    private final SearchResultLocation searchResultLocation;

    private final Type type;

    private CitationLocation(BuilderImpl builder) {
        this.web = builder.web;
        this.documentChar = builder.documentChar;
        this.documentPage = builder.documentPage;
        this.documentChunk = builder.documentChunk;
        this.searchResultLocation = builder.searchResultLocation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The web URL that was cited for this reference.
     * </p>
     * 
     * @return The web URL that was cited for this reference.
     */
    public final WebLocation web() {
        return web;
    }

    /**
     * <p>
     * The character-level location within the document where the cited content is found.
     * </p>
     * 
     * @return The character-level location within the document where the cited content is found.
     */
    public final DocumentCharLocation documentChar() {
        return documentChar;
    }

    /**
     * <p>
     * The page-level location within the document where the cited content is found.
     * </p>
     * 
     * @return The page-level location within the document where the cited content is found.
     */
    public final DocumentPageLocation documentPage() {
        return documentPage;
    }

    /**
     * <p>
     * The chunk-level location within the document where the cited content is found, typically used for documents that
     * have been segmented into logical chunks.
     * </p>
     * 
     * @return The chunk-level location within the document where the cited content is found, typically used for
     *         documents that have been segmented into logical chunks.
     */
    public final DocumentChunkLocation documentChunk() {
        return documentChunk;
    }

    /**
     * <p>
     * The search result location where the cited content is found, including the search result index and block
     * positions within the content array.
     * </p>
     * 
     * @return The search result location where the cited content is found, including the search result index and block
     *         positions within the content array.
     */
    public final SearchResultLocation searchResultLocation() {
        return searchResultLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(web());
        hashCode = 31 * hashCode + Objects.hashCode(documentChar());
        hashCode = 31 * hashCode + Objects.hashCode(documentPage());
        hashCode = 31 * hashCode + Objects.hashCode(documentChunk());
        hashCode = 31 * hashCode + Objects.hashCode(searchResultLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationLocation)) {
            return false;
        }
        CitationLocation other = (CitationLocation) obj;
        return Objects.equals(web(), other.web()) && Objects.equals(documentChar(), other.documentChar())
                && Objects.equals(documentPage(), other.documentPage()) && Objects.equals(documentChunk(), other.documentChunk())
                && Objects.equals(searchResultLocation(), other.searchResultLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CitationLocation").add("Web", web()).add("DocumentChar", documentChar())
                .add("DocumentPage", documentPage()).add("DocumentChunk", documentChunk())
                .add("SearchResultLocation", searchResultLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "web":
            return Optional.ofNullable(clazz.cast(web()));
        case "documentChar":
            return Optional.ofNullable(clazz.cast(documentChar()));
        case "documentPage":
            return Optional.ofNullable(clazz.cast(documentPage()));
        case "documentChunk":
            return Optional.ofNullable(clazz.cast(documentChunk()));
        case "searchResultLocation":
            return Optional.ofNullable(clazz.cast(searchResultLocation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #web()} initialized to the given value.
     *
     * <p>
     * The web URL that was cited for this reference.
     * </p>
     * 
     * @param web
     *        The web URL that was cited for this reference.
     */
    public static CitationLocation fromWeb(WebLocation web) {
        return builder().web(web).build();
    }

    /**
     * Create an instance of this class with {@link #web()} initialized to the given value.
     *
     * <p>
     * The web URL that was cited for this reference.
     * </p>
     * 
     * @param web
     *        The web URL that was cited for this reference.
     */
    public static CitationLocation fromWeb(Consumer<WebLocation.Builder> web) {
        WebLocation.Builder builder = WebLocation.builder();
        web.accept(builder);
        return fromWeb(builder.build());
    }

    /**
     * Create an instance of this class with {@link #documentChar()} initialized to the given value.
     *
     * <p>
     * The character-level location within the document where the cited content is found.
     * </p>
     * 
     * @param documentChar
     *        The character-level location within the document where the cited content is found.
     */
    public static CitationLocation fromDocumentChar(DocumentCharLocation documentChar) {
        return builder().documentChar(documentChar).build();
    }

    /**
     * Create an instance of this class with {@link #documentChar()} initialized to the given value.
     *
     * <p>
     * The character-level location within the document where the cited content is found.
     * </p>
     * 
     * @param documentChar
     *        The character-level location within the document where the cited content is found.
     */
    public static CitationLocation fromDocumentChar(Consumer<DocumentCharLocation.Builder> documentChar) {
        DocumentCharLocation.Builder builder = DocumentCharLocation.builder();
        documentChar.accept(builder);
        return fromDocumentChar(builder.build());
    }

    /**
     * Create an instance of this class with {@link #documentPage()} initialized to the given value.
     *
     * <p>
     * The page-level location within the document where the cited content is found.
     * </p>
     * 
     * @param documentPage
     *        The page-level location within the document where the cited content is found.
     */
    public static CitationLocation fromDocumentPage(DocumentPageLocation documentPage) {
        return builder().documentPage(documentPage).build();
    }

    /**
     * Create an instance of this class with {@link #documentPage()} initialized to the given value.
     *
     * <p>
     * The page-level location within the document where the cited content is found.
     * </p>
     * 
     * @param documentPage
     *        The page-level location within the document where the cited content is found.
     */
    public static CitationLocation fromDocumentPage(Consumer<DocumentPageLocation.Builder> documentPage) {
        DocumentPageLocation.Builder builder = DocumentPageLocation.builder();
        documentPage.accept(builder);
        return fromDocumentPage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #documentChunk()} initialized to the given value.
     *
     * <p>
     * The chunk-level location within the document where the cited content is found, typically used for documents that
     * have been segmented into logical chunks.
     * </p>
     * 
     * @param documentChunk
     *        The chunk-level location within the document where the cited content is found, typically used for
     *        documents that have been segmented into logical chunks.
     */
    public static CitationLocation fromDocumentChunk(DocumentChunkLocation documentChunk) {
        return builder().documentChunk(documentChunk).build();
    }

    /**
     * Create an instance of this class with {@link #documentChunk()} initialized to the given value.
     *
     * <p>
     * The chunk-level location within the document where the cited content is found, typically used for documents that
     * have been segmented into logical chunks.
     * </p>
     * 
     * @param documentChunk
     *        The chunk-level location within the document where the cited content is found, typically used for
     *        documents that have been segmented into logical chunks.
     */
    public static CitationLocation fromDocumentChunk(Consumer<DocumentChunkLocation.Builder> documentChunk) {
        DocumentChunkLocation.Builder builder = DocumentChunkLocation.builder();
        documentChunk.accept(builder);
        return fromDocumentChunk(builder.build());
    }

    /**
     * Create an instance of this class with {@link #searchResultLocation()} initialized to the given value.
     *
     * <p>
     * The search result location where the cited content is found, including the search result index and block
     * positions within the content array.
     * </p>
     * 
     * @param searchResultLocation
     *        The search result location where the cited content is found, including the search result index and block
     *        positions within the content array.
     */
    public static CitationLocation fromSearchResultLocation(SearchResultLocation searchResultLocation) {
        return builder().searchResultLocation(searchResultLocation).build();
    }

    /**
     * Create an instance of this class with {@link #searchResultLocation()} initialized to the given value.
     *
     * <p>
     * The search result location where the cited content is found, including the search result index and block
     * positions within the content array.
     * </p>
     * 
     * @param searchResultLocation
     *        The search result location where the cited content is found, including the search result index and block
     *        positions within the content array.
     */
    public static CitationLocation fromSearchResultLocation(Consumer<SearchResultLocation.Builder> searchResultLocation) {
        SearchResultLocation.Builder builder = SearchResultLocation.builder();
        searchResultLocation.accept(builder);
        return fromSearchResultLocation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("web", WEB_FIELD);
        map.put("documentChar", DOCUMENT_CHAR_FIELD);
        map.put("documentPage", DOCUMENT_PAGE_FIELD);
        map.put("documentChunk", DOCUMENT_CHUNK_FIELD);
        map.put("searchResultLocation", SEARCH_RESULT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationLocation, T> g) {
        return obj -> g.apply((CitationLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CitationLocation> {
        /**
         * <p>
         * The web URL that was cited for this reference.
         * </p>
         * 
         * @param web
         *        The web URL that was cited for this reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder web(WebLocation web);

        /**
         * <p>
         * The web URL that was cited for this reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebLocation.Builder} avoiding the need to
         * create one manually via {@link WebLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #web(WebLocation)}.
         * 
         * @param web
         *        a consumer that will call methods on {@link WebLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #web(WebLocation)
         */
        default Builder web(Consumer<WebLocation.Builder> web) {
            return web(WebLocation.builder().applyMutation(web).build());
        }

        /**
         * <p>
         * The character-level location within the document where the cited content is found.
         * </p>
         * 
         * @param documentChar
         *        The character-level location within the document where the cited content is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentChar(DocumentCharLocation documentChar);

        /**
         * <p>
         * The character-level location within the document where the cited content is found.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentCharLocation.Builder} avoiding
         * the need to create one manually via {@link DocumentCharLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentCharLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #documentChar(DocumentCharLocation)}.
         * 
         * @param documentChar
         *        a consumer that will call methods on {@link DocumentCharLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentChar(DocumentCharLocation)
         */
        default Builder documentChar(Consumer<DocumentCharLocation.Builder> documentChar) {
            return documentChar(DocumentCharLocation.builder().applyMutation(documentChar).build());
        }

        /**
         * <p>
         * The page-level location within the document where the cited content is found.
         * </p>
         * 
         * @param documentPage
         *        The page-level location within the document where the cited content is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentPage(DocumentPageLocation documentPage);

        /**
         * <p>
         * The page-level location within the document where the cited content is found.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentPageLocation.Builder} avoiding
         * the need to create one manually via {@link DocumentPageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentPageLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #documentPage(DocumentPageLocation)}.
         * 
         * @param documentPage
         *        a consumer that will call methods on {@link DocumentPageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentPage(DocumentPageLocation)
         */
        default Builder documentPage(Consumer<DocumentPageLocation.Builder> documentPage) {
            return documentPage(DocumentPageLocation.builder().applyMutation(documentPage).build());
        }

        /**
         * <p>
         * The chunk-level location within the document where the cited content is found, typically used for documents
         * that have been segmented into logical chunks.
         * </p>
         * 
         * @param documentChunk
         *        The chunk-level location within the document where the cited content is found, typically used for
         *        documents that have been segmented into logical chunks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentChunk(DocumentChunkLocation documentChunk);

        /**
         * <p>
         * The chunk-level location within the document where the cited content is found, typically used for documents
         * that have been segmented into logical chunks.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentChunkLocation.Builder} avoiding
         * the need to create one manually via {@link DocumentChunkLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentChunkLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #documentChunk(DocumentChunkLocation)}.
         * 
         * @param documentChunk
         *        a consumer that will call methods on {@link DocumentChunkLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentChunk(DocumentChunkLocation)
         */
        default Builder documentChunk(Consumer<DocumentChunkLocation.Builder> documentChunk) {
            return documentChunk(DocumentChunkLocation.builder().applyMutation(documentChunk).build());
        }

        /**
         * <p>
         * The search result location where the cited content is found, including the search result index and block
         * positions within the content array.
         * </p>
         * 
         * @param searchResultLocation
         *        The search result location where the cited content is found, including the search result index and
         *        block positions within the content array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResultLocation(SearchResultLocation searchResultLocation);

        /**
         * <p>
         * The search result location where the cited content is found, including the search result index and block
         * positions within the content array.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchResultLocation.Builder} avoiding
         * the need to create one manually via {@link SearchResultLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchResultLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #searchResultLocation(SearchResultLocation)}.
         * 
         * @param searchResultLocation
         *        a consumer that will call methods on {@link SearchResultLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchResultLocation(SearchResultLocation)
         */
        default Builder searchResultLocation(Consumer<SearchResultLocation.Builder> searchResultLocation) {
            return searchResultLocation(SearchResultLocation.builder().applyMutation(searchResultLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WebLocation web;

        private DocumentCharLocation documentChar;

        private DocumentPageLocation documentPage;

        private DocumentChunkLocation documentChunk;

        private SearchResultLocation searchResultLocation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CitationLocation model) {
            web(model.web);
            documentChar(model.documentChar);
            documentPage(model.documentPage);
            documentChunk(model.documentChunk);
            searchResultLocation(model.searchResultLocation);
        }

        public final WebLocation.Builder getWeb() {
            return web != null ? web.toBuilder() : null;
        }

        public final void setWeb(WebLocation.BuilderImpl web) {
            Object oldValue = this.web;
            this.web = web != null ? web.build() : null;
            handleUnionValueChange(Type.WEB, oldValue, this.web);
        }

        @Override
        public final Builder web(WebLocation web) {
            Object oldValue = this.web;
            this.web = web;
            handleUnionValueChange(Type.WEB, oldValue, this.web);
            return this;
        }

        public final DocumentCharLocation.Builder getDocumentChar() {
            return documentChar != null ? documentChar.toBuilder() : null;
        }

        public final void setDocumentChar(DocumentCharLocation.BuilderImpl documentChar) {
            Object oldValue = this.documentChar;
            this.documentChar = documentChar != null ? documentChar.build() : null;
            handleUnionValueChange(Type.DOCUMENT_CHAR, oldValue, this.documentChar);
        }

        @Override
        public final Builder documentChar(DocumentCharLocation documentChar) {
            Object oldValue = this.documentChar;
            this.documentChar = documentChar;
            handleUnionValueChange(Type.DOCUMENT_CHAR, oldValue, this.documentChar);
            return this;
        }

        public final DocumentPageLocation.Builder getDocumentPage() {
            return documentPage != null ? documentPage.toBuilder() : null;
        }

        public final void setDocumentPage(DocumentPageLocation.BuilderImpl documentPage) {
            Object oldValue = this.documentPage;
            this.documentPage = documentPage != null ? documentPage.build() : null;
            handleUnionValueChange(Type.DOCUMENT_PAGE, oldValue, this.documentPage);
        }

        @Override
        public final Builder documentPage(DocumentPageLocation documentPage) {
            Object oldValue = this.documentPage;
            this.documentPage = documentPage;
            handleUnionValueChange(Type.DOCUMENT_PAGE, oldValue, this.documentPage);
            return this;
        }

        public final DocumentChunkLocation.Builder getDocumentChunk() {
            return documentChunk != null ? documentChunk.toBuilder() : null;
        }

        public final void setDocumentChunk(DocumentChunkLocation.BuilderImpl documentChunk) {
            Object oldValue = this.documentChunk;
            this.documentChunk = documentChunk != null ? documentChunk.build() : null;
            handleUnionValueChange(Type.DOCUMENT_CHUNK, oldValue, this.documentChunk);
        }

        @Override
        public final Builder documentChunk(DocumentChunkLocation documentChunk) {
            Object oldValue = this.documentChunk;
            this.documentChunk = documentChunk;
            handleUnionValueChange(Type.DOCUMENT_CHUNK, oldValue, this.documentChunk);
            return this;
        }

        public final SearchResultLocation.Builder getSearchResultLocation() {
            return searchResultLocation != null ? searchResultLocation.toBuilder() : null;
        }

        public final void setSearchResultLocation(SearchResultLocation.BuilderImpl searchResultLocation) {
            Object oldValue = this.searchResultLocation;
            this.searchResultLocation = searchResultLocation != null ? searchResultLocation.build() : null;
            handleUnionValueChange(Type.SEARCH_RESULT_LOCATION, oldValue, this.searchResultLocation);
        }

        @Override
        public final Builder searchResultLocation(SearchResultLocation searchResultLocation) {
            Object oldValue = this.searchResultLocation;
            this.searchResultLocation = searchResultLocation;
            handleUnionValueChange(Type.SEARCH_RESULT_LOCATION, oldValue, this.searchResultLocation);
            return this;
        }

        @Override
        public CitationLocation build() {
            return new CitationLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CitationLocation#type()
     */
    public enum Type {
        WEB,

        DOCUMENT_CHAR,

        DOCUMENT_PAGE,

        DOCUMENT_CHUNK,

        SEARCH_RESULT_LOCATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
