/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A system content block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemContentBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemContentBlock.Builder, SystemContentBlock> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(SystemContentBlock::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<GuardrailConverseContentBlock> GUARD_CONTENT_FIELD = SdkField
            .<GuardrailConverseContentBlock> builder(MarshallingType.SDK_POJO).memberName("guardContent")
            .getter(getter(SystemContentBlock::guardContent)).setter(setter(Builder::guardContent))
            .constructor(GuardrailConverseContentBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()).build();

    private static final SdkField<CachePointBlock> CACHE_POINT_FIELD = SdkField
            .<CachePointBlock> builder(MarshallingType.SDK_POJO).memberName("cachePoint")
            .getter(getter(SystemContentBlock::cachePoint)).setter(setter(Builder::cachePoint))
            .constructor(CachePointBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachePoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD,
            GUARD_CONTENT_FIELD, CACHE_POINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String text;

    private final GuardrailConverseContentBlock guardContent;

    private final CachePointBlock cachePoint;

    private final Type type;

    private SystemContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.guardContent = builder.guardContent;
        this.cachePoint = builder.cachePoint;
        this.type = builder.type;
    }

    /**
     * <p>
     * A system prompt for the model.
     * </p>
     * 
     * @return A system prompt for the model.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * A content block to assess with the guardrail. Use with the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>
     * API operations.
     * </p>
     * <p>
     * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * 
     * @return A content block to assess with the guardrail. Use with the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or
     *         <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">
     *         ConverseStream</a> API operations. </p>
     *         <p>
     *         For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
     *         Guide</i>.
     */
    public final GuardrailConverseContentBlock guardContent() {
        return guardContent;
    }

    /**
     * <p>
     * CachePoint to include in the system prompt.
     * </p>
     * 
     * @return CachePoint to include in the system prompt.
     */
    public final CachePointBlock cachePoint() {
        return cachePoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(cachePoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemContentBlock)) {
            return false;
        }
        SystemContentBlock other = (SystemContentBlock) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(guardContent(), other.guardContent())
                && Objects.equals(cachePoint(), other.cachePoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemContentBlock").add("Text", text()).add("GuardContent", guardContent())
                .add("CachePoint", cachePoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "guardContent":
            return Optional.ofNullable(clazz.cast(guardContent()));
        case "cachePoint":
            return Optional.ofNullable(clazz.cast(cachePoint()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * A system prompt for the model.
     * </p>
     * 
     * @param text
     *        A system prompt for the model.
     */
    public static SystemContentBlock fromText(String text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #guardContent()} initialized to the given value.
     *
     * <p>
     * A content block to assess with the guardrail. Use with the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>
     * API operations.
     * </p>
     * <p>
     * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * 
     * @param guardContent
     *        A content block to assess with the guardrail. Use with the <a
     *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or
     *        <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">
     *        ConverseStream</a> API operations. </p>
     *        <p>
     *        For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
     *        Guide</i>.
     */
    public static SystemContentBlock fromGuardContent(GuardrailConverseContentBlock guardContent) {
        return builder().guardContent(guardContent).build();
    }

    /**
     * Create an instance of this class with {@link #guardContent()} initialized to the given value.
     *
     * <p>
     * A content block to assess with the guardrail. Use with the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>
     * API operations.
     * </p>
     * <p>
     * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * </p>
     * 
     * @param guardContent
     *        A content block to assess with the guardrail. Use with the <a
     *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or
     *        <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">
     *        ConverseStream</a> API operations. </p>
     *        <p>
     *        For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
     *        Guide</i>.
     */
    public static SystemContentBlock fromGuardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
        GuardrailConverseContentBlock.Builder builder = GuardrailConverseContentBlock.builder();
        guardContent.accept(builder);
        return fromGuardContent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cachePoint()} initialized to the given value.
     *
     * <p>
     * CachePoint to include in the system prompt.
     * </p>
     * 
     * @param cachePoint
     *        CachePoint to include in the system prompt.
     */
    public static SystemContentBlock fromCachePoint(CachePointBlock cachePoint) {
        return builder().cachePoint(cachePoint).build();
    }

    /**
     * Create an instance of this class with {@link #cachePoint()} initialized to the given value.
     *
     * <p>
     * CachePoint to include in the system prompt.
     * </p>
     * 
     * @param cachePoint
     *        CachePoint to include in the system prompt.
     */
    public static SystemContentBlock fromCachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
        CachePointBlock.Builder builder = CachePointBlock.builder();
        cachePoint.accept(builder);
        return fromCachePoint(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("cachePoint", CACHE_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SystemContentBlock, T> g) {
        return obj -> g.apply((SystemContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemContentBlock> {
        /**
         * <p>
         * A system prompt for the model.
         * </p>
         * 
         * @param text
         *        A system prompt for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * A content block to assess with the guardrail. Use with the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a
         * href
         * ="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>
         * API operations.
         * </p>
         * <p>
         * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
         * Guide</i>.
         * </p>
         * 
         * @param guardContent
         *        A content block to assess with the guardrail. Use with the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a>
         *        or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">
         *        ConverseStream</a> API operations. </p>
         *        <p>
         *        For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardContent(GuardrailConverseContentBlock guardContent);

        /**
         * <p>
         * A content block to assess with the guardrail. Use with the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a
         * href
         * ="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>
         * API operations.
         * </p>
         * <p>
         * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
         * Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConverseContentBlock.Builder}
         * avoiding the need to create one manually via {@link GuardrailConverseContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConverseContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #guardContent(GuardrailConverseContentBlock)}.
         * 
         * @param guardContent
         *        a consumer that will call methods on {@link GuardrailConverseContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardContent(GuardrailConverseContentBlock)
         */
        default Builder guardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
            return guardContent(GuardrailConverseContentBlock.builder().applyMutation(guardContent).build());
        }

        /**
         * <p>
         * CachePoint to include in the system prompt.
         * </p>
         * 
         * @param cachePoint
         *        CachePoint to include in the system prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePoint(CachePointBlock cachePoint);

        /**
         * <p>
         * CachePoint to include in the system prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link CachePointBlock.Builder} avoiding the
         * need to create one manually via {@link CachePointBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CachePointBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePoint(CachePointBlock)}.
         * 
         * @param cachePoint
         *        a consumer that will call methods on {@link CachePointBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePoint(CachePointBlock)
         */
        default Builder cachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
            return cachePoint(CachePointBlock.builder().applyMutation(cachePoint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private GuardrailConverseContentBlock guardContent;

        private CachePointBlock cachePoint;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SystemContentBlock model) {
            text(model.text);
            guardContent(model.guardContent);
            cachePoint(model.cachePoint);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final GuardrailConverseContentBlock.Builder getGuardContent() {
            return guardContent != null ? guardContent.toBuilder() : null;
        }

        public final void setGuardContent(GuardrailConverseContentBlock.BuilderImpl guardContent) {
            Object oldValue = this.guardContent;
            this.guardContent = guardContent != null ? guardContent.build() : null;
            handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
        }

        @Override
        public final Builder guardContent(GuardrailConverseContentBlock guardContent) {
            Object oldValue = this.guardContent;
            this.guardContent = guardContent;
            handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
            return this;
        }

        public final CachePointBlock.Builder getCachePoint() {
            return cachePoint != null ? cachePoint.toBuilder() : null;
        }

        public final void setCachePoint(CachePointBlock.BuilderImpl cachePoint) {
            Object oldValue = this.cachePoint;
            this.cachePoint = cachePoint != null ? cachePoint.build() : null;
            handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
        }

        @Override
        public final Builder cachePoint(CachePointBlock cachePoint) {
            Object oldValue = this.cachePoint;
            this.cachePoint = cachePoint;
            handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
            return this;
        }

        @Override
        public SystemContentBlock build() {
            return new SystemContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SystemContentBlock#type()
     */
    public enum Type {
        TEXT,

        GUARD_CONTENT,

        CACHE_POINT,

        UNKNOWN_TO_SDK_VERSION
    }
}
