/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 * <p>
 * A content block for selective guarding with the <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> API
 * operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailConverseContentBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailConverseContentBlock.Builder, GuardrailConverseContentBlock> {
    private static final SdkField<GuardrailConverseTextBlock> TEXT_FIELD = SdkField
            .<GuardrailConverseTextBlock> builder(MarshallingType.SDK_POJO).memberName("text")
            .getter(getter(GuardrailConverseContentBlock::text)).setter(setter(Builder::text))
            .constructor(GuardrailConverseTextBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<GuardrailConverseImageBlock> IMAGE_FIELD = SdkField
            .<GuardrailConverseImageBlock> builder(MarshallingType.SDK_POJO).memberName("image")
            .getter(getter(GuardrailConverseContentBlock::image)).setter(setter(Builder::image))
            .constructor(GuardrailConverseImageBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, IMAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailConverseTextBlock text;

    private final GuardrailConverseImageBlock image;

    private final Type type;

    private GuardrailConverseContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.image = builder.image;
        this.type = builder.type;
    }

    /**
     * <p>
     * The text to guard.
     * </p>
     * 
     * @return The text to guard.
     */
    public final GuardrailConverseTextBlock text() {
        return text;
    }

    /**
     * <p>
     * Image within converse content block to be evaluated by the guardrail.
     * </p>
     * 
     * @return Image within converse content block to be evaluated by the guardrail.
     */
    public final GuardrailConverseImageBlock image() {
        return image;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailConverseContentBlock)) {
            return false;
        }
        GuardrailConverseContentBlock other = (GuardrailConverseContentBlock) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(image(), other.image());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailConverseContentBlock").add("Text", text())
                .add("Image", image() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * The text to guard.
     * </p>
     * 
     * @param text
     *        The text to guard.
     */
    public static GuardrailConverseContentBlock fromText(GuardrailConverseTextBlock text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * The text to guard.
     * </p>
     * 
     * @param text
     *        The text to guard.
     */
    public static GuardrailConverseContentBlock fromText(Consumer<GuardrailConverseTextBlock.Builder> text) {
        GuardrailConverseTextBlock.Builder builder = GuardrailConverseTextBlock.builder();
        text.accept(builder);
        return fromText(builder.build());
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * Image within converse content block to be evaluated by the guardrail.
     * </p>
     * 
     * @param image
     *        Image within converse content block to be evaluated by the guardrail.
     */
    public static GuardrailConverseContentBlock fromImage(GuardrailConverseImageBlock image) {
        return builder().image(image).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * Image within converse content block to be evaluated by the guardrail.
     * </p>
     * 
     * @param image
     *        Image within converse content block to be evaluated by the guardrail.
     */
    public static GuardrailConverseContentBlock fromImage(Consumer<GuardrailConverseImageBlock.Builder> image) {
        GuardrailConverseImageBlock.Builder builder = GuardrailConverseImageBlock.builder();
        image.accept(builder);
        return fromImage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("image", IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailConverseContentBlock, T> g) {
        return obj -> g.apply((GuardrailConverseContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailConverseContentBlock> {
        /**
         * <p>
         * The text to guard.
         * </p>
         * 
         * @param text
         *        The text to guard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(GuardrailConverseTextBlock text);

        /**
         * <p>
         * The text to guard.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConverseTextBlock.Builder}
         * avoiding the need to create one manually via {@link GuardrailConverseTextBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConverseTextBlock.Builder#build()} is called immediately
         * and its result is passed to {@link #text(GuardrailConverseTextBlock)}.
         * 
         * @param text
         *        a consumer that will call methods on {@link GuardrailConverseTextBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #text(GuardrailConverseTextBlock)
         */
        default Builder text(Consumer<GuardrailConverseTextBlock.Builder> text) {
            return text(GuardrailConverseTextBlock.builder().applyMutation(text).build());
        }

        /**
         * <p>
         * Image within converse content block to be evaluated by the guardrail.
         * </p>
         * 
         * @param image
         *        Image within converse content block to be evaluated by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(GuardrailConverseImageBlock image);

        /**
         * <p>
         * Image within converse content block to be evaluated by the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConverseImageBlock.Builder}
         * avoiding the need to create one manually via {@link GuardrailConverseImageBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConverseImageBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #image(GuardrailConverseImageBlock)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link GuardrailConverseImageBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(GuardrailConverseImageBlock)
         */
        default Builder image(Consumer<GuardrailConverseImageBlock.Builder> image) {
            return image(GuardrailConverseImageBlock.builder().applyMutation(image).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailConverseTextBlock text;

        private GuardrailConverseImageBlock image;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailConverseContentBlock model) {
            text(model.text);
            image(model.image);
        }

        public final GuardrailConverseTextBlock.Builder getText() {
            return text != null ? text.toBuilder() : null;
        }

        public final void setText(GuardrailConverseTextBlock.BuilderImpl text) {
            Object oldValue = this.text;
            this.text = text != null ? text.build() : null;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(GuardrailConverseTextBlock text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final GuardrailConverseImageBlock.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(GuardrailConverseImageBlock.BuilderImpl image) {
            Object oldValue = this.image;
            this.image = image != null ? image.build() : null;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(GuardrailConverseImageBlock image) {
            Object oldValue = this.image;
            this.image = image;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        @Override
        public GuardrailConverseContentBlock build() {
            return new GuardrailConverseContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GuardrailConverseContentBlock#type()
     */
    public enum Type {
        TEXT,

        IMAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
